# ==============================================================================
# PMBS configuration header
#
# SPDX-FileType: SOURCE
# SPDX-FileCopyrightText: Michael Bäuerle
# SPDX-License-Identifier: BSD-2-Clause
#
# Switch 'make' into POSIX compliant mode (must be the first non-comment line)
.POSIX:

# ------------------------------------------------------------------------------
# Project configuration

# Release version of package (used as API and ABI version for libraries too)
# See toplevel README file for versioning scheme details
PMBS_RELEASE_VERSION=0.1.3

# Library base name
# Format: libname
PMBS_LIB_NAME_BASE=libuciconv

# Library full name
# Format: libname-m (m in suffix must match major release version number above)
PMBS_LIB_NAME=$(PMBS_LIB_NAME_BASE)-0

# Name of CLI utility
PMBS_CLI_NAME=ucic0_iconv

# ------------------------------------------------------------------------------
# Installation path configurations

# Installation path prefix (must be an absolute path with leading slash)
# DESTDIR from environment is honored (prepended for installation)
PMBS_PREFIX=/usr/local

# Path component under PREFIX for man pages
# The FHS 3.0 defines "/usr[/local]/share/man".
# The location "/usr/local/man is explicitly marked deprecated.
PMBS_MANPATH=share/man

# Path component under PREFIX for pkg-config (.pc) files
PMBS_PKGCONFIGDIR=lib/pkgconfig

# ------------------------------------------------------------------------------
# POSIX shell

# POSIX does not define a path for the conformant sh (do not assume "/bin/sh")
PMBS_SH=command -p sh

