/*
 * Nonidentical conversion
 *
 * SPDX-FileType: SOURCE
 * SPDX-FileCopyrightText: Michael Bäuerle
 * SPDX-License-Identifier: BSD-2-Clause
 */

#include "libuciconv-0/iconv.h"  /* Always include main header file first */
#include "check_nul.h"


/* ========================================================================== */
ucic0_i_bool ucic0_i_check_nul(ucic0_i_state *state, const char c)
{
    if ((const char)0x00 == c)
    {
        if (!(UCIC0_ICONV_IGNORE_NULL & state->flag))
        {
            state->abort = 1;
            return 1;
        }
    }

    return 0;
}
