/*
 * SPDX-FileType: SOURCE
 * SPDX-FileCopyrightText: Michael Bäuerle
 * SPDX-License-Identifier: BSD-2-Clause
 */

#ifndef UCIC0_I_CHECK_NUL_H
#define UCIC0_I_CHECK_NUL_H  1

#include "iconv_private.h"


#pragma GCC visibility push(internal)


/*! \cond DO_NOT_DOCUMENT */


/*
 * Check whether character 'c' is a NUL control character
 *
 * Abort connversion if this is the case (or continue on user request).
 * Input and output buffers are not modified in all cases.
 *
 * Returns zero (false / no error) for accept.
 */
ucic0_i_bool ucic0_i_check_nul(ucic0_i_state *state, const char c);


/*! \endcond */


#pragma GCC visibility pop


#endif  /* UCIC0_I_CHECK_NUL_H */
