/*
	Copyright 2019 flyinghead

	This file is part of reicast.

    reicast is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 2 of the License, or
    (at your option) any later version.

    reicast is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with reicast.  If not, see <https://www.gnu.org/licenses/>.
 */
#pragma once
#include "hw/sh4/dyna/ssa_regalloc.h"
#include <aarch64/macro-assembler-aarch64.h>
using namespace vixl::aarch64;

#define ALLOC_F64 true

enum eReg {
	W0, W1, W2, W3, W4, W5, W6, W7, W8, W9, W10, W11, W12, W13, W14, W15, W16,
	W17, W18, W19, W20, W21, W22, W23, W24, W25, W26, W27, W28, W29, W30
};
enum eFReg {
	S0, S1, S2, S3, S4, S5, S6, S7, S8, S9, S10, S11, S12, S13, S14, S15, S16,
	S17, S18, S19, S20, S21, S22, S23, S24, S25, S26, S27, S28, S29, S30, S31
};

static eReg alloc_regs[] = { W19, W20, W21, W22, W23, W24, W25, W26, (eReg)-1 };
static eFReg alloc_fregs[] = { S8, S9, S10, S11, S12, S13, S14, S15, (eFReg)-1 };

class Arm64Assembler;

struct Arm64RegAlloc : RegAlloc<eReg, eFReg, ALLOC_F64>
{
	Arm64RegAlloc(Arm64Assembler *assembler) : assembler(assembler) {}

	void DoAlloc(RuntimeBlockInfo* block)
	{
		RegAlloc::DoAlloc(block, alloc_regs, alloc_fregs);
	}

	void Preload(u32 reg, eReg nreg) override;
	void Writeback(u32 reg, eReg nreg) override;
	void Preload_FPU(u32 reg, eFReg nreg) override;
	void Writeback_FPU(u32 reg, eFReg nreg) override;

	const Register& MapRegister(const shil_param& param)
	{
		#define WREG(n) vixl::aarch64::w##n,
		static const Register wregisters[] = {AARCH64_REGISTER_CODE_LIST(WREG)};
		#undef WREG

		eReg ereg = mapg(param);
		if (ereg == (eReg)-1)
			die("Register not allocated");
		return wregisters[ereg];
	}

	const VRegister& MapVRegister(const shil_param& param, int index = 0)
	{
		#define SREG(n) vixl::aarch64::s##n,
		static const VRegister sregisters[] = {AARCH64_REGISTER_CODE_LIST(SREG)};
		#undef SREG

		eFReg ereg = mapf(param, index);
		if (ereg == (eFReg)-1)
			die("VRegister not allocated");
		return sregisters[ereg];
	}

	Arm64Assembler *assembler;
};
