## ----------------------------------------------------------------------------
#  t/wavedash.t
# -----------------------------------------------------------------------------
# Mastering programed by YAMASHINA Hio
#
# Copyright YMIRLINK,Inc.
# -----------------------------------------------------------------------------
# $Id$
# -----------------------------------------------------------------------------
use strict;

use Test::More tests => 4;
use Unicode::Japanese;

# -----------------------------------------------------------------------------
# U+301C(WAVE DASH) => CP912:8160
#
is(Unicode::Japanese->new("\xe3\x80\x9c")->sjis(),
   "\x81\x60",
   "U+301C => CP912:8160");
is(Unicode::Japanese::PurePerl->new("\xe3\x80\x9c")->sjis(),
   "\x81\x60",
   "U+301C => CP912:8160");

# -----------------------------------------------------------------------------
# U+301C(WAVE DASH) =(z2h)=> ASCII:7E (TILDE)
#
is(Unicode::Japanese->new("\xe3\x80\x9c")->z2h()->sjis(),
   "~",
   "U+301C => CP912:8160");
is(Unicode::Japanese::PurePerl->new("\xe3\x80\x9c")->z2h()->sjis(),
   "~",
   "U+301C => CP912:8160");

# -----------------------------------------------------------------------------
# End Of File.
# -----------------------------------------------------------------------------
