/*****************************************************************************
 *  FTools - Freenet Client Protocol Tools
 *
 *  Copyright (C) 2002 Juergen Buchmueller <juergen@pullmoll.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *	$Id: ftsock.h,v 1.4 2003/11/04 23:15:36 pullmoll Exp $
 *****************************************************************************/
#ifndef	_ftsock_h
#define	_ftsock_h

#include "ft.h"

typedef struct conn_s {
	int sk;
	char *host;
	int port;
	struct sockaddr_in addr;
}	conn_t;

#ifdef	__cplusplus
extern "C" {
#endif

int sk_outgoing(conn_t *conn, const char *hostname, int port);
int sk_incoming(const char *hostname, int port, int (*child)(conn_t *conn));
int sk_read(conn_t *conn, void *buffer, size_t size);
int sk_write(conn_t *conn, const void *buffer, size_t size);
int sk_gets(conn_t *conn, char *buffer, size_t size);
int sk_printf(conn_t *conn, const char *fmt, ...);
int sk_shut(conn_t *conn);

#ifdef	__cplusplus
}	/* extern "C" */
#endif

#endif	/* _ftsock_h */
