# Hedges

Hedges are used in the antecedent and consequent of a rule to modify the membership function of the term it precedes.

The hedges in the library can be ordered based on the difference between the
membership function $\mu(x)$ and its hedge $h(\mu(x))$ as follows (from most similar to least):
Seldom   $<$ Somewhat   $<$ Very  $<$ Extremely   $<$ Not   $<$ Any

| `term`                                                	 | Seldom                                                                                                     	 | Somewhat                                                                                                        	 | Very                                                                                                    	 | Extremely                                                                                                         	 | Not                                                                                                   	 | Any                                                                                                   	 |
|---------------------------------------------------------|--------------------------------------------------------------------------------------------------------------|-------------------------------------------------------------------------------------------------------------------|-----------------------------------------------------------------------------------------------------------|---------------------------------------------------------------------------------------------------------------------|---------------------------------------------------------------------------------------------------------|---------------------------------------------------------------------------------------------------------|
| [fuzzylite.term.Rectangle][]                          	 | [fuzzylite.hedge.Seldom][] [fuzzylite.term.Rectangle][]                                                    	 | [fuzzylite.hedge.Somewhat][] [fuzzylite.term.Rectangle][]                                                       	 | [fuzzylite.hedge.Very][] [fuzzylite.term.Rectangle][]                                                   	 | [fuzzylite.hedge.Extremely][] [fuzzylite.term.Rectangle][]                                                        	 | [fuzzylite.hedge.Not][] [fuzzylite.term.Rectangle][]                                                  	 | [fuzzylite.hedge.Any][] [fuzzylite.term.Rectangle][]                                                  	 |
| ![](../image/term/Rectangle.svg)                   	    | ![](../image/hedge/Seldom-Rectangle.svg)                                                                	    | ![](../image/hedge/Somewhat-Rectangle.svg)                                                                   	    | ![](../image/hedge/Very-Rectangle.svg)                                                               	    | ![](../image/hedge/Extremely-Rectangle.svg)                                                                    	    | ![](../image/hedge/Not-Rectangle.svg)                                                              	    | ![](../image/hedge/Any-Rectangle.svg)                                                              	    |
| [fuzzylite.term.SemiEllipse][]                        	 | [fuzzylite.hedge.Seldom][] [fuzzylite.term.SemiEllipse][]                                                  	 | [fuzzylite.hedge.Somewhat][] [fuzzylite.term.SemiEllipse][]                                                     	 | [fuzzylite.hedge.Very][] [fuzzylite.term.SemiEllipse][]                                                 	 | [fuzzylite.hedge.Extremely][] [fuzzylite.term.SemiEllipse][]                                                      	 | [fuzzylite.hedge.Not][] [fuzzylite.term.SemiEllipse][]                                                	 | [fuzzylite.hedge.Any][] [fuzzylite.term.SemiEllipse][]                                                	 |
| ![](../image/term/SemiEllipse.svg )                	    | ![](../image/hedge/Seldom-SemiEllipse.svg )                                                             	    | ![](../image/hedge/Somewhat-SemiEllipse.svg )                                                                	    | ![](../image/hedge/Very-SemiEllipse.svg )                                                            	    | ![](../image/hedge/Extremely-SemiEllipse.svg )                                                                 	    | ![](../image/hedge/Not-SemiEllipse.svg )                                                           	    | ![](../image/hedge/Any-SemiEllipse.svg )                                                           	    |
| [fuzzylite.term.Triangle][]                           	 | [fuzzylite.hedge.Seldom][] [fuzzylite.term.Triangle][]                                                     	 | [fuzzylite.hedge.Somewhat][] [fuzzylite.term.Triangle][]                                                        	 | [fuzzylite.hedge.Very][] [fuzzylite.term.Triangle][]                                                    	 | [fuzzylite.hedge.Extremely][] [fuzzylite.term.Triangle][]                                                         	 | [fuzzylite.hedge.Not][] [fuzzylite.term.Triangle][]                                                   	 | [fuzzylite.hedge.Any][] [fuzzylite.term.Triangle][]                                                   	 |
| ![](../image/term/Triangle.svg )                   	    | ![](../image/hedge/Seldom-Triangle.svg )                                                                	    | ![](../image/hedge/Somewhat-Triangle.svg )                                                                   	    | ![](../image/hedge/Very-Triangle.svg )                                                               	    | ![](../image/hedge/Extremely-Triangle.svg )                                                                    	    | ![](../image/hedge/Not-Triangle.svg )                                                              	    | ![](../image/hedge/Any-Triangle.svg )                                                              	    |
| [fuzzylite.term.Trapezoid][]                          	 | [fuzzylite.hedge.Seldom][] [fuzzylite.term.Trapezoid][]                                                    	 | [fuzzylite.hedge.Somewhat][] [fuzzylite.term.Trapezoid][]                                                       	 | [fuzzylite.hedge.Very][] [fuzzylite.term.Trapezoid][]                                                   	 | [fuzzylite.hedge.Extremely][] [fuzzylite.term.Trapezoid][]                                                        	 | [fuzzylite.hedge.Not][] [fuzzylite.term.Trapezoid][]                                                  	 | [fuzzylite.hedge.Any][] [fuzzylite.term.Trapezoid][]                                                  	 |
| ![](../image/term/Trapezoid.svg)                   	    | ![](../image/hedge/Seldom-Trapezoid.svg)                                                                	    | ![](../image/hedge/Somewhat-Trapezoid.svg)                                                                   	    | ![](../image/hedge/Very-Trapezoid.svg)                                                               	    | ![](../image/hedge/Extremely-Trapezoid.svg)                                                                    	    | ![](../image/hedge/Not-Trapezoid.svg)                                                              	    | ![](../image/hedge/Any-Trapezoid.svg)                                                              	    |
| [fuzzylite.term.Discrete][]                           	 | [fuzzylite.hedge.Seldom][] [fuzzylite.term.Discrete][]                                                     	 | [fuzzylite.hedge.Somewhat][] [fuzzylite.term.Discrete][]                                                        	 | [fuzzylite.hedge.Very][] [fuzzylite.term.Discrete][]                                                    	 | [fuzzylite.hedge.Extremely][] [fuzzylite.term.Discrete][]                                                         	 | [fuzzylite.hedge.Not][] [fuzzylite.term.Discrete][]                                                   	 | [fuzzylite.hedge.Any][] [fuzzylite.term.Discrete][]                                                   	 |
| ![](../image/term/Discrete.svg )                   	    | ![](../image/hedge/Seldom-Discrete.svg )                                                                	    | ![](../image/hedge/Somewhat-Discrete.svg )                                                                   	    | ![](../image/hedge/Very-Discrete.svg )                                                               	    | ![](../image/hedge/Extremely-Discrete.svg )                                                                    	    | ![](../image/hedge/Not-Discrete.svg )                                                              	    | ![](../image/hedge/Any-Discrete.svg )                                                              	    |
| [fuzzylite.term.Bell][]                               	 | [fuzzylite.hedge.Seldom][] [fuzzylite.term.Bell][]                                                         	 | [fuzzylite.hedge.Somewhat][] [fuzzylite.term.Bell][]                                                            	 | [fuzzylite.hedge.Very][] [fuzzylite.term.Bell][]                                                        	 | [fuzzylite.hedge.Extremely][] [fuzzylite.term.Bell][]                                                             	 | [fuzzylite.hedge.Not][] [fuzzylite.term.Bell][]                                                       	 | [fuzzylite.hedge.Any][] [fuzzylite.term.Bell][]                                                       	 |
| ![](../image/term/Bell.svg)                        	    | ![](../image/hedge/Seldom-Bell.svg)                                                                     	    | ![](../image/hedge/Somewhat-Bell.svg)                                                                        	    | ![](../image/hedge/Very-Bell.svg)                                                                    	    | ![](../image/hedge/Extremely-Bell.svg)                                                                         	    | ![](../image/hedge/Not-Bell.svg)                                                                   	    | ![](../image/hedge/Any-Bell.svg)                                                                   	    |
| [fuzzylite.term.Cosine][]                             	 | [fuzzylite.hedge.Seldom][] [fuzzylite.term.Cosine][]                                                       	 | [fuzzylite.hedge.Somewhat][] [fuzzylite.term.Cosine][]                                                          	 | [fuzzylite.hedge.Very][] [fuzzylite.term.Cosine][]                                                      	 | [fuzzylite.hedge.Extremely][] [fuzzylite.term.Cosine][]                                                           	 | [fuzzylite.hedge.Not][] [fuzzylite.term.Cosine][]                                                     	 | [fuzzylite.hedge.Any][] [fuzzylite.term.Cosine][]                                                     	 |
| ![](../image/term/Cosine.svg)                      	    | ![](../image/hedge/Seldom-Cosine.svg)                                                                   	    | ![](../image/hedge/Somewhat-Cosine.svg)                                                                      	    | ![](../image/hedge/Very-Cosine.svg)                                                                  	    | ![](../image/hedge/Extremely-Cosine.svg)                                                                       	    | ![](../image/hedge/Not-Cosine.svg)                                                                 	    | ![](../image/hedge/Any-Cosine.svg)                                                                 	    |
| [fuzzylite.term.Gaussian][]                           	 | [fuzzylite.hedge.Seldom][] [fuzzylite.term.Gaussian][]                                                     	 | [fuzzylite.hedge.Somewhat][] [fuzzylite.term.Gaussian][]                                                        	 | [fuzzylite.hedge.Very][] [fuzzylite.term.Gaussian][]                                                    	 | [fuzzylite.hedge.Extremely][] [fuzzylite.term.Gaussian][]                                                         	 | [fuzzylite.hedge.Not][] [fuzzylite.term.Gaussian][]                                                   	 | [fuzzylite.hedge.Any][] [fuzzylite.term.Gaussian][]                                                   	 |
| ![](../image/term/Gaussian.svg)                    	    | ![](../image/hedge/Seldom-Gaussian.svg)                                                                 	    | ![](../image/hedge/Somewhat-Gaussian.svg)                                                                    	    | ![](../image/hedge/Very-Gaussian.svg)                                                                	    | ![](../image/hedge/Extremely-Gaussian.svg)                                                                     	    | ![](../image/hedge/Not-Gaussian.svg)                                                               	    | ![](../image/hedge/Any-Gaussian.svg)                                                               	    |
| [fuzzylite.term.GaussianProduct][]                    	 | [fuzzylite.hedge.Seldom][] [fuzzylite.term.GaussianProduct][]                                              	 | [fuzzylite.hedge.Somewhat][] [fuzzylite.term.GaussianProduct][]                                                 	 | [fuzzylite.hedge.Very][] [fuzzylite.term.GaussianProduct][]                                             	 | [fuzzylite.hedge.Extremely][] [fuzzylite.term.GaussianProduct][]                                                  	 | [fuzzylite.hedge.Not][] [fuzzylite.term.GaussianProduct][]                                            	 | [fuzzylite.hedge.Any][] [fuzzylite.term.GaussianProduct][]                                            	 |
| ![](../image/term/GaussianProduct.svg)             	    | ![](../image/hedge/Seldom-GaussianProduct.svg)                                                          	    | ![](../image/hedge/Somewhat-GaussianProduct.svg)                                                             	    | ![](../image/hedge/Very-GaussianProduct.svg)                                                         	    | ![](../image/hedge/Extremely-GaussianProduct.svg)                                                              	    | ![](../image/hedge/Not-GaussianProduct.svg)                                                        	    | ![](../image/hedge/Any-GaussianProduct.svg)                                                        	    |
| [fuzzylite.term.PiShape][]                            	 | [fuzzylite.hedge.Seldom][] [fuzzylite.term.PiShape][]                                                      	 | [fuzzylite.hedge.Somewhat][] [fuzzylite.term.PiShape][]                                                         	 | [fuzzylite.hedge.Very][] [fuzzylite.term.PiShape][]                                                     	 | [fuzzylite.hedge.Extremely][] [fuzzylite.term.PiShape][]                                                          	 | [fuzzylite.hedge.Not][] [fuzzylite.term.PiShape][]                                                    	 | [fuzzylite.hedge.Any][] [fuzzylite.term.PiShape][]                                                    	 |
| ![](../image/term/PiShape.svg)                     	    | ![](../image/hedge/Seldom-PiShape.svg)                                                                  	    | ![](../image/hedge/Somewhat-PiShape.svg)                                                                     	    | ![](../image/hedge/Very-PiShape.svg)                                                                 	    | ![](../image/hedge/Extremely-PiShape.svg)                                                                      	    | ![](../image/hedge/Not-PiShape.svg)                                                                	    | ![](../image/hedge/Any-PiShape.svg)                                                                	    |
| [fuzzylite.term.SigmoidDifference][]                  	 | [fuzzylite.hedge.Seldom][] [fuzzylite.term.SigmoidDifference][]                                            	 | [fuzzylite.hedge.Somewhat][] [fuzzylite.term.SigmoidDifference][]                                               	 | [fuzzylite.hedge.Very][] [fuzzylite.term.SigmoidDifference][]                                           	 | [fuzzylite.hedge.Extremely][] [fuzzylite.term.SigmoidDifference][]                                                	 | [fuzzylite.hedge.Not][] [fuzzylite.term.SigmoidDifference][]                                          	 | [fuzzylite.hedge.Any][] [fuzzylite.term.SigmoidDifference][]                                          	 |
| ![](../image/term/SigmoidDifference.svg)           	    | ![](../image/hedge/Seldom-SigmoidDifference.svg)                                                        	    | ![](../image/hedge/Somewhat-SigmoidDifference.svg)                                                           	    | ![](../image/hedge/Very-SigmoidDifference.svg)                                                       	    | ![](../image/hedge/Extremely-SigmoidDifference.svg)                                                            	    | ![](../image/hedge/Not-SigmoidDifference.svg)                                                      	    | ![](../image/hedge/Any-SigmoidDifference.svg)                                                      	    |
| [fuzzylite.term.SigmoidProduct][]                     	 | [fuzzylite.hedge.Seldom][] [fuzzylite.term.SigmoidProduct][]                                               	 | [fuzzylite.hedge.Somewhat][] [fuzzylite.term.SigmoidProduct][]                                                  	 | [fuzzylite.hedge.Very][] [fuzzylite.term.SigmoidProduct][]                                              	 | [fuzzylite.hedge.Extremely][] [fuzzylite.term.SigmoidProduct][]                                                   	 | [fuzzylite.hedge.Not][] [fuzzylite.term.SigmoidProduct][]                                             	 | [fuzzylite.hedge.Any][] [fuzzylite.term.SigmoidProduct][]                                             	 |
| ![](../image/term/SigmoidProduct.svg)              	    | ![](../image/hedge/Seldom-SigmoidProduct.svg)                                                           	    | ![](../image/hedge/Somewhat-SigmoidProduct.svg)                                                              	    | ![](../image/hedge/Very-SigmoidProduct.svg)                                                          	    | ![](../image/hedge/Extremely-SigmoidProduct.svg)                                                               	    | ![](../image/hedge/Not-SigmoidProduct.svg)                                                         	    | ![](../image/hedge/Any-SigmoidProduct.svg)                                                         	    |
| [fuzzylite.term.Spike][]                              	 | [fuzzylite.hedge.Seldom][] [fuzzylite.term.Spike][]                                                        	 | [fuzzylite.hedge.Somewhat][] [fuzzylite.term.Spike][]                                                           	 | [fuzzylite.hedge.Very][] [fuzzylite.term.Spike][]                                                       	 | [fuzzylite.hedge.Extremely][] [fuzzylite.term.Spike][]                                                            	 | [fuzzylite.hedge.Not][] [fuzzylite.term.Spike][]                                                      	 | [fuzzylite.hedge.Any][] [fuzzylite.term.Spike][]                                                      	 |
| ![](../image/term/Spike.svg)                       	    | ![](../image/hedge/Seldom-Spike.svg)                                                                    	    | ![](../image/hedge/Somewhat-Spike.svg)                                                                       	    | ![](../image/hedge/Very-Spike.svg)                                                                   	    | ![](../image/hedge/Extremely-Spike.svg)                                                                        	    | ![](../image/hedge/Not-Spike.svg)                                                                  	    | ![](../image/hedge/Any-Spike.svg)                                                                  	    |
| [fuzzylite.term.Arc][]                                	 | [fuzzylite.hedge.Seldom][] [fuzzylite.term.Arc][]                                                          	 | [fuzzylite.hedge.Somewhat][] [fuzzylite.term.Arc][]                                                             	 | [fuzzylite.hedge.Very][] [fuzzylite.term.Arc][]                                                         	 | [fuzzylite.hedge.Extremely][] [fuzzylite.term.Arc][]                                                              	 | [fuzzylite.hedge.Not][] [fuzzylite.term.Arc][]                                                        	 | [fuzzylite.hedge.Any][] [fuzzylite.term.Arc][]                                                        	 |
| ![](../image/term/Arc.svg)                         	    | ![](../image/hedge/Seldom-Arc.svg)                                                                      	    | ![](../image/hedge/Somewhat-Arc.svg)                                                                         	    | ![](../image/hedge/Very-Arc.svg)                                                                     	    | ![](../image/hedge/Extremely-Arc.svg)                                                                          	    | ![](../image/hedge/Not-Arc.svg)                                                                    	    | ![](../image/hedge/Any-Arc.svg)                                                                    	    |
| [fuzzylite.term.Binary][]                             	 | [fuzzylite.hedge.Seldom][] [fuzzylite.term.Binary][]                                                       	 | [fuzzylite.hedge.Somewhat][] [fuzzylite.term.Binary][]                                                          	 | [fuzzylite.hedge.Very][] [fuzzylite.term.Binary][]                                                      	 | [fuzzylite.hedge.Extremely][] [fuzzylite.term.Binary][]                                                           	 | [fuzzylite.hedge.Not][] [fuzzylite.term.Binary][]                                                     	 | [fuzzylite.hedge.Any][] [fuzzylite.term.Binary][]                                                     	 |
| ![](../image/term/Binary.svg)                      	    | ![](../image/hedge/Seldom-Binary.svg)                                                                   	    | ![](../image/hedge/Somewhat-Binary.svg)                                                                      	    | ![](../image/hedge/Very-Binary.svg)                                                                  	    | ![](../image/hedge/Extremely-Binary.svg)                                                                       	    | ![](../image/hedge/Not-Binary.svg)                                                                 	    | ![](../image/hedge/Any-Binary.svg)                                                                 	    |
| [fuzzylite.term.Concave][]                            	 | [fuzzylite.hedge.Seldom][] [fuzzylite.term.Concave][]                                                      	 | [fuzzylite.hedge.Somewhat][] [fuzzylite.term.Concave][]                                                         	 | [fuzzylite.hedge.Very][] [fuzzylite.term.Concave][]                                                     	 | [fuzzylite.hedge.Extremely][] [fuzzylite.term.Concave][]                                                          	 | [fuzzylite.hedge.Not][] [fuzzylite.term.Concave][]                                                    	 | [fuzzylite.hedge.Any][] [fuzzylite.term.Concave][]                                                    	 |
| ![](../image/term/Concave.svg)                     	    | ![](../image/hedge/Seldom-Concave.svg)                                                                  	    | ![](../image/hedge/Somewhat-Concave.svg)                                                                     	    | ![](../image/hedge/Very-Concave.svg)                                                                 	    | ![](../image/hedge/Extremely-Concave.svg)                                                                      	    | ![](../image/hedge/Not-Concave.svg)                                                                	    | ![](../image/hedge/Any-Concave.svg)                                                                	    |
| [fuzzylite.term.Ramp][]                               	 | [fuzzylite.hedge.Seldom][] [fuzzylite.term.Ramp][]                                                         	 | [fuzzylite.hedge.Somewhat][] [fuzzylite.term.Ramp][]                                                            	 | [fuzzylite.hedge.Very][] [fuzzylite.term.Ramp][]                                                        	 | [fuzzylite.hedge.Extremely][] [fuzzylite.term.Ramp][]                                                             	 | [fuzzylite.hedge.Not][] [fuzzylite.term.Ramp][]                                                       	 | [fuzzylite.hedge.Any][] [fuzzylite.term.Ramp][]                                                       	 |
| ![](../image/term/Ramp.svg)                        	    | ![](../image/hedge/Seldom-Ramp.svg)                                                                     	    | ![](../image/hedge/Somewhat-Ramp.svg)                                                                        	    | ![](../image/hedge/Very-Ramp.svg)                                                                    	    | ![](../image/hedge/Extremely-Ramp.svg)                                                                         	    | ![](../image/hedge/Not-Ramp.svg)                                                                   	    | ![](../image/hedge/Any-Ramp.svg)                                                                   	    |
| [fuzzylite.term.Sigmoid][]                            	 | [fuzzylite.hedge.Seldom][] [fuzzylite.term.Sigmoid][]                                                      	 | [fuzzylite.hedge.Somewhat][] [fuzzylite.term.Sigmoid][]                                                         	 | [fuzzylite.hedge.Very][] [fuzzylite.term.Sigmoid][]                                                     	 | [fuzzylite.hedge.Extremely][] [fuzzylite.term.Sigmoid][]                                                          	 | [fuzzylite.hedge.Not][] [fuzzylite.term.Sigmoid][]                                                    	 | [fuzzylite.hedge.Any][] [fuzzylite.term.Sigmoid][]                                                    	 |
| ![](../image/term/Sigmoid.svg)                     	    | ![](../image/hedge/Seldom-Sigmoid.svg)                                                                  	    | ![](../image/hedge/Somewhat-Sigmoid.svg)                                                                     	    | ![](../image/hedge/Very-Sigmoid.svg)                                                                 	    | ![](../image/hedge/Extremely-Sigmoid.svg)                                                                      	    | ![](../image/hedge/Not-Sigmoid.svg)                                                                	    | ![](../image/hedge/Any-Sigmoid.svg)                                                                	    |
| [fuzzylite.term.SShape][] - [fuzzylite.term.ZShape][] 	 | [fuzzylite.hedge.Seldom][] [fuzzylite.term.SShape][] - [fuzzylite.hedge.Seldom][] fuzzylite.term.ZShape][] 	 | [fuzzylite.hedge.Somewhat][] [fuzzylite.term.SShape][] - [fuzzylite.hedge.Somewhat][] [fuzzylite.term.ZShape][] 	 | [fuzzylite.hedge.Very][] [fuzzylite.term.SShape][] - [fuzzylite.hedge.Very][] [fuzzylite.term.ZShape][] 	 | [fuzzylite.hedge.Extremely][] [fuzzylite.term.SShape][] - [fuzzylite.hedge.Extremely][] [fuzzylite.term.ZShape][] 	 | [fuzzylite.hedge.Not][] [fuzzylite.term.SShape][] - [fuzzylite.hedge.Not][] [fuzzylite.term.ZShape][] 	 | [fuzzylite.hedge.Any][] [fuzzylite.term.SShape][] - [fuzzylite.hedge.Any][] [fuzzylite.term.ZShape][] 	 |
| ![](../image/term/ZShape - SShape.svg)             	    | ![](../image/hedge/Seldom-ZShape - SShape.svg)                                                          	    | ![](../image/hedge/Somewhat-ZShape - SShape.svg)                                                             	    | ![](../image/hedge/Very-ZShape - SShape.svg)                                                         	    | ![](../image/hedge/Extremely-ZShape - SShape.svg)                                                              	    | ![](../image/hedge/Not-ZShape - SShape.svg)                                                        	    | ![](../image/hedge/Any-ZShape - SShape.svg)                                                        	    |
| [fuzzylite.term.SShape][]                             	 | [fuzzylite.hedge.Seldom][] [fuzzylite.term.SShape][]                                                       	 | [fuzzylite.hedge.Somewhat][] [fuzzylite.term.SShape][]                                                          	 | [fuzzylite.hedge.Very][] [fuzzylite.term.SShape][]                                                      	 | [fuzzylite.hedge.Extremely][] [fuzzylite.term.SShape][]                                                           	 | [fuzzylite.hedge.Not][] [fuzzylite.term.SShape][]                                                     	 | [fuzzylite.hedge.Any][] [fuzzylite.term.SShape][]                                                     	 |
| ![](../image/term/SShape.svg)                      	    | ![](../image/hedge/Seldom-SShape.svg)                                                                   	    | ![](../image/hedge/Somewhat-SShape.svg)                                                                      	    | ![](../image/hedge/Very-SShape.svg)                                                                  	    | ![](../image/hedge/Extremely-SShape.svg)                                                                       	    | ![](../image/hedge/Not-SShape.svg)                                                                 	    | ![](../image/hedge/Any-SShape.svg)                                                                 	    |
| [fuzzylite.term.ZShape][]                             	 | [fuzzylite.hedge.Seldom][] [fuzzylite.term.ZShape][]                                                       	 | [fuzzylite.hedge.Somewhat][] [fuzzylite.term.ZShape][]                                                          	 | [fuzzylite.hedge.Very][] [fuzzylite.term.ZShape][]                                                      	 | [fuzzylite.hedge.Extremely][] [fuzzylite.term.ZShape][]                                                           	 | [fuzzylite.hedge.Not][] [fuzzylite.term.ZShape][]                                                     	 | [fuzzylite.hedge.Any][] [fuzzylite.term.ZShape][]                                                     	 |
| ![](../image/term/ZShape.svg)                           