#ifndef FX2REGS_H
#define FX2REGS_H

// DO NOT EDIT. Automatically generated by regtxt2c.py.

#include <stdint.h>

#ifndef DOXYGEN
#define _SFR(addr)   static __sfr __at (addr)
#define _SFR16(addr) static __sfr16 __at (addr)
#define _SBIT(addr)  static __sbit __at (addr)
#define _IOR(addr)   static __xdata __at (addr) volatile uint8_t
#define _IOR16(addr) static __xdata __at (addr) volatile uint16_t
#endif

// Register _XPAGE must be defined at a location that sets the upper
// address byte of movx using \@rN for non-small memory models to work.
// This should *not* be declared as `static`.
/// Alias of `MPAGE` used internally by sdcc.
__sfr __at(0x92) _XPAGE;

// Special Function Registers (SFRs)

_SFR(0x80) IOA; ///< Register 0x80: Port A
    _SBIT(0x80 + 0) PA0; ///< Register 0x80 bit 0: Port A bit PA0
    _SBIT(0x80 + 1) PA1; ///< Register 0x80 bit 1: Port A bit PA1
    _SBIT(0x80 + 2) PA2; ///< Register 0x80 bit 2: Port A bit PA2
    _SBIT(0x80 + 3) PA3; ///< Register 0x80 bit 3: Port A bit PA3
    _SBIT(0x80 + 4) PA4; ///< Register 0x80 bit 4: Port A bit PA4
    _SBIT(0x80 + 5) PA5; ///< Register 0x80 bit 5: Port A bit PA5
    _SBIT(0x80 + 6) PA6; ///< Register 0x80 bit 6: Port A bit PA6
    _SBIT(0x80 + 7) PA7; ///< Register 0x80 bit 7: Port A bit PA7
_SFR(0x81) SP; ///< Register 0x81: Stack Pointer
_SFR(0x82) DPL0; ///< Register 0x82: Data Pointer 0 L
_SFR16(0x8382) DP0; ///< Register 0x82: Data Pointer 0
_SFR(0x83) DPH0; ///< Register 0x83: Data Pointer 0 H
_SFR(0x84) DPL1; ///< Register 0x84: Data Pointer 1 L
_SFR16(0x8584) DP1; ///< Register 0x84: Data Pointer 1
_SFR(0x85) DPH1; ///< Register 0x85: Data Pointer 1 H
_SFR(0x86) DPS; ///< Register 0x86: Data Pointer 0/1 select
_SFR(0x87) PCON; ///< Register 0x87: Power Control
_SFR(0x88) TCON; ///< Register 0x88: Timer/Counter Control
    _SBIT(0x88 + 0) IT0; ///< Register 0x88 bit 0: Timer/Counter Control bit IT0
    _SBIT(0x88 + 1) IE0; ///< Register 0x88 bit 1: Timer/Counter Control bit IE0
    _SBIT(0x88 + 2) IT1; ///< Register 0x88 bit 2: Timer/Counter Control bit IT1
    _SBIT(0x88 + 3) IE1; ///< Register 0x88 bit 3: Timer/Counter Control bit IE1
    _SBIT(0x88 + 4) TR0; ///< Register 0x88 bit 4: Timer/Counter Control bit TR0
    _SBIT(0x88 + 5) TF0; ///< Register 0x88 bit 5: Timer/Counter Control bit TF0
    _SBIT(0x88 + 6) TR1; ///< Register 0x88 bit 6: Timer/Counter Control bit TR1
    _SBIT(0x88 + 7) TF1; ///< Register 0x88 bit 7: Timer/Counter Control bit TF1
_SFR(0x89) TMOD; ///< Register 0x89: Timer/Counter Mode Control
_SFR(0x8a) TL0; ///< Register 0x8A: Timer 0 reload L
_SFR16(0x8c8a) T0; ///< Register 0x8A: Timer 0 reload
_SFR(0x8b) TL1; ///< Register 0x8B: Timer 1 reload L
_SFR16(0x8d8b) T1; ///< Register 0x8B: Timer 1 reload
_SFR(0x8c) TH0; ///< Register 0x8C: Timer 0 reload H
_SFR(0x8d) TH1; ///< Register 0x8D: Timer 1 reload H
_SFR(0x8e) CKCON; ///< Register 0x8E: Clock Control
_SFR(0x90) IOB; ///< Register 0x90: Port B
    _SBIT(0x90 + 0) PB0; ///< Register 0x90 bit 0: Port B bit PB0
    _SBIT(0x90 + 1) PB1; ///< Register 0x90 bit 1: Port B bit PB1
    _SBIT(0x90 + 2) PB2; ///< Register 0x90 bit 2: Port B bit PB2
    _SBIT(0x90 + 3) PB3; ///< Register 0x90 bit 3: Port B bit PB3
    _SBIT(0x90 + 4) PB4; ///< Register 0x90 bit 4: Port B bit PB4
    _SBIT(0x90 + 5) PB5; ///< Register 0x90 bit 5: Port B bit PB5
    _SBIT(0x90 + 6) PB6; ///< Register 0x90 bit 6: Port B bit PB6
    _SBIT(0x90 + 7) PB7; ///< Register 0x90 bit 7: Port B bit PB7
_SFR(0x91) EXIF; ///< Register 0x91: External Interrupt Flag(s)
_SFR(0x92) MPAGE; ///< Register 0x92: Upper Addr Byte of MOVX using \@R0 / \@R1
_SFR(0x98) SCON0; ///< Register 0x98: Serial Port 0 Control
    _SBIT(0x98 + 0) RI_0; ///< Register 0x98 bit 0: Serial Port 0 Control bit RI_0
    _SBIT(0x98 + 1) TI_0; ///< Register 0x98 bit 1: Serial Port 0 Control bit TI_0
    _SBIT(0x98 + 2) RB8_0; ///< Register 0x98 bit 2: Serial Port 0 Control bit RB8_0
    _SBIT(0x98 + 3) TB8_0; ///< Register 0x98 bit 3: Serial Port 0 Control bit TB8_0
    _SBIT(0x98 + 4) REN_0; ///< Register 0x98 bit 4: Serial Port 0 Control bit REN_0
    _SBIT(0x98 + 5) SM2_0; ///< Register 0x98 bit 5: Serial Port 0 Control bit SM2_0
    _SBIT(0x98 + 6) SM1_0; ///< Register 0x98 bit 6: Serial Port 0 Control bit SM1_0
    _SBIT(0x98 + 7) SM0_0; ///< Register 0x98 bit 7: Serial Port 0 Control bit SM0_0
_SFR(0x99) SBUF0; ///< Register 0x99: Serial Port 0 Data Buffer
_SFR(0x9a) AUTOPTRH1; ///< Register 0x9A: Autopointer 1 Address H
_SFR(0x9b) AUTOPTRL1; ///< Register 0x9B: Autopointer 1 Address L
_SFR16(0x9a9b) AUTOPTR1; ///< Register 0x9B: Autopointer 1 Address
_SFR(0x9d) AUTOPTRH2; ///< Register 0x9D: Autopointer 2 Address H
_SFR(0x9e) AUTOPTRL2; ///< Register 0x9E: Autopointer 2 Address L
_SFR16(0x9d9e) AUTOPTR2; ///< Register 0x9E: Autopointer 2 Address
_SFR(0xa0) IOC; ///< Register 0xA0: Port C
    _SBIT(0xa0 + 0) PC0; ///< Register 0xA0 bit 0: Port C bit PC0
    _SBIT(0xa0 + 1) PC1; ///< Register 0xA0 bit 1: Port C bit PC1
    _SBIT(0xa0 + 2) PC2; ///< Register 0xA0 bit 2: Port C bit PC2
    _SBIT(0xa0 + 3) PC3; ///< Register 0xA0 bit 3: Port C bit PC3
    _SBIT(0xa0 + 4) PC4; ///< Register 0xA0 bit 4: Port C bit PC4
    _SBIT(0xa0 + 5) PC5; ///< Register 0xA0 bit 5: Port C bit PC5
    _SBIT(0xa0 + 6) PC6; ///< Register 0xA0 bit 6: Port C bit PC6
    _SBIT(0xa0 + 7) PC7; ///< Register 0xA0 bit 7: Port C bit PC7
_SFR(0xa1) INT2CLR; ///< Register 0xA1: Interrupt 2 clear
_SFR(0xa2) INT4CLR; ///< Register 0xA2: Interrupt 4 clear
_SFR(0xa8) IE; ///< Register 0xA8: Interrupt Enable
    _SBIT(0xa8 + 0) EX0; ///< Register 0xA8 bit 0: Interrupt Enable bit EX0
    _SBIT(0xa8 + 1) ET0; ///< Register 0xA8 bit 1: Interrupt Enable bit ET0
    _SBIT(0xa8 + 2) EX1; ///< Register 0xA8 bit 2: Interrupt Enable bit EX1
    _SBIT(0xa8 + 3) ET1; ///< Register 0xA8 bit 3: Interrupt Enable bit ET1
    _SBIT(0xa8 + 4) ES0; ///< Register 0xA8 bit 4: Interrupt Enable bit ES0
    _SBIT(0xa8 + 5) ET2; ///< Register 0xA8 bit 5: Interrupt Enable bit ET2
    _SBIT(0xa8 + 6) ES1; ///< Register 0xA8 bit 6: Interrupt Enable bit ES1
    _SBIT(0xa8 + 7) EA; ///< Register 0xA8 bit 7: Interrupt Enable bit EA
_SFR(0xaa) EP2468STAT; ///< Register 0xAA: Endpoint 2,4,6,8 status flags
_SFR(0xab) EP24FIFOFLGS; ///< Register 0xAB: Endpoint 2,4 slave FIFO status flags
_SFR(0xac) EP68FIFOFLGS; ///< Register 0xAC: Endpoint 6,8 slave FIFO status flags
_SFR(0xaf) AUTOPTRSETUP; ///< Register 0xAF: Autopointer 1&2 setup
_SFR(0xb0) IOD; ///< Register 0xB0: Port D
    _SBIT(0xb0 + 0) PD0; ///< Register 0xB0 bit 0: Port D bit PD0
    _SBIT(0xb0 + 1) PD1; ///< Register 0xB0 bit 1: Port D bit PD1
    _SBIT(0xb0 + 2) PD2; ///< Register 0xB0 bit 2: Port D bit PD2
    _SBIT(0xb0 + 3) PD3; ///< Register 0xB0 bit 3: Port D bit PD3
    _SBIT(0xb0 + 4) PD4; ///< Register 0xB0 bit 4: Port D bit PD4
    _SBIT(0xb0 + 5) PD5; ///< Register 0xB0 bit 5: Port D bit PD5
    _SBIT(0xb0 + 6) PD6; ///< Register 0xB0 bit 6: Port D bit PD6
    _SBIT(0xb0 + 7) PD7; ///< Register 0xB0 bit 7: Port D bit PD7
_SFR(0xb1) IOE; ///< Register 0xB1: Port E
_SFR(0xb2) OEA; ///< Register 0xB2: Port A Output Enable
_SFR(0xb3) OEB; ///< Register 0xB3: Port B Output Enable
_SFR(0xb4) OEC; ///< Register 0xB4: Port C Output Enable
_SFR(0xb5) OED; ///< Register 0xB5: Port D Output Enable
_SFR(0xb6) OEE; ///< Register 0xB6: Port E Output Enable
_SFR(0xb8) IP; ///< Register 0xB8: Interrupt Priority
    _SBIT(0xb8 + 0) PX0; ///< Register 0xB8 bit 0: Interrupt Priority bit PX0
    _SBIT(0xb8 + 1) PT0; ///< Register 0xB8 bit 1: Interrupt Priority bit PT0
    _SBIT(0xb8 + 2) PX1; ///< Register 0xB8 bit 2: Interrupt Priority bit PX1
    _SBIT(0xb8 + 3) PT1; ///< Register 0xB8 bit 3: Interrupt Priority bit PT1
    _SBIT(0xb8 + 4) PS0; ///< Register 0xB8 bit 4: Interrupt Priority bit PS0
    _SBIT(0xb8 + 5) PT2; ///< Register 0xB8 bit 5: Interrupt Priority bit PT2
    _SBIT(0xb8 + 6) PS1; ///< Register 0xB8 bit 6: Interrupt Priority bit PS1
_SFR(0xba) EP01STAT; ///< Register 0xBA: Endpoint 0&1 Status
_SFR(0xbb) GPIFTRIG; ///< Register 0xBB: Endpoint 2,4,6,8 GPIF slave FIFO Trigger
_SFR(0xbd) GPIFSGLDATH; ///< Register 0xBD: GPIF Data H (16-bit mode only)
_SFR(0xbe) GPIFSGLDATLX; ///< Register 0xBE: GPIF Data L w/ Trigger
_SFR(0xbf) GPIFSGLDATL; ///< Register 0xBF: GPIF Data L w/ No Trigger D7
_SFR16(0xbdbf) GPIFSGLDAT; ///< Register 0xBF: GPIF Data L w/ No Trigger D7
_SFR(0xc0) SCON1; ///< Register 0xC0: Serial Port 1 Control
    _SBIT(0xc0 + 0) RI_1; ///< Register 0xC0 bit 0: Serial Port 1 Control bit RI_1
    _SBIT(0xc0 + 1) TI_1; ///< Register 0xC0 bit 1: Serial Port 1 Control bit TI_1
    _SBIT(0xc0 + 2) RB8_1; ///< Register 0xC0 bit 2: Serial Port 1 Control bit RB8_1
    _SBIT(0xc0 + 3) TB8_1; ///< Register 0xC0 bit 3: Serial Port 1 Control bit TB8_1
    _SBIT(0xc0 + 4) REN_1; ///< Register 0xC0 bit 4: Serial Port 1 Control bit REN_1
    _SBIT(0xc0 + 5) SM2_1; ///< Register 0xC0 bit 5: Serial Port 1 Control bit SM2_1
    _SBIT(0xc0 + 6) SM1_1; ///< Register 0xC0 bit 6: Serial Port 1 Control bit SM1_1
    _SBIT(0xc0 + 7) SM0_1; ///< Register 0xC0 bit 7: Serial Port 1 Control bit SM0_1
_SFR(0xc1) SBUF1; ///< Register 0xC1: Serial Port 1 Data Buffer
_SFR(0xc8) T2CON; ///< Register 0xC8: Timer/Counter 2 Control
    _SBIT(0xc8 + 0) CPRL2; ///< Register 0xC8 bit 0: Timer/Counter 2 Control bit CPRL2
    _SBIT(0xc8 + 1) CT2; ///< Register 0xC8 bit 1: Timer/Counter 2 Control bit CT2
    _SBIT(0xc8 + 2) TR2; ///< Register 0xC8 bit 2: Timer/Counter 2 Control bit TR2
    _SBIT(0xc8 + 3) EXEN2; ///< Register 0xC8 bit 3: Timer/Counter 2 Control bit EXEN2
    _SBIT(0xc8 + 4) TCLK; ///< Register 0xC8 bit 4: Timer/Counter 2 Control bit TCLK
    _SBIT(0xc8 + 5) RCLK; ///< Register 0xC8 bit 5: Timer/Counter 2 Control bit RCLK
    _SBIT(0xc8 + 6) EXF2; ///< Register 0xC8 bit 6: Timer/Counter 2 Control bit EXF2
    _SBIT(0xc8 + 7) TF2; ///< Register 0xC8 bit 7: Timer/Counter 2 Control bit TF2
_SFR(0xca) RCAP2L; ///< Register 0xCA: Capture for Timer 2, auto-reload, up-counter
_SFR16(0xcbca) RCAP2; ///< Register 0xCA: Capture for Timer 2, auto-reload, up-counter
_SFR(0xcb) RCAP2H; ///< Register 0xCB: Capture for Timer 2, auto-reload, up-counter
_SFR(0xcc) TL2; ///< Register 0xCC: Timer 2 reload L
_SFR16(0xcdcc) T2; ///< Register 0xCC: Timer 2 reload
_SFR(0xcd) TH2; ///< Register 0xCD: Timer 2 reload H
_SFR(0xd0) PSW; ///< Register 0xD0: Program Status Word
    _SBIT(0xd0 + 0) P; ///< Register 0xD0 bit 0: Program Status Word bit P
    _SBIT(0xd0 + 1) F1; ///< Register 0xD0 bit 1: Program Status Word bit F1
    _SBIT(0xd0 + 2) OV; ///< Register 0xD0 bit 2: Program Status Word bit OV
    _SBIT(0xd0 + 3) RS0; ///< Register 0xD0 bit 3: Program Status Word bit RS0
    _SBIT(0xd0 + 4) RS1; ///< Register 0xD0 bit 4: Program Status Word bit RS1
    _SBIT(0xd0 + 5) F0; ///< Register 0xD0 bit 5: Program Status Word bit F0
    _SBIT(0xd0 + 6) AC; ///< Register 0xD0 bit 6: Program Status Word bit AC
    _SBIT(0xd0 + 7) CY; ///< Register 0xD0 bit 7: Program Status Word bit CY
_SFR(0xd8) EICON; ///< Register 0xD8: External Interrupt Control SMOD1
    _SBIT(0xd8 + 4) INT6; ///< Register 0xD8 bit 4: External Interrupt Control SMOD1 bit INT6
    _SBIT(0xd8 + 5) RESI; ///< Register 0xD8 bit 5: External Interrupt Control SMOD1 bit RESI
    _SBIT(0xd8 + 6) ERESI; ///< Register 0xD8 bit 6: External Interrupt Control SMOD1 bit ERESI
_SFR(0xe0) ACC; ///< Register 0xE0: Accumulator
    _SBIT(0xe0 + 0) ACC0; ///< Register 0xE0 bit 0: Accumulator bit ACC0
    _SBIT(0xe0 + 1) ACC1; ///< Register 0xE0 bit 1: Accumulator bit ACC1
    _SBIT(0xe0 + 2) ACC2; ///< Register 0xE0 bit 2: Accumulator bit ACC2
    _SBIT(0xe0 + 3) ACC3; ///< Register 0xE0 bit 3: Accumulator bit ACC3
    _SBIT(0xe0 + 4) ACC4; ///< Register 0xE0 bit 4: Accumulator bit ACC4
    _SBIT(0xe0 + 5) ACC5; ///< Register 0xE0 bit 5: Accumulator bit ACC5
    _SBIT(0xe0 + 6) ACC6; ///< Register 0xE0 bit 6: Accumulator bit ACC6
    _SBIT(0xe0 + 7) ACC7; ///< Register 0xE0 bit 7: Accumulator bit ACC7
_SFR(0xe8) EIE; ///< Register 0xE8: External Interrupt Enable(s)
    _SBIT(0xe8 + 0) EUSB; ///< Register 0xE8 bit 0: External Interrupt Enable(s) bit EUSB
    _SBIT(0xe8 + 1) EI2C; ///< Register 0xE8 bit 1: External Interrupt Enable(s) bit EI2C
    _SBIT(0xe8 + 2) EX4; ///< Register 0xE8 bit 2: External Interrupt Enable(s) bit EX4
    _SBIT(0xe8 + 3) EX5; ///< Register 0xE8 bit 3: External Interrupt Enable(s) bit EX5
    _SBIT(0xe8 + 4) EX6; ///< Register 0xE8 bit 4: External Interrupt Enable(s) bit EX6
_SFR(0xf0) B; ///< Register 0xF0: B
    _SBIT(0xf0 + 0) B0; ///< Register 0xF0 bit 0: B bit B0
    _SBIT(0xf0 + 1) B1; ///< Register 0xF0 bit 1: B bit B1
    _SBIT(0xf0 + 2) B2; ///< Register 0xF0 bit 2: B bit B2
    _SBIT(0xf0 + 3) B3; ///< Register 0xF0 bit 3: B bit B3
    _SBIT(0xf0 + 4) B4; ///< Register 0xF0 bit 4: B bit B4
    _SBIT(0xf0 + 5) B5; ///< Register 0xF0 bit 5: B bit B5
    _SBIT(0xf0 + 6) B6; ///< Register 0xF0 bit 6: B bit B6
    _SBIT(0xf0 + 7) B7; ///< Register 0xF0 bit 7: B bit B7
_SFR(0xf8) EIP; ///< Register 0xF8: External Interrupt Priority 1 Control
    _SBIT(0xf8 + 1) PUSB; ///< Register 0xF8 bit 1: External Interrupt Priority 1 Control bit PUSB
    _SBIT(0xf8 + 2) PI2C; ///< Register 0xF8 bit 2: External Interrupt Priority 1 Control bit PI2C
    _SBIT(0xf8 + 3) PX4; ///< Register 0xF8 bit 3: External Interrupt Priority 1 Control bit PX4
    _SBIT(0xf8 + 4) PX5; ///< Register 0xF8 bit 4: External Interrupt Priority 1 Control bit PX5
    _SBIT(0xf8 + 5) PX6; ///< Register 0xF8 bit 5: External Interrupt Priority 1 Control bit PX6

// GPIF Waveform Memories

_IOR(0xe400) WAVEDATA[128]; ///< Register 0xE400: GPIF Waveform Descriptor 0, 1, 2, 3 data

// General Configuration

_IOR(0xe50d) GPCR2; ///< Register 0xE50D: General Purpose Configuration Register 2
_IOR(0xe600) CPUCS; ///< Register 0xE600: CPU Control & Status
_IOR(0xe601) IFCONFIG; ///< Register 0xE601: Interface Configuration (Ports, GPIF, slave FIFOs)
_IOR(0xe602) PINFLAGSAB; ///< Register 0xE602: Slave FIFO FLAGA and FLAGB Pin Configuration
_IOR(0xe603) PINFLAGSCD; ///< Register 0xE603: Slave FIFO FLAGC and FLAGD Pin Configuration
_IOR(0xe604) FIFORESET; ///< Register 0xE604: Restore FIFOS to default state
_IOR(0xe605) BREAKPT; ///< Register 0xE605: Breakpoint Control
_IOR(0xe606) BPADDRH; ///< Register 0xE606: Breakpoint Address H
_IOR(0xe607) BPADDRL; ///< Register 0xE607: Breakpoint Address L
_IOR(0xe608) UART230; ///< Register 0xE608: 230 Kbaud internally generated ref. clock
_IOR(0xe609) FIFOPINPOLAR; ///< Register 0xE609: Slave FIFO Interface pins polarity
_IOR(0xe60a) REVID; ///< Register 0xE60A: Chip Revision
_IOR(0xe60b) REVCTL; ///< Register 0xE60B: Chip Revision Control

// UDMA

_IOR(0xe60c) GPIFHOLDAMOUNT; ///< Register 0xE60C: MSTB Hold Time (for UDMA)

// Endpoint Configuration

_IOR(0xe610) EP1OUTCFG; ///< Register 0xE610: Endpoint 1-OUT Configuration
_IOR(0xe611) EP1INCFG; ///< Register 0xE611: Endpoint 1-IN Configuration
_IOR(0xe612) EP2CFG; ///< Register 0xE612: Endpoint 2 Configuration
_IOR(0xe613) EP4CFG; ///< Register 0xE613: Endpoint 4 Configuration
_IOR(0xe614) EP6CFG; ///< Register 0xE614: Endpoint 6 Configuration
_IOR(0xe615) EP8CFG; ///< Register 0xE615: Endpoint 8 Configuration
_IOR(0xe618) EP2FIFOCFG; ///< Register 0xE618: Endpoint 2 / slave FIFO configuration
_IOR(0xe619) EP4FIFOCFG; ///< Register 0xE619: Endpoint 4 / slave FIFO configuration
_IOR(0xe61a) EP6FIFOCFG; ///< Register 0xE61A: Endpoint 6 / slave FIFO configuration
_IOR(0xe61b) EP8FIFOCFG; ///< Register 0xE61B: Endpoint 8 / slave FIFO configuration
_IOR(0xe620) EP2AUTOINLENH; ///< Register 0xE620: Endpoint 2 AUTOIN Packet Length H
_IOR(0xe621) EP2AUTOINLENL; ///< Register 0xE621: Endpoint 2 AUTOIN Packet Length L
_IOR(0xe622) EP4AUTOINLENH; ///< Register 0xE622: Endpoint 4 AUTOIN Packet Length H
_IOR(0xe623) EP4AUTOINLENL; ///< Register 0xE623: Endpoint 4 AUTOIN Packet Length L
_IOR(0xe624) EP6AUTOINLENH; ///< Register 0xE624: Endpoint 6 AUTOIN Packet Length H
_IOR(0xe625) EP6AUTOINLENL; ///< Register 0xE625: Endpoint 6 AUTOIN Packet Length L
_IOR(0xe626) EP8AUTOINLENH; ///< Register 0xE626: Endpoint 8 AUTOIN Packet Length H
_IOR(0xe627) EP8AUTOINLENL; ///< Register 0xE627: Endpoint 8 AUTOIN Packet Length L
_IOR(0xe628) ECCCFG; ///< Register 0xE628: ECC Configuration
_IOR(0xe629) ECCRESET; ///< Register 0xE629: ECC Reset
_IOR(0xe62a) ECC1B0; ///< Register 0xE62A: ECC1 Byte 0 Address
_IOR(0xe62b) ECC1B1; ///< Register 0xE62B: ECC1 Byte 1 Address
_IOR(0xe62c) ECC1B2; ///< Register 0xE62C: ECC1 Byte 2 Address
_IOR(0xe62d) ECC2B0; ///< Register 0xE62D: ECC2 Byte 0 Address
_IOR(0xe62e) ECC2B1; ///< Register 0xE62E: ECC2 Byte 1 Address
_IOR(0xe62f) ECC2B2; ///< Register 0xE62F: ECC2 Byte 2 Address
_IOR(0xe630) EP2FIFOPFH; ///< Register 0xE630: Endpoint 2 / slave FIFO Programmable Flag H
_IOR(0xe631) EP2FIFOPFL; ///< Register 0xE631: Endpoint 2 / slave FIFO Programmable Flag L
_IOR(0xe632) EP4FIFOPFH; ///< Register 0xE632: Endpoint 4 / slave FIFO Programmable Flag H
_IOR(0xe633) EP4FIFOPFL; ///< Register 0xE633: Endpoint 4 / slave FIFO Programmable Flag L
_IOR(0xe634) EP6FIFOPFH; ///< Register 0xE634: Endpoint 6 / slave FIFO Programmable Flag H
_IOR(0xe635) EP6FIFOPFL; ///< Register 0xE635: Endpoint 6 / slave FIFO Programmable Flag L
_IOR(0xe636) EP8FIFOPFH; ///< Register 0xE636: Endpoint 8 / slave FIFO Programmable Flag H
_IOR(0xe637) EP8FIFOPFL; ///< Register 0xE637: Endpoint 8 / slave FIFO Programmable Flag L
_IOR(0xe640) EP2ISOINPKTS; ///< Register 0xE640: EP2 (if ISO) IN Packets per frame (1-3)
_IOR(0xe641) EP4ISOINPKTS; ///< Register 0xE641: EP4 (if ISO) IN Packets per frame (1-3)
_IOR(0xe642) EP6ISOINPKTS; ///< Register 0xE642: EP6 (if ISO) IN Packets per frame (1-3)
_IOR(0xe643) EP8ISOINPKTS; ///< Register 0xE643: EP8 (if ISO) IN Packets per frame (1-3)
_IOR(0xe648) INPKTEND; ///< Register 0xE648: Force IN Packet End
_IOR(0xe649) OUTPKTEND; ///< Register 0xE649: Force OUT Packet End

// Interrupts

_IOR(0xe650) EP2FIFOIE; ///< Register 0xE650: Endpoint 2 slave FIFO Flag Interrupt Enable
_IOR(0xe651) EP2FIFOIRQ; ///< Register 0xE651: Endpoint 2 slave FIFO Flag Interrupt Request
_IOR(0xe652) EP4FIFOIE; ///< Register 0xE652: Endpoint 4 slave FIFO Flag Interrupt Enable
_IOR(0xe653) EP4FIFOIRQ; ///< Register 0xE653: Endpoint 4 slave FIFO Flag Interrupt Request
_IOR(0xe654) EP6FIFOIE; ///< Register 0xE654: Endpoint 6 slave FIFO Flag Interrupt Enable
_IOR(0xe655) EP6FIFOIRQ; ///< Register 0xE655: Endpoint 6 slave FIFO Flag Interrupt Request
_IOR(0xe656) EP8FIFOIE; ///< Register 0xE656: Endpoint 8 slave FIFO Flag Interrupt Enable
_IOR(0xe657) EP8FIFOIRQ; ///< Register 0xE657: Endpoint 8 slave FIFO Flag Interrupt Request
_IOR(0xe658) IBNIE; ///< Register 0xE658: IN-BULK-NAK Interrupt Enable
_IOR(0xe659) IBNIRQ; ///< Register 0xE659: IN-BULK-NAK Interrupt Request
_IOR(0xe65a) NAKIE; ///< Register 0xE65A: Endpoint Ping-NAK / IBN Interrupt Enable
_IOR(0xe65b) NAKIRQ; ///< Register 0xE65B: Endpoint Ping-NAK / IBN Interrupt Request
_IOR(0xe65c) USBIE; ///< Register 0xE65C: USB Interrupt Enables
_IOR(0xe65d) USBIRQ; ///< Register 0xE65D: USB Interrupt Requests
_IOR(0xe65e) EPIE; ///< Register 0xE65E: Endpoint Interrupt Enables
_IOR(0xe65f) EPIRQ; ///< Register 0xE65F: Endpoint Interrupt Requests
_IOR(0xe660) GPIFIE; ///< Register 0xE660: GPIF Interrupt Enable
_IOR(0xe661) GPIFIRQ; ///< Register 0xE661: GPIF Interrupt Request
_IOR(0xe662) USBERRIE; ///< Register 0xE662: USB Error Interrupt Enables
_IOR(0xe663) USBERRIRQ; ///< Register 0xE663: USB Error Interrupt Requests
_IOR(0xe664) ERRCNTLIM; ///< Register 0xE664: USB Error counter and limit
_IOR(0xe665) CLRERRCNT; ///< Register 0xE665: Clear Error Counter EC3:0
_IOR(0xe666) INT2IVEC; ///< Register 0xE666: Interrupt 2 (USB) Autovector
_IOR(0xe667) INT4IVEC; ///< Register 0xE667: Interrupt 4 (slave FIFO & 1 GPIF) Autovector
_IOR(0xe668) INTSETUP; ///< Register 0xE668: Interrupt 2&4 setup

// Input/output

_IOR(0xe670) PORTACFG; ///< Register 0xE670: I/O PORTA Alternate Configuration
_IOR(0xe671) PORTCCFG; ///< Register 0xE671: I/O PORTC Alternate Configuration
_IOR(0xe672) PORTECFG; ///< Register 0xE672: I/O PORTE Alternate Configuration
_IOR(0xe678) I2CS; ///< Register 0xE678: I2C Bus Control & Status
_IOR(0xe679) I2DAT; ///< Register 0xE679: I2C Bus Data
_IOR(0xe67a) I2CTL; ///< Register 0xE67A: I2C Bus Control
_IOR(0xe67b) XAUTODAT1; ///< Register 0xE67B: Autoptr1 MOVX access, when APTREN=1
_IOR(0xe67c) XAUTODAT2; ///< Register 0xE67C: Autoptr2 MOVX access, when APTREN=1
_IOR(0xe67d) UDMACRCH; ///< Register 0xE67D: UDMA CRC MSB
_IOR(0xe67e) UDMACRCL; ///< Register 0xE67E: UDMA CRC LSB
_IOR(0xe67f) UDMACRCQUALIFIER; ///< Register 0xE67F: UDMA CRC Qualifier

// USB control

_IOR(0xe680) USBCS; ///< Register 0xE680: USB Control & Status
_IOR(0xe681) SUSPEND; ///< Register 0xE681: Put chip into suspend
_IOR(0xe682) WAKEUPCS; ///< Register 0xE682: Wakeup Control & Status
_IOR(0xe683) TOGCTL; ///< Register 0xE683: Toggle Control
_IOR(0xe684) USBFRAMEH; ///< Register 0xE684: USB Frame count H
_IOR(0xe685) USBFRAMEL; ///< Register 0xE685: USB Frame count L
_IOR(0xe686) MICROFRAME; ///< Register 0xE686: Microframe count, 0-7
_IOR(0xe687) FNADDR; ///< Register 0xE687: USB Function address

// Endpoints

_IOR(0xe68a) EP0BCH; ///< Register 0xE68A: Endpoint 0 Byte Count H
_IOR(0xe68b) EP0BCL; ///< Register 0xE68B: Endpoint 0 Byte Count L
_IOR(0xe68d) EP1OUTBC; ///< Register 0xE68D: Endpoint 1 OUT Byte Count
_IOR(0xe68f) EP1INBC; ///< Register 0xE68F: Endpoint 1 IN Byte Count
_IOR(0xe690) EP2BCH; ///< Register 0xE690: Endpoint 2 Byte Count H
_IOR(0xe691) EP2BCL; ///< Register 0xE691: Endpoint 2 Byte Count L
_IOR(0xe694) EP4BCH; ///< Register 0xE694: Endpoint 4 Byte Count H
_IOR(0xe695) EP4BCL; ///< Register 0xE695: Endpoint 4 Byte Count L
_IOR(0xe698) EP6BCH; ///< Register 0xE698: Endpoint 6 Byte Count H
_IOR(0xe699) EP6BCL; ///< Register 0xE699: Endpoint 6 Byte Count L
_IOR(0xe69c) EP8BCH; ///< Register 0xE69C: Endpoint 8 Byte Count H
_IOR(0xe69d) EP8BCL; ///< Register 0xE69D: Endpoint 8 Byte Count L
_IOR(0xe6a0) EP0CS; ///< Register 0xE6A0: Endpoint 0 Control and Status
_IOR(0xe6a1) EP1OUTCS; ///< Register 0xE6A1: Endpoint 1 OUT Control and Status
_IOR(0xe6a2) EP1INCS; ///< Register 0xE6A2: Endpoint 1 IN Control and Status
_IOR(0xe6a3) EP2CS; ///< Register 0xE6A3: Endpoint 2 Control and Status
_IOR(0xe6a4) EP4CS; ///< Register 0xE6A4: Endpoint 4 Control and Status
_IOR(0xe6a5) EP6CS; ///< Register 0xE6A5: Endpoint 6 Control and Status
_IOR(0xe6a6) EP8CS; ///< Register 0xE6A6: Endpoint 8 Control and Status
_IOR(0xe6a7) EP2FIFOFLGS; ///< Register 0xE6A7: Endpoint 2 slave FIFO Flags
_IOR(0xe6a8) EP4FIFOFLGS; ///< Register 0xE6A8: Endpoint 4 slave FIFO Flags
_IOR(0xe6a9) EP6FIFOFLGS; ///< Register 0xE6A9: Endpoint 6 slave FIFO Flags
_IOR(0xe6aa) EP8FIFOFLGS; ///< Register 0xE6AA: Endpoint 8 slave FIFO Flags
_IOR(0xe6ab) EP2FIFOBCH; ///< Register 0xE6AB: Endpoint 2 slave FIFO total byte count H
_IOR(0xe6ac) EP2FIFOBCL; ///< Register 0xE6AC: Endpoint 2 slave FIFO total byte count L
_IOR(0xe6ad) EP4FIFOBCH; ///< Register 0xE6AD: Endpoint 4 slave FIFO total byte count H
_IOR(0xe6ae) EP4FIFOBCL; ///< Register 0xE6AE: Endpoint 4 slave FIFO total byte count L
_IOR(0xe6af) EP6FIFOBCH; ///< Register 0xE6AF: Endpoint 6 slave FIFO total byte count H
_IOR(0xe6b0) EP6FIFOBCL; ///< Register 0xE6B0: Endpoint 6 slave FIFO total byte count L
_IOR(0xe6b1) EP8FIFOBCH; ///< Register 0xE6B1: Endpoint 8 slave FIFO total byte count H
_IOR(0xe6b2) EP8FIFOBCL; ///< Register 0xE6B2: Endpoint 8 slave FIFO total byte count L
_IOR(0xe6b3) SUDPTRH; ///< Register 0xE6B3: Setup Data Pointer high address byte
_IOR(0xe6b4) SUDPTRL; ///< Register 0xE6B4: Setup Data Pointer low address byte
_IOR(0xe6b5) SUDPTRCTL; ///< Register 0xE6B5: Setup Data Pointer Auto Mode
_IOR(0xe6b8) SETUPDAT[8]; ///< Register 0xE6B8: 8 bytes of setup data

// GPIF

_IOR(0xe6c0) GPIFWFSELECT; ///< Register 0xE6C0: Waveform Selector
_IOR(0xe6c1) GPIFIDLECS; ///< Register 0xE6C1: GPIF Done, GPIF IDLE drive mode
_IOR(0xe6c2) GPIFIDLECTL; ///< Register 0xE6C2: Inactive Bus, CTL states
_IOR(0xe6c3) GPIFCTLCFG; ///< Register 0xE6C3: CTL Drive Type
_IOR(0xe6c4) GPIFADRH; ///< Register 0xE6C4: GPIF Address H
_IOR(0xe6c5) GPIFADRL; ///< Register 0xE6C5: GPIF Address L

// Flowstate

_IOR(0xe6c6) FLOWSTATE; ///< Register 0xE6C6: Flowstate Enable and Selector
_IOR(0xe6c7) FLOWLOGIC; ///< Register 0xE6C7: Flowstate Logic
_IOR(0xe6c8) FLOWEQ0CTL; ///< Register 0xE6C8: CTL-Pin States in Flowstate (when Logic = 0)
_IOR(0xe6c9) FLOWEQ1CTL; ///< Register 0xE6C9: CTL-Pin States in Flowstate (when Logic = 1)
_IOR(0xe6ca) FLOWHOLDOFF; ///< Register 0xE6CA: Holdoff Configuration
_IOR(0xe6cb) FLOWSTB; ///< Register 0xE6CB: Flowstate Strobe Configuration
_IOR(0xe6cc) FLOWSTBEDGE; ///< Register 0xE6CC: Flowstate Rising/Falling Edge Configuration
_IOR(0xe6cd) FLOWSTBPERIOD; ///< Register 0xE6CD: Master-Strobe Half-Period
_IOR(0xe6ce) GPIFTCB3; ///< Register 0xE6CE: GPIF Transaction Count Byte 3
_IOR(0xe6cf) GPIFTCB2; ///< Register 0xE6CF: GPIF Transaction Count Byte 2
_IOR(0xe6d0) GPIFTCB1; ///< Register 0xE6D0: GPIF Transaction Count Byte 1
_IOR(0xe6d1) GPIFTCB0; ///< Register 0xE6D1: GPIF Transaction Count Byte 0
_IOR(0xe6d2) EP2GPIFFLGSEL; ///< Register 0xE6D2: Endpoint 2 GPIF Flag Select
_IOR(0xe6d3) EP2GPIFPFSTOP; ///< Register 0xE6D3: Endpoint 2 GPIF Stop Transaction on Programmable flag
_IOR(0xe6d4) EP2GPIFTRIG; ///< Register 0xE6D4: Endpoint 2 GPIF Trigger
_IOR(0xe6da) EP4GPIFFLGSEL; ///< Register 0xE6DA: Endpoint 4 GPIF Flag Select
_IOR(0xe6db) EP4GPIFPFSTOP; ///< Register 0xE6DB: Endpoint 4 GPIF Stop Transaction on Programmable Flag
_IOR(0xe6dc) EP4GPIFTRIG; ///< Register 0xE6DC: Endpoint 4 GPIF Trigger
_IOR(0xe6e2) EP6GPIFFLGSEL; ///< Register 0xE6E2: Endpoint 6 GPIF Flag Select
_IOR(0xe6e3) EP6GPIFPFSTOP; ///< Register 0xE6E3: Endpoint 6 GPIF Stop Transaction on Programmable flag
_IOR(0xe6e4) EP6GPIFTRIG; ///< Register 0xE6E4: Endpoint 6 GPIF Trigger
_IOR(0xe6ea) EP8GPIFFLGSEL; ///< Register 0xE6EA: Endpoint 8 GPIF Flag Select
_IOR(0xe6eb) EP8GPIFPFSTOP; ///< Register 0xE6EB: Endpoint 8 GPIF Stop Transaction on Programmable flag
_IOR(0xe6ec) EP8GPIFTRIG; ///< Register 0xE6EC: Endpoint 8 GPIF Trigger
_IOR(0xe6f0) XGPIFSGLDATH; ///< Register 0xE6F0: GPIF Data H (16-bit mode only)
_IOR(0xe6f1) XGPIFSGLDATLX; ///< Register 0xE6F1: Read/Write GPIF Data L & trigger transaction
_IOR(0xe6f2) XGPIFSGLDATLNOX; ///< Register 0xE6F2: Read GPIF Data L, no transaction trigger
_IOR(0xe6f3) GPIFREADYCFG; ///< Register 0xE6F3: Internal RDY, Sync/Async, RDY pin states
_IOR(0xe6f4) GPIFREADYSTAT; ///< Register 0xE6F4: GPIF Ready Status
_IOR(0xe6f5) GPIFABORT; ///< Register 0xE6F5: Abort GPIF Waveforms

// Endpoint buffers

_IOR(0xe740) EP0BUF[64]; ///< Register 0xE740: EP0-IN/-OUT buffer
_IOR(0xe780) EP1OUTBUF[64]; ///< Register 0xE780: EP1-OUT buffer
_IOR(0xe7c0) EP1INBUF[64]; ///< Register 0xE7C0: EP1-IN buffer
_IOR(0xf000) EP2FIFOBUF[1024]; ///< Register 0xF000: 512/1024 byte EP 2 / slave FIFO buffer (IN or OUT)
_IOR(0xf400) EP4FIFOBUF[512]; ///< Register 0xF400: 512 byte EP 4 / slave FIFO buffer (IN or OUT)
_IOR(0xf800) EP6FIFOBUF[1024]; ///< Register 0xF800: 512/1024 byte EP 6 / slave FIFO buffer (IN or OUT)
_IOR(0xfc00) EP8FIFOBUF[512]; ///< Register 0xFC00: 512 byte EP 8 / slave FIFO buffer (IN or OUT)

/**
 * \name Bits from register DPS
 * @{
 */
#define _SEL         (1u<<0) ///< Bit 0
/**@}*/

/**
 * \name Bits from register PCON
 * @{
 */
#define _IDLE        (1u<<0) ///< Bit 0
#define _SMOD0       (1u<<7) ///< Bit 7
/**@}*/

/**
 * \name Bits from register TCON
 * @{
 */
#define _IT0         (1u<<0) ///< Bit 0
#define _IE0         (1u<<1) ///< Bit 1
#define _IT1         (1u<<2) ///< Bit 2
#define _IE1         (1u<<3) ///< Bit 3
#define _TR0         (1u<<4) ///< Bit 4
#define _TF0         (1u<<5) ///< Bit 5
#define _TR1         (1u<<6) ///< Bit 6
#define _TF1         (1u<<7) ///< Bit 7
/**@}*/

/**
 * \name Bits from register TMOD
 * @{
 */
#define _M0_0        (1u<<0) ///< Bit 0
#define _M1_0        (1u<<1) ///< Bit 1
#define _CT_0        (1u<<2) ///< Bit 2
#define _GATE_0      (1u<<3) ///< Bit 3
#define _M0_1        (1u<<4) ///< Bit 4
#define _M1_1        (1u<<5) ///< Bit 5
#define _CT_1        (1u<<6) ///< Bit 6
#define _GATE_1      (1u<<7) ///< Bit 7
/**@}*/

/**
 * \name Bits from register CKCON
 * @{
 */
#define _MD0         (1u<<0) ///< Bit 0
#define _MD1         (1u<<1) ///< Bit 1
#define _MD2         (1u<<2) ///< Bit 2
#define _T0M         (1u<<3) ///< Bit 3
#define _T1M         (1u<<4) ///< Bit 4
#define _T2M         (1u<<5) ///< Bit 5
/**@}*/

/**
 * \name Bits from register EXIF
 * @{
 */
#define _USBINT      (1u<<4) ///< Bit 4
#define _I2CINT      (1u<<5) ///< Bit 5
#define _IE4         (1u<<6) ///< Bit 6
#define _IE5         (1u<<7) ///< Bit 7
/**@}*/

/**
 * \name Bits from register SCON0
 * @{
 */
#define _RI_0        (1u<<0) ///< Bit 0
#define _TI_0        (1u<<1) ///< Bit 1
#define _RB8_0       (1u<<2) ///< Bit 2
#define _TB8_0       (1u<<3) ///< Bit 3
#define _REN_0       (1u<<4) ///< Bit 4
#define _SM2_0       (1u<<5) ///< Bit 5
#define _SM1_0       (1u<<6) ///< Bit 6
#define _SM0_0       (1u<<7) ///< Bit 7
/**@}*/

/**
 * \name Bits from register IE
 * @{
 */
#define _EX0         (1u<<0) ///< Bit 0
#define _ET0         (1u<<1) ///< Bit 1
#define _EX1         (1u<<2) ///< Bit 2
#define _ET1         (1u<<3) ///< Bit 3
#define _ES0         (1u<<4) ///< Bit 4
#define _ET2         (1u<<5) ///< Bit 5
#define _ES1         (1u<<6) ///< Bit 6
#define _EA          (1u<<7) ///< Bit 7
/**@}*/

/**
 * \name Bits from register EP2468STAT
 * @{
 */
#define _EP2E        (1u<<0) ///< Bit 0
#define _EP2F        (1u<<1) ///< Bit 1
#define _EP4E        (1u<<2) ///< Bit 2
#define _EP4F        (1u<<3) ///< Bit 3
#define _EP6E        (1u<<4) ///< Bit 4
#define _EP6F        (1u<<5) ///< Bit 5
#define _EP8E        (1u<<6) ///< Bit 6
#define _EP8F        (1u<<7) ///< Bit 7
/**@}*/

/**
 * \name Bits from register EP24FIFOFLGS
 * @{
 */
#define _EP2FF       (1u<<0) ///< Bit 0
#define _EP2EF       (1u<<1) ///< Bit 1
#define _EP2PF       (1u<<2) ///< Bit 2
#define _EP4FF       (1u<<4) ///< Bit 4
#define _EP4EF       (1u<<5) ///< Bit 5
#define _EP4PF       (1u<<6) ///< Bit 6
/**@}*/

/**
 * \name Bits from register EP68FIFOFLGS
 * @{
 */
#define _EP6FF       (1u<<0) ///< Bit 0
#define _EP6EF       (1u<<1) ///< Bit 1
#define _EP6PF       (1u<<2) ///< Bit 2
#define _EP8FF       (1u<<4) ///< Bit 4
#define _EP8EF       (1u<<5) ///< Bit 5
#define _EP8PF       (1u<<6) ///< Bit 6
/**@}*/

/**
 * \name Bits from register AUTOPTRSETUP
 * @{
 */
#define _APTREN      (1u<<0) ///< Bit 0
#define _APTR1INC    (1u<<1) ///< Bit 1
#define _APTR2INC    (1u<<2) ///< Bit 2
/**@}*/

/**
 * \name Bits from register IP
 * @{
 */
#define _PX0         (1u<<0) ///< Bit 0
#define _PT0         (1u<<1) ///< Bit 1
#define _PX1         (1u<<2) ///< Bit 2
#define _PT1         (1u<<3) ///< Bit 3
#define _PS0         (1u<<4) ///< Bit 4
#define _PT2         (1u<<5) ///< Bit 5
#define _PS1         (1u<<6) ///< Bit 6
/**@}*/

/**
 * \name Bits from register EP01STAT
 * @{
 */
#define _EP1OUTBSY   (1u<<1) ///< Bit 1
#define _EP1INBSY    (1u<<2) ///< Bit 2
/**@}*/

/**
 * \name Bits from register GPIFTRIG
 * @{
 */
#define _RW          (1u<<2) ///< Bit 2
/**@}*/

/**
 * \name Bits from registers GPIFIDLECS, GPIFTRIG
 * @{
 */
#define _GPIFIDLE    (1u<<7) ///< Bit 7
/**@}*/

/**
 * \name Bits from register SCON1
 * @{
 */
#define _RI_1        (1u<<0) ///< Bit 0
#define _TI_1        (1u<<1) ///< Bit 1
#define _RB8_1       (1u<<2) ///< Bit 2
#define _TB8_1       (1u<<3) ///< Bit 3
#define _REN_1       (1u<<4) ///< Bit 4
#define _SM2_1       (1u<<5) ///< Bit 5
#define _SM1_1       (1u<<6) ///< Bit 6
#define _SM0_1       (1u<<7) ///< Bit 7
/**@}*/

/**
 * \name Bits from register T2CON
 * @{
 */
#define _CPRL2       (1u<<0) ///< Bit 0
#define _CT2         (1u<<1) ///< Bit 1
#define _TR2         (1u<<2) ///< Bit 2
#define _EXEN2       (1u<<3) ///< Bit 3
#define _TCLK        (1u<<4) ///< Bit 4
#define _RCLK        (1u<<5) ///< Bit 5
#define _EXF2        (1u<<6) ///< Bit 6
#define _TF2         (1u<<7) ///< Bit 7
/**@}*/

/**
 * \name Bits from register PSW
 * @{
 */
#define _P           (1u<<0) ///< Bit 0
#define _F1          (1u<<1) ///< Bit 1
#define _OV          (1u<<2) ///< Bit 2
#define _RS0         (1u<<3) ///< Bit 3
#define _RS1         (1u<<4) ///< Bit 4
#define _F0          (1u<<5) ///< Bit 5
#define _AC          (1u<<6) ///< Bit 6
#define _CY          (1u<<7) ///< Bit 7
/**@}*/

/**
 * \name Bits from register EICON
 * @{
 */
#define _INT6        (1u<<4) ///< Bit 4
#define _RESI        (1u<<5) ///< Bit 5
#define _ERESI       (1u<<6) ///< Bit 6
/**@}*/

/**
 * \name Bits from register EIE
 * @{
 */
#define _EUSB        (1u<<0) ///< Bit 0
#define _EI2C        (1u<<1) ///< Bit 1
#define _EX4         (1u<<2) ///< Bit 2
#define _EX5         (1u<<3) ///< Bit 3
#define _EX6         (1u<<4) ///< Bit 4
/**@}*/

/**
 * \name Bits from register EIP
 * @{
 */
#define _PUSB        (1u<<1) ///< Bit 1
#define _PI2C        (1u<<2) ///< Bit 2
#define _PX4         (1u<<3) ///< Bit 3
#define _PX5         (1u<<4) ///< Bit 4
#define _PX6         (1u<<5) ///< Bit 5
/**@}*/

/**
 * \name Bits from register GPCR2
 * @{
 */
#define _FULL_SPEED_ONLY  (1u<<4) ///< Bit 4
/**@}*/

/**
 * \name Bits from register CPUCS
 * @{
 */
#define _8051RES     (1u<<0) ///< Bit 0
#define _CLKOE       (1u<<1) ///< Bit 1
#define _CLKINV      (1u<<2) ///< Bit 2
#define _CLKSPD0     (1u<<3) ///< Bit 3
#define _CLKSPD1     (1u<<4) ///< Bit 4
#define _PORTCSTB    (1u<<5) ///< Bit 5
/**@}*/

/**
 * \name Bits from register IFCONFIG
 * @{
 */
#define _IFCFG0      (1u<<0) ///< Bit 0
#define _IFCFG1      (1u<<1) ///< Bit 1
#define _GSTATE      (1u<<2) ///< Bit 2
#define _ASYNC       (1u<<3) ///< Bit 3
#define _IFCLKPOL    (1u<<4) ///< Bit 4
#define _IFCLKOE     (1u<<5) ///< Bit 5
#define _3048MHZ     (1u<<6) ///< Bit 6
#define _IFCLKSRC    (1u<<7) ///< Bit 7
/**@}*/

/**
 * \name Bits from register PINFLAGSAB
 * @{
 */
#define _FLAGA0      (1u<<0) ///< Bit 0
#define _FLAGA1      (1u<<1) ///< Bit 1
#define _FLAGA2      (1u<<2) ///< Bit 2
#define _FLAGA3      (1u<<3) ///< Bit 3
#define _FLAGB0      (1u<<4) ///< Bit 4
#define _FLAGB1      (1u<<5) ///< Bit 5
#define _FLAGB2      (1u<<6) ///< Bit 6
#define _FLAGB3      (1u<<7) ///< Bit 7
/**@}*/

/**
 * \name Bits from register PINFLAGSCD
 * @{
 */
#define _FLAGC0      (1u<<0) ///< Bit 0
#define _FLAGC1      (1u<<1) ///< Bit 1
#define _FLAGC2      (1u<<2) ///< Bit 2
#define _FLAGC3      (1u<<3) ///< Bit 3
#define _FLAGD0      (1u<<4) ///< Bit 4
#define _FLAGD1      (1u<<5) ///< Bit 5
#define _FLAGD2      (1u<<6) ///< Bit 6
#define _FLAGD3      (1u<<7) ///< Bit 7
/**@}*/

/**
 * \name Bits from register FIFORESET
 * @{
 */
#define _NAKALL      (1u<<7) ///< Bit 7
/**@}*/

/**
 * \name Bits from register BREAKPT
 * @{
 */
#define _BPEN        (1u<<1) ///< Bit 1
#define _BPPULSE     (1u<<2) ///< Bit 2
#define _BREAK       (1u<<3) ///< Bit 3
/**@}*/

/**
 * \name Bits from register UART230
 * @{
 */
#define _230UART0    (1u<<0) ///< Bit 0
#define _230UART1    (1u<<1) ///< Bit 1
/**@}*/

/**
 * \name Bits from register FIFOPINPOLAR
 * @{
 */
#define _SLWR        (1u<<2) ///< Bit 2
#define _SLRD        (1u<<3) ///< Bit 3
#define _SLOE        (1u<<4) ///< Bit 4
#define _PKTEND      (1u<<5) ///< Bit 5
/**@}*/

/**
 * \name Bits from registers EP2FIFOFLGS, EP2FIFOIE, EP2FIFOIRQ, EP4FIFOFLGS, EP4FIFOIE, EP4FIFOIRQ, EP6FIFOFLGS, EP6FIFOIE, EP6FIFOIRQ, EP8FIFOFLGS, EP8FIFOIE, EP8FIFOIRQ, FIFOPINPOLAR
 * @{
 */
#define _FF          (1u<<0) ///< Bit 0
#define _EF          (1u<<1) ///< Bit 1
/**@}*/

/**
 * \name Bits from register REVCTL
 * @{
 */
#define _ENH_PKT     (1u<<0) ///< Bit 0
#define _DYN_OUT     (1u<<1) ///< Bit 1
/**@}*/

/**
 * \name Bits from register GPIFHOLDAMOUNT
 * @{
 */
#define _HOLDTIME0   (1u<<0) ///< Bit 0
#define _HOLDTIME1   (1u<<1) ///< Bit 1
/**@}*/

/**
 * \name Bits from registers EP2CFG, EP6CFG
 * @{
 */
#define _BUF0        (1u<<0) ///< Bit 0
#define _BUF1        (1u<<1) ///< Bit 1
#define _SIZE        (1u<<3) ///< Bit 3
/**@}*/

/**
 * \name Bits from registers EP2CFG, EP4CFG, EP6CFG, EP8CFG
 * @{
 */
#define _DIR         (1u<<6) ///< Bit 6
/**@}*/

/**
 * \name Bits from registers EP1INCFG, EP1OUTCFG, EP2CFG, EP4CFG, EP6CFG, EP8CFG
 * @{
 */
#define _TYPE0       (1u<<4) ///< Bit 4
#define _TYPE1       (1u<<5) ///< Bit 5
#define _VALID       (1u<<7) ///< Bit 7
/**@}*/

/**
 * \name Bits from registers EP2FIFOCFG, EP4FIFOCFG, EP6FIFOCFG, EP8FIFOCFG
 * @{
 */
#define _WORDWIDE    (1u<<0) ///< Bit 0
#define _ZEROLENIN   (1u<<2) ///< Bit 2
#define _AUTOIN      (1u<<3) ///< Bit 3
#define _AUTOOUT     (1u<<4) ///< Bit 4
#define _OEP1        (1u<<5) ///< Bit 5
#define _INFM1       (1u<<6) ///< Bit 6
/**@}*/

/**
 * \name Bits from register ECCCFG
 * @{
 */
#define _ECCM        (1u<<0) ///< Bit 0
/**@}*/

/**
 * \name Bits from registers EP2FIFOPFH, EP4FIFOPFH, EP6FIFOPFH, EP8FIFOPFH
 * @{
 */
#define _PKTSTAT     (1u<<6) ///< Bit 6
#define _DECIS       (1u<<7) ///< Bit 7
/**@}*/

/**
 * \name Bits from registers EP2ISOINPKTS, EP4ISOINPKTS, EP6ISOINPKTS, EP8ISOINPKTS
 * @{
 */
#define _AADJ        (1u<<7) ///< Bit 7
/**@}*/

/**
 * \name Bits from registers EP2BCL, EP4BCL, EP6BCL, EP8BCL, INPKTEND, OUTPKTEND
 * @{
 */
#define _SKIP        (1u<<7) ///< Bit 7
/**@}*/

/**
 * \name Bits from registers EP2FIFOIE, EP4FIFOIE, EP6FIFOIE, EP8FIFOIE
 * @{
 */
#define _EDGEPF      (1u<<3) ///< Bit 3
/**@}*/

/**
 * \name Bits from registers EP2FIFOFLGS, EP2FIFOIE, EP2FIFOIRQ, EP4FIFOFLGS, EP4FIFOIE, EP4FIFOIRQ, EP6FIFOFLGS, EP6FIFOIE, EP6FIFOIRQ, EP8FIFOFLGS, EP8FIFOIE, EP8FIFOIRQ
 * @{
 */
#define _PF          (1u<<2) ///< Bit 2
/**@}*/

/**
 * \name Bits from registers IBNIE, IBNIRQ
 * @{
 */
#define _IBNI_EP0    (1u<<0) ///< Bit 0
#define _IBNI_EP1    (1u<<1) ///< Bit 1
#define _IBNI_EP2    (1u<<2) ///< Bit 2
#define _IBNI_EP4    (1u<<3) ///< Bit 3
#define _IBNI_EP6    (1u<<4) ///< Bit 4
#define _IBNI_EP8    (1u<<5) ///< Bit 5
/**@}*/

/**
 * \name Bits from registers NAKIE, NAKIRQ
 * @{
 */
#define _IBN         (1u<<0) ///< Bit 0
/**@}*/

/**
 * \name Bits from registers USBIE, USBIRQ
 * @{
 */
#define _SUDAV       (1u<<0) ///< Bit 0
#define _SOF         (1u<<1) ///< Bit 1
#define _SUTOK       (1u<<2) ///< Bit 2
#define _SUSP        (1u<<3) ///< Bit 3
#define _URES        (1u<<4) ///< Bit 4
#define _HSGRANT     (1u<<5) ///< Bit 5
#define _EP0ACK      (1u<<6) ///< Bit 6
/**@}*/

/**
 * \name Bits from registers EPIE, EPIRQ
 * @{
 */
#define _EPI_EP0IN   (1u<<0) ///< Bit 0
#define _EPI_EP0OUT  (1u<<1) ///< Bit 1
#define _EPI_EP1IN   (1u<<2) ///< Bit 2
#define _EPI_EP1OUT  (1u<<3) ///< Bit 3
#define _EPI_EP2     (1u<<4) ///< Bit 4
#define _EPI_EP4     (1u<<5) ///< Bit 5
#define _EPI_EP6     (1u<<6) ///< Bit 6
#define _EPI_EP8     (1u<<7) ///< Bit 7
/**@}*/

/**
 * \name Bits from registers GPIFIE, GPIFIRQ
 * @{
 */
#define _GPIFDONE    (1u<<0) ///< Bit 0
#define _GPIFWF      (1u<<1) ///< Bit 1
/**@}*/

/**
 * \name Bits from registers USBERRIE, USBERRIRQ
 * @{
 */
#define _ERRLIMIT    (1u<<0) ///< Bit 0
#define _ISOEP2      (1u<<4) ///< Bit 4
#define _ISOEP4      (1u<<5) ///< Bit 5
#define _ISOEP6      (1u<<6) ///< Bit 6
#define _ISOEP8      (1u<<7) ///< Bit 7
/**@}*/

/**
 * \name Bits from register INTSETUP
 * @{
 */
#define _AV4EN       (1u<<0) ///< Bit 0
#define _INT4SRC     (1u<<1) ///< Bit 1
#define _AV2EN       (1u<<3) ///< Bit 3
/**@}*/

/**
 * \name Bits from register PORTACFG
 * @{
 */
#define _INT0        (1u<<0) ///< Bit 0
#define _INT1        (1u<<1) ///< Bit 1
#define _SLCS        (1u<<6) ///< Bit 6
#define _FLAGD       (1u<<7) ///< Bit 7
/**@}*/

/**
 * \name Bits from register PORTCCFG
 * @{
 */
#define _GPIFA0      (1u<<0) ///< Bit 0
#define _GPIFA1      (1u<<1) ///< Bit 1
#define _GPIFA2      (1u<<2) ///< Bit 2
#define _GPIFA3      (1u<<3) ///< Bit 3
#define _GPIFA4      (1u<<4) ///< Bit 4
#define _GPIFA5      (1u<<5) ///< Bit 5
#define _GPIFA6      (1u<<6) ///< Bit 6
#define _GPIFA7      (1u<<7) ///< Bit 7
/**@}*/

/**
 * \name Bits from register PORTECFG
 * @{
 */
#define _T0OUT       (1u<<0) ///< Bit 0
#define _T1OUT       (1u<<1) ///< Bit 1
#define _T2OUT       (1u<<2) ///< Bit 2
#define _RXD0OUT     (1u<<3) ///< Bit 3
#define _RXD1OUT     (1u<<4) ///< Bit 4
#define _INT6EX      (1u<<5) ///< Bit 5
#define _T2EX        (1u<<6) ///< Bit 6
#define _GPIFA8      (1u<<7) ///< Bit 7
/**@}*/

/**
 * \name Bits from register I2CS
 * @{
 */
#define _DONE        (1u<<0) ///< Bit 0
#define _ACK         (1u<<1) ///< Bit 1
#define _BERR        (1u<<2) ///< Bit 2
#define _ID0         (1u<<3) ///< Bit 3
#define _ID1         (1u<<4) ///< Bit 4
#define _LASTRD      (1u<<5) ///< Bit 5
#define _STOP        (1u<<6) ///< Bit 6
#define _START       (1u<<7) ///< Bit 7
/**@}*/

/**
 * \name Bits from register I2CTL
 * @{
 */
#define _400KHZ      (1u<<0) ///< Bit 0
#define _STOPIE      (1u<<1) ///< Bit 1
/**@}*/

/**
 * \name Bits from register USBCS
 * @{
 */
#define _SIGRSUME    (1u<<0) ///< Bit 0
#define _RENUM       (1u<<1) ///< Bit 1
#define _NOSYNSOF    (1u<<2) ///< Bit 2
#define _DISCON      (1u<<3) ///< Bit 3
#define _HSM         (1u<<7) ///< Bit 7
/**@}*/

/**
 * \name Bits from register WAKEUPCS
 * @{
 */
#define _WUEN        (1u<<0) ///< Bit 0
#define _WU2EN       (1u<<1) ///< Bit 1
#define _DPEN        (1u<<2) ///< Bit 2
#define _WUPOL       (1u<<4) ///< Bit 4
#define _WU2POL      (1u<<5) ///< Bit 5
#define _WU          (1u<<6) ///< Bit 6
#define _WU2         (1u<<7) ///< Bit 7
/**@}*/

/**
 * \name Bits from register TOGCTL
 * @{
 */
#define _IO          (1u<<4) ///< Bit 4
#define _R           (1u<<5) ///< Bit 5
#define _S           (1u<<6) ///< Bit 6
#define _Q           (1u<<7) ///< Bit 7
/**@}*/

/**
 * \name Bits from register EP0CS
 * @{
 */
#define _HSNAK       (1u<<7) ///< Bit 7
/**@}*/

/**
 * \name Bits from registers EP0CS, EP1INCS, EP1OUTCS
 * @{
 */
#define _BUSY        (1u<<1) ///< Bit 1
/**@}*/

/**
 * \name Bits from registers EP2CS, EP6CS
 * @{
 */
#define _NPAK2       (1u<<6) ///< Bit 6
/**@}*/

/**
 * \name Bits from registers EP2CS, EP4CS, EP6CS, EP8CS
 * @{
 */
#define _EMPTY       (1u<<2) ///< Bit 2
#define _FULL        (1u<<3) ///< Bit 3
#define _NPAK0       (1u<<4) ///< Bit 4
#define _NPAK1       (1u<<5) ///< Bit 5
/**@}*/

/**
 * \name Bits from registers EP0CS, EP1INCS, EP1OUTCS, EP2CS, EP4CS, EP6CS, EP8CS
 * @{
 */
#define _STALL       (1u<<0) ///< Bit 0
/**@}*/

/**
 * \name Bits from register SUDPTRCTL
 * @{
 */
#define _SDPAUTO     (1u<<0) ///< Bit 0
/**@}*/

/**
 * \name Bits from register GPIFWFSELECT
 * @{
 */
#define _FIFORD0     (1u<<0) ///< Bit 0
#define _FIFORD1     (1u<<1) ///< Bit 1
#define _FIFOWR0     (1u<<2) ///< Bit 2
#define _FIFOWR1     (1u<<3) ///< Bit 3
#define _SINGLERD0   (1u<<4) ///< Bit 4
#define _SINGLERD1   (1u<<5) ///< Bit 5
#define _SINGLEWR0   (1u<<6) ///< Bit 6
#define _SINGLEWR1   (1u<<7) ///< Bit 7
/**@}*/

/**
 * \name Bits from register GPIFIDLECS
 * @{
 */
#define _IDLEDRV     (1u<<0) ///< Bit 0
/**@}*/

/**
 * \name Bits from register GPIFCTLCFG
 * @{
 */
#define _TRICTL      (1u<<7) ///< Bit 7
/**@}*/

/**
 * \name Bits from registers FLOWEQ0CTL, FLOWEQ1CTL
 * @{
 */
#define _CTL0E0      (1u<<4) ///< Bit 4
#define _CTL0E1      (1u<<5) ///< Bit 5
#define _CTL0E2      (1u<<6) ///< Bit 6
#define _CTL0E3      (1u<<7) ///< Bit 7
/**@}*/

/**
 * \name Bits from registers FLOWEQ0CTL, FLOWEQ1CTL, GPIFCTLCFG, GPIFIDLECTL
 * @{
 */
#define _CTL0        (1u<<0) ///< Bit 0
#define _CTL1        (1u<<1) ///< Bit 1
#define _CTL2        (1u<<2) ///< Bit 2
#define _CTL3        (1u<<3) ///< Bit 3
#define _CTL4        (1u<<4) ///< Bit 4
#define _CTL5        (1u<<5) ///< Bit 5
/**@}*/

/**
 * \name Bits from register FLOWSTATE
 * @{
 */
#define _FS2         (1u<<2) ///< Bit 2
#define _FSE         (1u<<7) ///< Bit 7
/**@}*/

/**
 * \name Bits from registers EP2GPIFFLGSEL, EP4GPIFFLGSEL, EP6GPIFFLGSEL, EP8GPIFFLGSEL, FLOWSTATE
 * @{
 */
#define _FS0         (1u<<0) ///< Bit 0
#define _FS1         (1u<<1) ///< Bit 1
/**@}*/

/**
 * \name Bits from register FLOWLOGIC
 * @{
 */
#define _TERMB0      (1u<<0) ///< Bit 0
#define _TERMB1      (1u<<1) ///< Bit 1
#define _TERMB2      (1u<<2) ///< Bit 2
#define _TERMA0      (1u<<3) ///< Bit 3
#define _TERMA1      (1u<<4) ///< Bit 4
#define _TERMA2      (1u<<5) ///< Bit 5
#define _LFUNC0      (1u<<6) ///< Bit 6
#define _LFUNC1      (1u<<7) ///< Bit 7
/**@}*/

/**
 * \name Bits from register FLOWHOLDOFF
 * @{
 */
#define _HOCTL0      (1u<<0) ///< Bit 0
#define _HOCTL1      (1u<<1) ///< Bit 1
#define _HOCTL2      (1u<<2) ///< Bit 2
#define _HOSTATE     (1u<<3) ///< Bit 3
#define _HOPERIOD0   (1u<<4) ///< Bit 4
#define _HOPERIOD1   (1u<<5) ///< Bit 5
#define _HOPERIOD2   (1u<<6) ///< Bit 6
#define _HOPERIOD3   (1u<<7) ///< Bit 7
/**@}*/

/**
 * \name Bits from register FLOWSTB
 * @{
 */
#define _MSTB0       (1u<<0) ///< Bit 0
#define _MSTB1       (1u<<1) ///< Bit 1
#define _MSTB2       (1u<<2) ///< Bit 2
#define _SUSTAIN     (1u<<4) ///< Bit 4
#define _CTLTOGL     (1u<<5) ///< Bit 5
#define _RDYASYNC    (1u<<6) ///< Bit 6
#define _SLAVE       (1u<<7) ///< Bit 7
/**@}*/

/**
 * \name Bits from register FLOWSTBEDGE
 * @{
 */
#define _RISING      (1u<<0) ///< Bit 0
#define _FALLING     (1u<<1) ///< Bit 1
/**@}*/

/**
 * \name Bits from registers EP2GPIFPFSTOP, EP4GPIFPFSTOP, EP6GPIFPFSTOP, EP8GPIFPFSTOP
 * @{
 */
#define _FIFOFLAG    (1u<<0) ///< Bit 0
/**@}*/

/**
 * \name Bits from register GPIFREADYCFG
 * @{
 */
#define _TCXRDY5     (1u<<5) ///< Bit 5
#define _SAS         (1u<<6) ///< Bit 6
#define _INTRDY      (1u<<7) ///< Bit 7
/**@}*/

/**
 * \name Bits from register GPIFREADYSTAT
 * @{
 */
#define _RDY0        (1u<<0) ///< Bit 0
#define _RDY1        (1u<<1) ///< Bit 1
#define _RDY2        (1u<<2) ///< Bit 2
#define _RDY3        (1u<<3) ///< Bit 3
#define _RDY4        (1u<<4) ///< Bit 4
#define _RDY5        (1u<<5) ///< Bit 5
/**@}*/

#endif
