# Introduction
GAM7 is a free, open source command line tool for Google Workspace Administrators to manage domain and user settings quickly and easily.

# Requirements
GAM7 requires paid, or Education/Non-profit, editions of Google Workspace. G Suite Legacy Free Edition has limited API support and not all GAM commands work.

To run all commands properly, GAM7 requires three things:
* An API project which identifies your install of GAM7 to Google and keeps track of API quotas.
* Authorization to act as your Google Workspace Administrator in order to perform management functions like add users, modify group settings and membership and pull domain reports.
* A special service account that is authorized to act on behalf of your users in order to modify user-specific settings and data such as Drive files, Calendars and Gmail messages and settings like signatures.

# Documentation

## Update History
A log of updates to GAM7.

## Installation
Instructions detailing ways of installing GAM7 and alternate installation issues.

## Configuration
Instructions detailing configuration of GAM7 and alternate authorization methods.

## Notes and Information
References to resources that enhance your use of GAM7.

## Definitions
BNF definitions of common items in the GAM7 command syntax.

## Command Processing
Information regarding use of command line options to control how GAM7 operates.

## Collections
BNF Syntax definitions of ways to specify multiple Googlw Workspace opjects.

## Client Access
Syntax, descriptions and examples of commands that are executed by your Google Workspace administrator.

## Special Service Account Access
How to set up a GAM7 Chat Bot; this is required to use the Chat API to manage Chat Spaces in your Google Workspace.

## Service Account Access
Syntax, descriptions and examples of commands that are executed on behalf of your Google Workspace users.

# Installation
* [How to Install GAM7](How-to-Install-GAM7)
* [How to Upgrade GAMADV-XTD3 to GAM7](How-to-Upgrade-GAMADV-XTD3-to-GAM7)
* [How to Upgrade Legacy GAM to GAM7](How-to-Upgrade-Legacy-GAM-to-GAM7)
* [GAM Updates](https://github.com/GAM-team/GAM/wiki/GamUpdates)

# Mailing List / Discussion group
The GAM mailing list / discussion group is hosted on [Google Groups].
You can join the list and interact via email, or just post from the web itself.

# Chat Room

There is a public chat room hosted in Google Chat. [Instructions to join](https://github.com/GAM-team/GAM/wiki/GAM-Public-Chat-Room).

# Source Repository
The official GAM7 source repository is on [GitHub](https://github.com/GAM-team/GAM/tree/master) in the master branch.

# Authors
GAM is maintained by [Jay (James) Lee](mailto:jay0lee@gmail.com) and [Ross Scroggs](mailto:ross.scroggs@gmail.com). Please direct "how do I?" questions to [Google Groups].


[Google Groups]: https://groups.google.com/group/google-apps-manager
