#!/usr/bin/perl

use strict;
use warnings;

my $in_version = 0;
my $in_domain = 0;
my $in_para = 0;

sub close_para {
  if ($in_para) {
    print "</para>\n";
    print "          </listitem>\n";
    $in_para = 0;
  }
}

sub close_domain {
  if ($in_domain) {
    close_para;
    print "        </itemizedlist>\n";
    print "      </listitem>\n";
    $in_domain = 0;
  }
}

sub close_version {
  if ($in_version) {
    close_domain;
    print "    </itemizedlist>\n";
    print "  </listitem>\n";
    $in_version = 0;
  }
}

sub print_para {
  my $x = $_[0];
  $x =~ s/</&lt;/g;
  $x =~ s/>/&gt;/g;
  $x =~ s/`([^`]+)`/<code>$1<\/code>/g;
  print $x
}

print "<itemizedlist>\n";

my $has_git = (-d "../.git");

open(my $in, "<", "../NEWS.md") or die "Can't open NEWS.md: $!";

while (<$in>) {
  if (/^Version ([0-9.]+)/) {
    close_version;
    my $version = $1;
    my $date = "";
    $date = qx(git log -1 --pretty="%ai" gappa-$version --) if ($has_git);
    print "  <listitem>\n";
    if ($date =~ /^([^ ]+).*$/) {
      print "    <para>Version $version ($1)</para>\n";
    } else {
      print "    <para>Version $version</para>\n";
    }
    print "    <itemizedlist>\n";
    $in_version = 1
  } elsif (/^([A-Z].+)/) {
    close_domain;
    $in_domain = 1;
    print "      <listitem>\n";
    print "        <para>$1</para>\n";
    print "        <itemizedlist>\n";
  } elsif (/^  [*] (.+)/) {
    close_para;
    $in_para = 1;
    print "          <listitem>\n";
    print "            <para>";
    print_para($1);
  } elsif (/^    (.+)/) {
    print "\n                  ";
    print_para($1);
  }
}

close_version;
print "</itemizedlist>\n";
