/*******************************************************************************

  Copyright(c) 2003-2004 Aurelien Reynaud.

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the Free
  Software Foundation; either version 2 of the License, or (at your option)
  any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along with
  this program; if not, write to the Free Software Foundation, Inc., 59
  Temple Place - Suite 330, Boston, MA  02111-1307, USA.

  The full GNU General Public License is included in this distribution in the
  file called COPYING.

*******************************************************************************/

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif
#include "ggiterm.h"
#include "debug.h"
#include "lowlevel/lowlevel.h"


/*
 * Translates charcode to the corresponding graphical character when altcharset
 * mode is on.
 * Tries to use all the possibilities of Unicode, and fallbacks to ASCII if the
 * best character does not exist in the current font.
 * Returns the translated character
 */
wchar_t altchar_get(wchar_t charcode)
{
	debug (DEBUG_FUNCTION, "called with args (charcode=%d)", (int)charcode);
	
	switch (charcode) {
		/* Try Unicode replacements first */
		case '+': charcode = 0x2192; break; /* arrow pointing right */
		case ',': charcode = 0x2190; break; /* arrow pointing left */
		case '-': charcode = 0x2191; break; /* arrow pointing up */
		case '.': charcode = 0x2193; break; /* arrow pointing down */
		case '0': charcode = 0x2588; break; /* solid square block */
		case '`': charcode = 0x25C6; break; /* diamond */
		case 'a': charcode = 0x2592; break; /* checker board (stipple) */
		case 'f': charcode = 0x00B0; break; /* degree */
		case 'g': charcode = 0x2213; break; /* plus/minus */
		case 'h': charcode = 0x25A6; break; /* board of squares */
		case 'j': charcode = 0x2518; break; /* rightdown corner */
		case 'k': charcode = 0x2510; break; /* upright corner */
		case 'l': charcode = 0x250C; break; /* upleft corner */
		case 'm': charcode = 0x2514; break; /* downleft corner */
		case 'n': charcode = 0x253C; break; /* crossover */
		case 'o': charcode = 0x23BA; break; /* scan line 1 */
		case 'p': charcode = 0x23BB; break; /* scan line 3 */
		case 'q': charcode = 0x2500; break; /* horizontal line */
		case 'r': charcode = 0x23BC; break; /* scan line 7 */
		case 's': charcode = 0x23BD; break; /* scan line 9 */
		case 't': charcode = 0x251C; break; /* tee pointing right */
		case 'u': charcode = 0x2524; break; /* tee pointing left */
		case 'v': charcode = 0x2534; break; /* tee pointing up */
		case 'w': charcode = 0x252C; break; /* tee pointing down */
		case 'x': charcode = 0x2502; break; /* vertical line */
		case 'y': charcode = 0x2264; break; /* less or equal */
		case 'z': charcode = 0x2265; break; /* more or equal */
		case '{': charcode = 0x03C0; break; /* Pi */
		case '|': charcode = 0x2260; break; /* not equal */
		case '}': charcode = 0x00A3; break; /* UK pound */
		case '~': charcode = 0x2022; break; /* bullet */
		
		/* Try other Unicode replacements */
		case 0x25C6: charcode = 0x0266; break; /* diamond */
		case 0x2213: charcode = 0x00B1; break; /* plus/minus */
		
		/* Finally resort to ASCII */
		case 0x2192: charcode = '>'; break; /* arrow pointing right */
		case 0x2190: charcode = '<'; break; /* arrow pointing left */
		case 0x2191: charcode = 0136; break; /* arrow pointing up */
		case 0x2193: charcode = 'v'; break; /* arrow pointing down */
		case 0x2588: charcode = '#'; break; /* solid square block */
		case 0x0266: charcode = '+'; break; /* diamond */
		case 0x2592: charcode = ':'; break; /* checker board (stipple) */
		case 0x00B0: charcode = '\\'; break; /* degree */
		case 0x00B1: charcode = '#'; break; /* plus/minus */
		case 0x25A6: charcode = '#'; break; /* board of squares */
		case 0x2518: charcode = '+'; break; /* rightdown corner */
		case 0x2510: charcode = '+'; break; /* upright corner */
		case 0x250C: charcode = '+'; break; /* upleft corner */
		case 0x2514: charcode = '+'; break; /* downleft corner */
		case 0x253C: charcode = '+'; break; /* crossover */
		case 0x23BA: charcode = '~'; break; /* scan line 1 */
		case 0x23BB: charcode = '-'; break; /* scan line 3 */
		case 0x2500: charcode = '-'; break; /* horizontal line */
		case 0x23BC: charcode = '-'; break; /* scan line 7 */
		case 0x23BD: charcode = '_'; break; /* scan line 9 */
		case 0x251C: charcode = '+'; break; /* tee pointing right */
		case 0x2524: charcode = '+'; break; /* tee pointing left */
		case 0x2534: charcode = '+'; break; /* tee pointing up */
		case 0x252C: charcode = '+'; break; /* tee pointing down */
		case 0x2502: charcode = '|'; break; /* vertical line */
		case 0x2264: charcode = '<'; break; /* less or equal */
		case 0x2265: charcode = '>'; break; /* more or equal */
		case 0x03C0: charcode = '*'; break; /* Pi */
		case 0x2260: charcode = '!'; break; /* not equal */
		case 0x00A3: charcode = 'f'; break; /* UK pound */
		case 0x2022: charcode = 'o'; break; /* bullet */
	}
	if (!lowlevel_has_glyph(charcode))
		charcode = altchar_get(charcode);
	
	debug (DEBUG_FUNCTION, "Leaving");
	return charcode;
}
