/*******************************************************************************

  Copyright(c) 2003-2004 Aurelien Reynaud.

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the Free
  Software Foundation; either version 2 of the License, or (at your option)
  any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along with
  this program; if not, write to the Free Software Foundation, Inc., 59
  Temple Place - Suite 330, Boston, MA  02111-1307, USA.

  The full GNU General Public License is included in this distribution in the
  file called COPYING.

*******************************************************************************/

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif
#include "ggiterm.h"
#include "debug.h"
#include "terminal.h"
#include "lowlevel/lowlevel.h"
#include "history.h"

#include <sys/time.h> /* for gettimeofday */

#define BLINK_TIME	400

extern int terminal_width, terminal_height;
extern int cursor_mode;
extern int cursor_x, cursor_y;

void text_cell2attr(cell_t, wchar_t *, int *, int *, int *);


int blinking_state = 0;


int blink ()
{
	static struct timeval last_blink = { 0, 0 };
	struct timeval current_time;
	unsigned long millisec;
	cell_t blinking_char;
	cell_t *line_p;
	int i, j, length, has_blink;
	int dummy_color;
	
	debug (DEBUG_FUNCTION, "called with no args");
	
	gettimeofday (&current_time, NULL);
	millisec = (current_time.tv_sec - last_blink.tv_sec) * 1000
	            + (current_time.tv_usec - last_blink.tv_usec)/1000;
	
	if (millisec < BLINK_TIME) {
		debug (DEBUG_FUNCTION, "Leaving");
		return 0;
	}

	for (j=0; j<terminal_height; j++) {
		history_get_line(j, &line_p, &length, &has_blink);
		if (!has_blink)
			continue;
		for (i=0; i<terminal_width; i++) {
			blinking_char = line_p[i];
			if ((blinking_char.mode & MODE_BLINK) == 0)
				continue;
			if (blinking_state) {
				dummy_color           = blinking_char.bgcolor;
				blinking_char.bgcolor = blinking_char.fgcolor;
				blinking_char.fgcolor = dummy_color;
			}
			/* No need to check for pending scroll, we are called after resync */
			render_write_char (i, j,
			                   blinking_char.charcode,
			                   blinking_char.fgcolor, blinking_char.bgcolor,
			                   blinking_char.mode & MODE_UNDERLINE);
		}
	}

	/* We change blinking_state here, so cursor doesn't get blinked at the
	   same time as other cells */
	blinking_state = 1 - blinking_state;

	if (!(cursor_mode & CURSOR_INVISIBLE) &&
	    !(cursor_mode & CURSOR_HIDE) &&
	    cursor_x < terminal_width &&
	    cursor_y < terminal_height) {
		blinking_char = history_get_char (cursor_x, cursor_y);
		blinking_char.mode |= MODE_BLINK;
		if (blinking_state) {
			dummy_color           = blinking_char.bgcolor;
			blinking_char.bgcolor = blinking_char.fgcolor;
			blinking_char.fgcolor = dummy_color;
		}
		/* No need to check for pending scroll, we are called after resync */
		render_write_char (cursor_x, cursor_y,
		                   blinking_char.charcode,
		                   blinking_char.fgcolor, blinking_char.bgcolor,
		                   blinking_char.mode & MODE_UNDERLINE);
	}
	
	last_blink = current_time;
	debug (DEBUG_FUNCTION, "Leaving");
	return 1;
}
