/*******************************************************************************

  Copyright(c) 2003-2004 Aurelien Reynaud.

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the Free
  Software Foundation; either version 2 of the License, or (at your option)
  any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along with
  this program; if not, write to the Free Software Foundation, Inc., 59
  Temple Place - Suite 330, Boston, MA  02111-1307, USA.

  The full GNU General Public License is included in this distribution in the
  file called COPYING.

*******************************************************************************/

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif


#include "debug.h"
#include "ggiterm.h" /* For APP_OUTPUT_SIZE */
#include <stdio.h>

#define RESULT_SIZE (APP_OUTPUT_SIZE * 4 + 1)

char result[RESULT_SIZE];
int debuglevel = 0;

char* binary_to_printable (unsigned char* buffer, int size)
{
	int i=0, index=0;

	while (i<size) {
		if (index>RESULT_SIZE-4-1) {
			error ("Buffer size exceeded! Output was troncated.");
			break;
		}
		if (buffer[i]>=32 && buffer[i]<=126) {
			sprintf (result+index, "%c", buffer[i]);
			index++;
		} else {
			sprintf (result+index, "\\%03o", buffer[i]);
			index += 4;
		}
		i++;
	}
	result[index] = '\0';
	return result;
}
