/*******************************************************************************

  Copyright(c) 2003-2004 Aurelien Reynaud.

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the Free
  Software Foundation; either version 2 of the License, or (at your option)
  any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along with
  this program; if not, write to the Free Software Foundation, Inc., 59
  Temple Place - Suite 330, Boston, MA  02111-1307, USA.

  The full GNU General Public License is included in this distribution in the
  file called COPYING.

*******************************************************************************/

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif
#include "ggiterm.h"
#include "debug.h"

#ifndef HAVE_ISWPRINT

int iswprint (wint_t wc)
{
	debug (DEBUG_FUNCTION,
	       "custom iswprint called with args (wc=%d)", (int)wc);
	
	if (wc >= 0x0 && wc <= 0x1F) return 0;
	if (wc >= 0x7F && wc <= 0x9F) return 0;
	if (wc >= 0xE000 && wc <= 0xF8FF) return 0;
		
	debug (DEBUG_FUNCTION, "Leaving custom iswprint");
	return 1;
}

#endif /* HAVE_ISWPRINT */
