/*******************************************************************************

  Copyright(c) 2003-2004 Aurelien Reynaud.

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the Free
  Software Foundation; either version 2 of the License, or (at your option)
  any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along with
  this program; if not, write to the Free Software Foundation, Inc., 59
  Temple Place - Suite 330, Boston, MA  02111-1307, USA.

  The full GNU General Public License is included in this distribution in the
  file called COPYING.

*******************************************************************************/

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#include "ggiterm.h"
#include "debug.h"

#include <string.h>
#include <stdlib.h>

void cursor_move (int, int);
extern int cursor_x, cursor_y;


char *tabstops;
int tabstops_width;


/* Back to preceding tap stop */
void tabstop_prev ()
{
	debug (DEBUG_FUNCTION, "called with no args");
	do {
		cursor_move (cursor_x - 1, cursor_y);
	} while (cursor_x && !tabstops[cursor_x]);
	debug (DEBUG_FUNCTION, "Leaving");
}

/* Go to the next tab stop */
void tabstop_next ()
{
	debug (DEBUG_FUNCTION, "called with no args");
	do {
		cursor_move (cursor_x + 1, cursor_y);
	} while (cursor_x < tabstops_width-1 && !tabstops[cursor_x]);
	debug (DEBUG_FUNCTION, "Leaving");
}

void tabstop_set ()
{
	debug (DEBUG_FUNCTION, "called with no args");
	tabstops[cursor_x] = 1;
	debug (DEBUG_FUNCTION, "Leaving");
}

void tabstop_clear_all ()
{
	debug (DEBUG_FUNCTION, "called with no args");
	memset (tabstops, 0, tabstops_width);
	debug (DEBUG_FUNCTION, "Leaving");
}

void tabstop_clear ()
{
	debug (DEBUG_FUNCTION, "called with no args");
	tabstops[cursor_x] = 0;
	debug (DEBUG_FUNCTION, "Leaving");
}


/* Allocate and populate the array for tab stops */
int tabstop_init (int width)
{
	int i, err = 0;
	
	debug (DEBUG_FUNCTION, "called with args (width=%d)", width);
	tabstops_width = width;
	tabstops = malloc (tabstops_width * sizeof(char));
	if (tabstops == NULL) {
		err = 1;
	} else {
		for (i=0; i<tabstops_width; i++) {
			tabstops[i] = (i%8 ? 0 : 1);
		}
	}
	debug (DEBUG_FUNCTION, "Leaving");
	return err;
}

void tabstop_exit ()
{
	debug (DEBUG_FUNCTION, "called with no args");
	free (tabstops);
	debug (DEBUG_FUNCTION, "Leaving");
}
