# Oracle


## Fields

| Field                                                                                                                                                                                       | Type                                                                                                                                                                                        | Required                                                                                                                                                                                    | Description                                                                                                                                                                                 |
| ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| `AcceptVersion`                                                                                                                                                                             | **int*                                                                                                                                                                                      | :heavy_minus_sign:                                                                                                                                                                          | The version declared by the service when it accepts the handshake, if applicable.                                                                                                           |
| `ConnectFlags0`                                                                                                                                                                             | map[string]*bool*                                                                                                                                                                           | :heavy_minus_sign:                                                                                                                                                                          | The first set of ConnectFlags returned in the Accept packet.                                                                                                                                |
| `ConnectFlags1`                                                                                                                                                                             | map[string]*bool*                                                                                                                                                                           | :heavy_minus_sign:                                                                                                                                                                          | The second set of ConnectFlags returned in the Accept packet.                                                                                                                               |
| `DidResend`                                                                                                                                                                                 | **bool*                                                                                                                                                                                     | :heavy_minus_sign:                                                                                                                                                                          | Whether the server requested that the scanner resend its initial connection packet.                                                                                                         |
| `GlobalServiceOptions`                                                                                                                                                                      | map[string]*bool*                                                                                                                                                                           | :heavy_minus_sign:                                                                                                                                                                          | Set of flags that the server returns in the Accept packet.                                                                                                                                  |
| `NsnServiceVersions`                                                                                                                                                                        | map[string]*string*                                                                                                                                                                         | :heavy_minus_sign:                                                                                                                                                                          | A map from the native Service Negotation service names to the ReleaseVersion (in dotted-decimal format) in that service packet.                                                             |
| `NsnVersion`                                                                                                                                                                                | **string*                                                                                                                                                                                   | :heavy_minus_sign:                                                                                                                                                                          | The version string in the root of the native service negotiation packet, if applicable.                                                                                                     |
| `RefuseError`                                                                                                                                                                               | [][components.OracleDescriptor](../../models/components/oracledescriptor.md)                                                                                                                | :heavy_minus_sign:                                                                                                                                                                          | The parsed descriptor returned by the server in the Refuse packet; it is empty if the server does not return a Refuse packet. The keys are strings like 'DESCRIPTION.ERROR_STACK.ERROR.CODE |
| `RefuseErrorRaw`                                                                                                                                                                            | **string*                                                                                                                                                                                   | :heavy_minus_sign:                                                                                                                                                                          | The unparsed error received when the initial handshake is refused.                                                                                                                          |
| `RefuseReasonApp`                                                                                                                                                                           | **string*                                                                                                                                                                                   | :heavy_minus_sign:                                                                                                                                                                          | The 'AppReason' returned by the server in the RefusePacket, as an 8-bit unsigned hex string.                                                                                                |
| `RefuseReasonSys`                                                                                                                                                                           | **string*                                                                                                                                                                                   | :heavy_minus_sign:                                                                                                                                                                          | The 'SysReason' returned by the server in the RefusePacket, as an 8-bit unsigned hex string.                                                                                                |
| `RefuseVersion`                                                                                                                                                                             | **string*                                                                                                                                                                                   | :heavy_minus_sign:                                                                                                                                                                          | The version declared by the service when it refuses the handshake, if applicable.                                                                                                           |