/*-----------------------------------------------------------------------------
  Module header file for: db module
-----------------------------------------------------------------------------*/

#ifndef dbddr_H
#define dbddr_H

#ifndef UTIL_H
#include "util.h"
#endif

#ifndef db_TYPEDEF_H
#include "dbtypedef.h"
#endif

/*-----------------------------------------------------------------------------
    Typedefs, constants, and enums here.
-----------------------------------------------------------------------------*/
typedef struct _dbDesign *dbDesign;
typedef struct _dbNetlist *dbNetlist;
typedef struct _dbNet *dbNet;
typedef struct _dbInst *dbInst;
typedef struct _dbMport *dbMport;
typedef struct _dbPort *dbPort;
typedef struct _dbMbus *dbMbus;
typedef struct _dbBus *dbBus;
typedef struct _dbHier *dbHier;
typedef struct _dbGlobal *dbGlobal;
typedef struct _dbAttr *dbAttr;
typedef struct _dbRoot *dbRoot;
typedef struct _dbDevspec *dbDevspec;

/* MportType enumerated type */
typedef enum {
    DB_OUT,  /* 0 */
    DB_IN,  /* 1 */
    DB_IO,  /* 2 */
    DB_OC,  /* 3 */
    DB_OE,  /* 4 */
    DB_PAS,  /* 5 */
    DB_TP,  /* 6 */
    DB_TRI,  /* 7 */
    DB_CLK,  /* 8 */
    DB_PWR,  /* 9 */
    DB_NODIR   /* 10 */
} dbMportType;

/* NetlistType enumerated type */
typedef enum {
    DB_JOIN,  /* 0 */
    DB_SUBCIRCUIT,  /* 1 */
    DB_DEVICE,  /* 2 */
    DB_POWER,  /* 3 */
    DB_FLAG   /* 4 */
} dbNetlistType;

/* SpiceTargetType enumerated type */
typedef enum {
    DB_NULL_SPICE_TYPE,  /* 0 */
    DB_LTSPICE,  /* 1 */
    DB_TCLSPICE,  /* 2 */
    DB_HSPICE,  /* 3 */
    DB_PSPICE   /* 4 */
} dbSpiceTargetType;

/* Direction enumerated type */
typedef enum {
    DB_INOUT,  /* 0 */
    DB_OUTPUT,  /* 1 */
    DB_INPUT   /* 2 */
} dbDirection;

/*----------------------------------------------------------------------------
  Design methods.
----------------------------------------------------------------------------*/
#define dbDesignNull ((dbDesign)(NULL))
extern dbDesign dbDesignAlloc(void);
#define _dbDesignNextFree(Design) (*(dbDesign *)(void *)(Design))
extern void dbDesignFree(dbDesign Design);
#define dbDesignGetDestructorHook() (dbDesignDestructorHook)
#define dbDesignSetDestructorHook(func) (dbDesignDestructorHook = (func))
extern void dbDesignDestroy(dbDesign Design);
#define dbDesignGetZeroGlobal(Design) ((Design)->ZeroGlobal)
#define dbDesignSetZeroGlobal(_Design, value) ((_Design)->ZeroGlobal = (value))
#define dbDesignGetOneGlobal(Design) ((Design)->OneGlobal)
#define dbDesignSetOneGlobal(_Design, value) ((_Design)->OneGlobal = (value))
extern void dbDesignInsertNetlist(dbDesign Design, dbNetlist _Netlist);
extern void dbDesignRemoveNetlist(dbDesign Design, dbNetlist _Netlist);
extern void dbDesignAppendNetlist(dbDesign Design, dbNetlist _Netlist);
#define dbDesignFindNetlist(Design, name) (dbNetlist)utqEntryHtblSym(&(Design)->Netlists, name)
#define dbDesignGetnumNetlists(Design) ((Design)->Netlists.count)
#define dbDesignGetNetlists(Design) (&(Design)->Netlists)
#define dbDesignGetfirstNetlist(Design) ((dbNetlist)(utfHtblEntry(dbDesignGetNetlists(Design))))
#define dbDesignGetlastNetlist(Design) ((dbNetlist)(utlHtblEntry(dbDesignGetNetlists(Design))))
#define dbForeachDesignNetlist(Design, _Netlist) for(_Netlist = dbDesignGetfirstNetlist(Design); \
_Netlist != dbNetlistNull; _Netlist = dbNetlistGetnextDesignNetlist(_Netlist))
#define dbEndForeachDesignNetlist
#define dbSafeForeachDesignNetlist(Design, _Netlist) {\
    dbNetlist _nextNetlist;\
    for(_Netlist = dbDesignGetfirstNetlist(Design); \
        _Netlist != dbNetlistNull; _Netlist = _nextNetlist) {\
        _nextNetlist = dbNetlistGetnextDesignNetlist(_Netlist);
#define dbEndSafeForeachDesignNetlist }}
#define dbDesignGetRootNetlist(_Design) ((_Design)->RootNetlist)
#define dbDesignSetRootNetlist(_Design, value) ((_Design)->RootNetlist = (value))
extern void dbDesignInsertGlobal(dbDesign Design, dbGlobal _Global);
extern void dbDesignRemoveGlobal(dbDesign Design, dbGlobal _Global);
extern void dbDesignAppendGlobal(dbDesign Design, dbGlobal _Global);
#define dbDesignFindGlobal(Design, name) (dbGlobal)utqEntryHtblSym(&(Design)->Globals, name)
#define dbDesignGetnumGlobals(Design) ((Design)->Globals.count)
#define dbDesignGetGlobals(Design) (&(Design)->Globals)
#define dbDesignGetfirstGlobal(Design) ((dbGlobal)(utfHtblEntry(dbDesignGetGlobals(Design))))
#define dbDesignGetlastGlobal(Design) ((dbGlobal)(utlHtblEntry(dbDesignGetGlobals(Design))))
#define dbForeachDesignGlobal(Design, _Global) for(_Global = dbDesignGetfirstGlobal(Design); \
_Global != dbGlobalNull; _Global = dbGlobalGetnextDesignGlobal(_Global))
#define dbEndForeachDesignGlobal
#define dbSafeForeachDesignGlobal(Design, _Global) {\
    dbGlobal _nextGlobal;\
    for(_Global = dbDesignGetfirstGlobal(Design); \
        _Global != dbGlobalNull; _Global = _nextGlobal) {\
        _nextGlobal = dbGlobalGetnextDesignGlobal(_Global);
#define dbEndSafeForeachDesignGlobal }}
#define dbDesignGetAttr(_Design) ((_Design)->Attr)
#define dbDesignSetAttr(_Design, value) ((_Design)->Attr = (value))
#define dbDesignGetRoot(_Design) ((_Design)->Root)
#define dbDesignSetRoot(_Design, value) ((_Design)->Root = (value))
#define dbDesignGetSym(Design) ((Design)->h.Sym)
#define dbDesignSetSym(Design, _sym) ((Design)->h.Sym = (_sym))
#define dbDesignGetnextRootDesign(Design) ((dbDesign)((Design)->h.nEntry))

/*----------------------------------------------------------------------------
  Netlist methods.
----------------------------------------------------------------------------*/
#define dbNetlistNull ((dbNetlist)(NULL))
extern dbNetlist dbNetlistAlloc(void);
#define _dbNetlistNextFree(Netlist) (*(dbNetlist *)(void *)(Netlist))
extern void dbNetlistFree(dbNetlist Netlist);
#define dbNetlistGetDestructorHook() (dbNetlistDestructorHook)
#define dbNetlistSetDestructorHook(func) (dbNetlistDestructorHook = (func))
extern void dbNetlistDestroy(dbNetlist Netlist);
#define dbNetlistGetfirstExtension(Netlist) ((Netlist)->_firstExtension)
#define dbNetlistSetfirstExtension(Netlist, extension) (dbNetlistGetfirstExtension(Netlist) = extension)
#define dbNetlistGetDevice(Netlist) ((Netlist)->Device)
#define dbNetlistSetDevice(_Netlist, value) ((_Netlist)->Device = (value))
#define dbNetlistVisited(Netlist) ((Netlist)->Visited)
#define dbNetlistSetVisited(_Netlist, value) ((_Netlist)->Visited = (value))
#define dbNetlistGetType(Netlist) ((Netlist)->Type)
#define dbNetlistSetType(_Netlist, value) ((_Netlist)->Type = (value))
extern void dbNetlistInsertNet(dbNetlist Netlist, dbNet _Net);
extern void dbNetlistRemoveNet(dbNetlist Netlist, dbNet _Net);
extern void dbNetlistAppendNet(dbNetlist Netlist, dbNet _Net);
#define dbNetlistFindNet(Netlist, name) (dbNet)utqEntryHtblSym(&(Netlist)->Nets, name)
#define dbNetlistGetnumNets(Netlist) ((Netlist)->Nets.count)
#define dbNetlistGetNets(Netlist) (&(Netlist)->Nets)
#define dbNetlistGetfirstNet(Netlist) ((dbNet)(utfHtblEntry(dbNetlistGetNets(Netlist))))
#define dbNetlistGetlastNet(Netlist) ((dbNet)(utlHtblEntry(dbNetlistGetNets(Netlist))))
#define dbForeachNetlistNet(Netlist, _Net) for(_Net = dbNetlistGetfirstNet(Netlist); \
_Net != dbNetNull; _Net = dbNetGetnextNetlistNet(_Net))
#define dbEndForeachNetlistNet
#define dbSafeForeachNetlistNet(Netlist, _Net) {\
    dbNet _nextNet;\
    for(_Net = dbNetlistGetfirstNet(Netlist); \
        _Net != dbNetNull; _Net = _nextNet) {\
        _nextNet = dbNetGetnextNetlistNet(_Net);
#define dbEndSafeForeachNetlistNet }}
extern void dbNetlistInsertMport(dbNetlist Netlist, dbMport _Mport);
extern void dbNetlistRemoveMport(dbNetlist Netlist, dbMport _Mport);
extern void dbNetlistAppendMport(dbNetlist Netlist, dbMport _Mport);
#define dbNetlistFindMport(Netlist, name) (dbMport)utqEntryHtblSym(&(Netlist)->Mports, name)
#define dbNetlistGetnumMports(Netlist) ((Netlist)->Mports.count)
#define dbNetlistGetMports(Netlist) (&(Netlist)->Mports)
#define dbNetlistGetfirstMport(Netlist) ((dbMport)(utfHtblEntry(dbNetlistGetMports(Netlist))))
#define dbNetlistGetlastMport(Netlist) ((dbMport)(utlHtblEntry(dbNetlistGetMports(Netlist))))
#define dbForeachNetlistMport(Netlist, _Mport) for(_Mport = dbNetlistGetfirstMport(Netlist); \
_Mport != dbMportNull; _Mport = dbMportGetnextNetlistMport(_Mport))
#define dbEndForeachNetlistMport
#define dbSafeForeachNetlistMport(Netlist, _Mport) {\
    dbMport _nextMport;\
    for(_Mport = dbNetlistGetfirstMport(Netlist); \
        _Mport != dbMportNull; _Mport = _nextMport) {\
        _nextMport = dbMportGetnextNetlistMport(_Mport);
#define dbEndSafeForeachNetlistMport }}
extern void dbNetlistInsertInst(dbNetlist Netlist, dbInst _Inst);
extern void dbNetlistRemoveInst(dbNetlist Netlist, dbInst _Inst);
extern void dbNetlistAppendInst(dbNetlist Netlist, dbInst _Inst);
#define dbNetlistFindInst(Netlist, name) (dbInst)utqEntryHtblSym(&(Netlist)->Insts, name)
#define dbNetlistGetnumInsts(Netlist) ((Netlist)->Insts.count)
#define dbNetlistGetInsts(Netlist) (&(Netlist)->Insts)
#define dbNetlistGetfirstInst(Netlist) ((dbInst)(utfHtblEntry(dbNetlistGetInsts(Netlist))))
#define dbNetlistGetlastInst(Netlist) ((dbInst)(utlHtblEntry(dbNetlistGetInsts(Netlist))))
#define dbForeachNetlistInst(Netlist, _Inst) for(_Inst = dbNetlistGetfirstInst(Netlist); \
_Inst != dbInstNull; _Inst = dbInstGetnextNetlistInst(_Inst))
#define dbEndForeachNetlistInst
#define dbSafeForeachNetlistInst(Netlist, _Inst) {\
    dbInst _nextInst;\
    for(_Inst = dbNetlistGetfirstInst(Netlist); \
        _Inst != dbInstNull; _Inst = _nextInst) {\
        _nextInst = dbInstGetnextNetlistInst(_Inst);
#define dbEndSafeForeachNetlistInst }}
extern void dbNetlistInsertMbus(dbNetlist Netlist, dbMbus _Mbus);
extern void dbNetlistRemoveMbus(dbNetlist Netlist, dbMbus _Mbus);
extern void dbNetlistAppendMbus(dbNetlist Netlist, dbMbus _Mbus);
#define dbNetlistFindMbus(Netlist, name) (dbMbus)utqEntryHtblSym(&(Netlist)->Mbuss, name)
#define dbNetlistGetnumMbuss(Netlist) ((Netlist)->Mbuss.count)
#define dbNetlistGetMbuss(Netlist) (&(Netlist)->Mbuss)
#define dbNetlistGetfirstMbus(Netlist) ((dbMbus)(utfHtblEntry(dbNetlistGetMbuss(Netlist))))
#define dbNetlistGetlastMbus(Netlist) ((dbMbus)(utlHtblEntry(dbNetlistGetMbuss(Netlist))))
#define dbForeachNetlistMbus(Netlist, _Mbus) for(_Mbus = dbNetlistGetfirstMbus(Netlist); \
_Mbus != dbMbusNull; _Mbus = dbMbusGetnextNetlistMbus(_Mbus))
#define dbEndForeachNetlistMbus
#define dbSafeForeachNetlistMbus(Netlist, _Mbus) {\
    dbMbus _nextMbus;\
    for(_Mbus = dbNetlistGetfirstMbus(Netlist); \
        _Mbus != dbMbusNull; _Mbus = _nextMbus) {\
        _nextMbus = dbMbusGetnextNetlistMbus(_Mbus);
#define dbEndSafeForeachNetlistMbus }}
extern void dbNetlistInsertBus(dbNetlist Netlist, dbBus _Bus);
extern void dbNetlistRemoveBus(dbNetlist Netlist, dbBus _Bus);
extern void dbNetlistAppendBus(dbNetlist Netlist, dbBus _Bus);
#define dbNetlistFindBus(Netlist, name) (dbBus)utqEntryHtblSym(&(Netlist)->Buss, name)
#define dbNetlistGetnumBuss(Netlist) ((Netlist)->Buss.count)
#define dbNetlistGetBuss(Netlist) (&(Netlist)->Buss)
#define dbNetlistGetfirstBus(Netlist) ((dbBus)(utfHtblEntry(dbNetlistGetBuss(Netlist))))
#define dbNetlistGetlastBus(Netlist) ((dbBus)(utlHtblEntry(dbNetlistGetBuss(Netlist))))
#define dbForeachNetlistBus(Netlist, _Bus) for(_Bus = dbNetlistGetfirstBus(Netlist); \
_Bus != dbBusNull; _Bus = dbBusGetnextNetlistBus(_Bus))
#define dbEndForeachNetlistBus
#define dbSafeForeachNetlistBus(Netlist, _Bus) {\
    dbBus _nextBus;\
    for(_Bus = dbNetlistGetfirstBus(Netlist); \
        _Bus != dbBusNull; _Bus = _nextBus) {\
        _nextBus = dbBusGetnextNetlistBus(_Bus);
#define dbEndSafeForeachNetlistBus }}
#define dbNetlistGetHier(_Netlist) ((_Netlist)->Hier)
#define dbNetlistSetHier(_Netlist, value) ((_Netlist)->Hier = (value))
#define dbNetlistGetfirstExternalInst(Netlist) ((Netlist)->firstExternalInst)
#define dbNetlistSetfirstExternalInst(Netlist, _ExternalInst) ((Netlist)->firstExternalInst = (_ExternalInst))
extern void dbNetlistInsertExternalInst(dbNetlist Netlist, dbInst _Inst);
extern void dbNetlistRemoveExternalInst(dbNetlist Netlist, dbInst _Inst);
#define dbForeachNetlistExternalInst(Netlist, _Inst) \
    for(_Inst = dbNetlistGetfirstExternalInst(Netlist); _Inst != dbInstNull; \
        _Inst = dbInstGetnextNetlistExternalInst(_Inst))
#define dbEndForeachNetlistExternalInst
#define dbSafeForeachNetlistExternalInst(Netlist, _Inst) {\
    dbInst _nextInst;\
    for(_Inst = dbNetlistGetfirstExternalInst(Netlist); _Inst != dbInstNull; \
        _Inst = _nextInst) {\
        _nextInst = dbInstGetnextNetlistExternalInst(_Inst);
#define dbEndSafeForeachNetlistExternalInst }}
#define dbNetlistGetlastExternalInst(Netlist) ((Netlist)->lastExternalInst)
#define dbNetlistSetlastExternalInst(Netlist, _ExternalInst) ((Netlist)->lastExternalInst = (_ExternalInst))
extern void dbNetlistAppendExternalInst(dbNetlist Netlist, dbInst _ExternalInst);
#define dbNetlistGetAttr(_Netlist) ((_Netlist)->Attr)
#define dbNetlistSetAttr(_Netlist, value) ((_Netlist)->Attr = (value))
#define dbNetlistGetDesign(_Netlist) ((_Netlist)->Design)
#define dbNetlistSetDesign(_Netlist, value) ((_Netlist)->Design = (value))
#define dbNetlistGetSym(Netlist) ((Netlist)->h.Sym)
#define dbNetlistSetSym(Netlist, _sym) ((Netlist)->h.Sym = (_sym))
#define dbNetlistGetnextDesignNetlist(Netlist) ((dbNetlist)((Netlist)->h.nEntry))

/*----------------------------------------------------------------------------
  Net methods.
----------------------------------------------------------------------------*/
#define dbNetNull ((dbNet)(NULL))
extern dbNet _dbNetAlloc(void);
#define _dbNetNextFree(Net) (*(dbNet *)(void *)(Net))
#define dbNetAlloc() (_dbFirstFreeNet == dbNetNull? _dbNetAlloc() : (\
    _dbTempNet = _dbFirstFreeNet,\
    _dbFirstFreeNet = _dbNetNextFree(_dbFirstFreeNet),\
    memset((void *)_dbTempNet, 0, sizeof(struct _dbNet)),\
    _dbTempNet))
#define dbNetFree(Net) (_dbNetNextFree(Net) = _dbFirstFreeNet, _dbFirstFreeNet = (Net))
#define dbNetGetDestructorHook() (dbNetDestructorHook)
#define dbNetSetDestructorHook(func) (dbNetDestructorHook = (func))
extern void dbNetDestroy(dbNet Net);
#define dbNetVisited(Net) ((Net)->Visited)
#define dbNetSetVisited(_Net, value) ((_Net)->Visited = (value))
#define dbNetGetfirstPort(Net) ((Net)->firstPort)
#define dbNetSetfirstPort(Net, _Port) ((Net)->firstPort = (_Port))
extern void dbNetInsertPort(dbNet Net, dbPort _Port);
extern void dbNetRemovePort(dbNet Net, dbPort _Port);
#define dbForeachNetPort(Net, _Port) \
    for(_Port = dbNetGetfirstPort(Net); _Port != dbPortNull; \
        _Port = dbPortGetnextNetPort(_Port))
#define dbEndForeachNetPort
#define dbSafeForeachNetPort(Net, _Port) {\
    dbPort _nextPort;\
    for(_Port = dbNetGetfirstPort(Net); _Port != dbPortNull; \
        _Port = _nextPort) {\
        _nextPort = dbPortGetnextNetPort(_Port);
#define dbEndSafeForeachNetPort }}
#define dbNetGetlastPort(Net) ((Net)->lastPort)
#define dbNetSetlastPort(Net, _Port) ((Net)->lastPort = (_Port))
extern void dbNetAppendPort(dbNet Net, dbPort _Port);
#define dbNetGetAttr(_Net) ((_Net)->Attr)
#define dbNetSetAttr(_Net, value) ((_Net)->Attr = (value))
#define dbNetGetNetlist(_Net) ((_Net)->Netlist)
#define dbNetSetNetlist(_Net, value) ((_Net)->Netlist = (value))
#define dbNetGetSym(Net) ((Net)->h.Sym)
#define dbNetSetSym(Net, _sym) ((Net)->h.Sym = (_sym))
#define dbNetGetnextNetlistNet(Net) ((dbNet)((Net)->h.nEntry))
#define dbNetGetBus(_Net) ((_Net)->Bus)
#define dbNetSetBus(_Net, value) ((_Net)->Bus = (value))
#define dbNetGetBusIndex(Net) ((Net)->BusIndex)
#define dbNetSetBusIndex(Net, value) ((Net)->BusIndex = (value))
#define dbNetGetGlobal(_Net) ((_Net)->Global)
#define dbNetSetGlobal(_Net, value) ((_Net)->Global = (value))
#define dbNetGetnextGlobalNet(Net) ((Net)->nextGlobalNet)
#define dbNetSetnextGlobalNet(Net, nextNet) ((Net)->nextGlobalNet = (nextNet))
#define dbNetGetprevGlobalNet(Net) ((Net)->prevGlobalNet)
#define dbNetSetprevGlobalNet(Net, prevNet) ((Net)->prevGlobalNet = (prevNet))

/*----------------------------------------------------------------------------
  Inst methods.
----------------------------------------------------------------------------*/
#define dbInstNull ((dbInst)(NULL))
extern dbInst _dbInstAlloc(void);
#define _dbInstNextFree(Inst) (*(dbInst *)(void *)(Inst))
#define dbInstAlloc() (_dbFirstFreeInst == dbInstNull? _dbInstAlloc() : (\
    _dbTempInst = _dbFirstFreeInst,\
    _dbFirstFreeInst = _dbInstNextFree(_dbFirstFreeInst),\
    memset((void *)_dbTempInst, 0, sizeof(struct _dbInst)),\
    _dbTempInst))
#define dbInstFree(Inst) (_dbInstNextFree(Inst) = _dbFirstFreeInst, _dbFirstFreeInst = (Inst))
#define dbInstGetDestructorHook() (dbInstDestructorHook)
#define dbInstSetDestructorHook(func) (dbInstDestructorHook = (func))
extern void dbInstDestroy(dbInst Inst);
#define dbInstArray(Inst) ((Inst)->Array)
#define dbInstSetArray(_Inst, value) ((_Inst)->Array = (value))
#define dbInstGetfirstPort(Inst) ((Inst)->firstPort)
#define dbInstSetfirstPort(Inst, _Port) ((Inst)->firstPort = (_Port))
extern void dbInstInsertPort(dbInst Inst, dbPort _Port);
extern void dbInstRemovePort(dbInst Inst, dbPort _Port);
#define dbForeachInstPort(Inst, _Port) \
    for(_Port = dbInstGetfirstPort(Inst); _Port != dbPortNull; \
        _Port = dbPortGetnextInstPort(_Port))
#define dbEndForeachInstPort
#define dbSafeForeachInstPort(Inst, _Port) {\
    dbPort _nextPort;\
    for(_Port = dbInstGetfirstPort(Inst); _Port != dbPortNull; \
        _Port = _nextPort) {\
        _nextPort = dbPortGetnextInstPort(_Port);
#define dbEndSafeForeachInstPort }}
#define dbInstGetlastPort(Inst) ((Inst)->lastPort)
#define dbInstSetlastPort(Inst, _Port) ((Inst)->lastPort = (_Port))
extern void dbInstAppendPort(dbInst Inst, dbPort _Port);
#define dbInstGetAttr(_Inst) ((_Inst)->Attr)
#define dbInstSetAttr(_Inst, value) ((_Inst)->Attr = (value))
#define dbInstGetNetlist(_Inst) ((_Inst)->Netlist)
#define dbInstSetNetlist(_Inst, value) ((_Inst)->Netlist = (value))
#define dbInstGetSym(Inst) ((Inst)->h.Sym)
#define dbInstSetSym(Inst, _sym) ((Inst)->h.Sym = (_sym))
#define dbInstGetnextNetlistInst(Inst) ((dbInst)((Inst)->h.nEntry))
#define dbInstGetHier(_Inst) ((_Inst)->Hier)
#define dbInstSetHier(_Inst, value) ((_Inst)->Hier = (value))
#define dbInstGetnextHierInst(Inst) ((Inst)->nextHierInst)
#define dbInstSetnextHierInst(Inst, nextInst) ((Inst)->nextHierInst = (nextInst))
#define dbInstGetprevHierInst(Inst) ((Inst)->prevHierInst)
#define dbInstSetprevHierInst(Inst, prevInst) ((Inst)->prevHierInst = (prevInst))
#define dbInstGetInternalNetlist(_Inst) ((_Inst)->InternalNetlist)
#define dbInstSetInternalNetlist(_Inst, value) ((_Inst)->InternalNetlist = (value))
#define dbInstGetnextNetlistExternalInst(Inst) ((Inst)->nextNetlistExternalInst)
#define dbInstSetnextNetlistExternalInst(Inst, nextInst) ((Inst)->nextNetlistExternalInst = (nextInst))
#define dbInstGetprevNetlistExternalInst(Inst) ((Inst)->prevNetlistExternalInst)
#define dbInstSetprevNetlistExternalInst(Inst, prevInst) ((Inst)->prevNetlistExternalInst = (prevInst))
#define dbInstGetExternalMbus(_Inst) ((_Inst)->ExternalMbus)
#define dbInstSetExternalMbus(_Inst, value) ((_Inst)->ExternalMbus = (value))

/*----------------------------------------------------------------------------
  Mport methods.
----------------------------------------------------------------------------*/
#define dbMportNull ((dbMport)(NULL))
extern dbMport _dbMportAlloc(void);
#define _dbMportNextFree(Mport) (*(dbMport *)(void *)(Mport))
#define dbMportAlloc() (_dbFirstFreeMport == dbMportNull? _dbMportAlloc() : (\
    _dbTempMport = _dbFirstFreeMport,\
    _dbFirstFreeMport = _dbMportNextFree(_dbFirstFreeMport),\
    memset((void *)_dbTempMport, 0, sizeof(struct _dbMport)),\
    _dbTempMport))
#define dbMportFree(Mport) (_dbMportNextFree(Mport) = _dbFirstFreeMport, _dbFirstFreeMport = (Mport))
#define dbMportGetDestructorHook() (dbMportDestructorHook)
#define dbMportSetDestructorHook(func) (dbMportDestructorHook = (func))
extern void dbMportDestroy(dbMport Mport);
#define dbMportVisited(Mport) ((Mport)->Visited)
#define dbMportSetVisited(_Mport, value) ((_Mport)->Visited = (value))
#define dbMportGetType(Mport) ((Mport)->Type)
#define dbMportSetType(_Mport, value) ((_Mport)->Type = (value))
#define dbMportGetFlagPort(_Mport) ((_Mport)->FlagPort)
#define dbMportSetFlagPort(_Mport, value) ((_Mport)->FlagPort = (value))
#define dbMportGetAttr(_Mport) ((_Mport)->Attr)
#define dbMportSetAttr(_Mport, value) ((_Mport)->Attr = (value))
#define dbMportGetNetlist(_Mport) ((_Mport)->Netlist)
#define dbMportSetNetlist(_Mport, value) ((_Mport)->Netlist = (value))
#define dbMportGetSym(Mport) ((Mport)->h.Sym)
#define dbMportSetSym(Mport, _sym) ((Mport)->h.Sym = (_sym))
#define dbMportGetnextNetlistMport(Mport) ((dbMport)((Mport)->h.nEntry))
#define dbMportGetMbus(_Mport) ((_Mport)->Mbus)
#define dbMportSetMbus(_Mport, value) ((_Mport)->Mbus = (value))
#define dbMportGetMbusIndex(Mport) ((Mport)->MbusIndex)
#define dbMportSetMbusIndex(Mport, value) ((Mport)->MbusIndex = (value))

/*----------------------------------------------------------------------------
  Port methods.
----------------------------------------------------------------------------*/
#define dbPortNull ((dbPort)(NULL))
extern dbPort _dbPortAlloc(void);
#define _dbPortNextFree(Port) (*(dbPort *)(void *)(Port))
#define dbPortAlloc() (_dbFirstFreePort == dbPortNull? _dbPortAlloc() : (\
    _dbTempPort = _dbFirstFreePort,\
    _dbFirstFreePort = _dbPortNextFree(_dbFirstFreePort),\
    memset((void *)_dbTempPort, 0, sizeof(struct _dbPort)),\
    _dbTempPort))
#define dbPortFree(Port) (_dbPortNextFree(Port) = _dbFirstFreePort, _dbFirstFreePort = (Port))
#define dbPortGetDestructorHook() (dbPortDestructorHook)
#define dbPortSetDestructorHook(func) (dbPortDestructorHook = (func))
extern void dbPortDestroy(dbPort Port);
#define dbPortGetNet(_Port) ((_Port)->Net)
#define dbPortSetNet(_Port, value) ((_Port)->Net = (value))
#define dbPortGetnextNetPort(Port) ((Port)->nextNetPort)
#define dbPortSetnextNetPort(Port, nextPort) ((Port)->nextNetPort = (nextPort))
#define dbPortGetprevNetPort(Port) ((Port)->prevNetPort)
#define dbPortSetprevNetPort(Port, prevPort) ((Port)->prevNetPort = (prevPort))
#define dbPortGetInst(_Port) ((_Port)->Inst)
#define dbPortSetInst(_Port, value) ((_Port)->Inst = (value))
#define dbPortGetnextInstPort(Port) ((Port)->nextInstPort)
#define dbPortSetnextInstPort(Port, nextPort) ((Port)->nextInstPort = (nextPort))
#define dbPortGetprevInstPort(Port) ((Port)->prevInstPort)
#define dbPortSetprevInstPort(Port, prevPort) ((Port)->prevInstPort = (prevPort))
#define dbPortGetMport(_Port) ((_Port)->Mport)
#define dbPortSetMport(_Port, value) ((_Port)->Mport = (value))

/*----------------------------------------------------------------------------
  Mbus methods.
----------------------------------------------------------------------------*/
#define dbMbusNull ((dbMbus)(NULL))
extern dbMbus dbMbusAlloc(void);
#define _dbMbusNextFree(Mbus) (*(dbMbus *)(void *)(Mbus))
extern void dbMbusFree(dbMbus Mbus);
#define dbMbusGetDestructorHook() (dbMbusDestructorHook)
#define dbMbusSetDestructorHook(func) (dbMbusDestructorHook = (func))
extern void dbMbusDestroy(dbMbus Mbus);
#define dbMbusGetType(Mbus) ((Mbus)->Type)
#define dbMbusSetType(_Mbus, value) ((_Mbus)->Type = (value))
#define dbMbusGetRight(Mbus) ((Mbus)->Right)
#define dbMbusSetRight(_Mbus, value) ((_Mbus)->Right = (value))
#define dbMbusGetLeft(Mbus) ((Mbus)->Left)
#define dbMbusSetLeft(_Mbus, value) ((_Mbus)->Left = (value))
#define dbMbusGetiMport(Mbus, x) ((Mbus)->Mports[x])
#define dbMbusSetiMport(Mbus, x, _Mport) ((Mbus)->Mports[x] = (_Mport))
#define dbMbusGetnumMports(Mbus) ((Mbus)->numMports)
#define dbMbusSetusedMports(Mbus, numMports) ((Mbus)->usedMports = (numMports))
#define dbMbusGetusedMports(Mbus) ((Mbus)->usedMports)
#define dbMbusGetMports(Mbus) ((Mbus)->Mports)
#define dbMbusAllocMports(Mbus, num) ((Mbus)->usedMports = (num), \
(Mbus)->numMports = (num), (Mbus)->Mports = mtNewA(dbMport, (num)))
#define dbMbusReallocMports(Mbus, num) ((Mbus)->numMports = (num), (Mbus)->Mports = mtResizeArray((Mbus)->Mports, (num)*sizeof(dbMport)))
#define dbMbusFreeMports(Mbus) (mtDelete((Mbus)->Mports), (Mbus)->Mports = NULL, \
    (Mbus)->numMports = 0, (Mbus)->usedMports = 0)
extern void dbMbusInsertMport(dbMbus Mbus, dbMport _Mport);
extern void dbMbusRemoveMport(dbMbus Mbus, dbMport _Mport);
#define dbForeachMbusMport(Mbus, _Mport) { \
    U32 _xMport; \
    for(_xMport = 0; _xMport < dbMbusGetusedMports(Mbus); \
        _xMport++) { \
        _Mport = dbMbusGetiMport(Mbus, _xMport);
#define dbEndForeachMbusMport }}
#define dbSafeForeachMbusMport(Mbus, _Mport) { \
    U32 _xMport; \
    for(_xMport = 0; _xMport < dbMbusGetusedMports(Mbus); \
        dbMbusGetiMport(Mbus, _xMport) == _Mport &&_xMport++) { \
        _Mport = dbMbusGetiMport(Mbus, _xMport); \
        if(_Mport != dbMportNull) {
#define dbEndSafeForeachMbusMport }}}
#define dbMbusGetFlagInst(_Mbus) ((_Mbus)->FlagInst)
#define dbMbusSetFlagInst(_Mbus, value) ((_Mbus)->FlagInst = (value))
#define dbMbusGetNetlist(_Mbus) ((_Mbus)->Netlist)
#define dbMbusSetNetlist(_Mbus, value) ((_Mbus)->Netlist = (value))
#define dbMbusGetSym(Mbus) ((Mbus)->h.Sym)
#define dbMbusSetSym(Mbus, _sym) ((Mbus)->h.Sym = (_sym))
#define dbMbusGetnextNetlistMbus(Mbus) ((dbMbus)((Mbus)->h.nEntry))

/*----------------------------------------------------------------------------
  Bus methods.
----------------------------------------------------------------------------*/
#define dbBusNull ((dbBus)(NULL))
extern dbBus dbBusAlloc(void);
#define _dbBusNextFree(Bus) (*(dbBus *)(void *)(Bus))
extern void dbBusFree(dbBus Bus);
#define dbBusGetDestructorHook() (dbBusDestructorHook)
#define dbBusSetDestructorHook(func) (dbBusDestructorHook = (func))
extern void dbBusDestroy(dbBus Bus);
#define dbBusGetLeft(Bus) ((Bus)->Left)
#define dbBusSetLeft(_Bus, value) ((_Bus)->Left = (value))
#define dbBusGetRight(Bus) ((Bus)->Right)
#define dbBusSetRight(_Bus, value) ((_Bus)->Right = (value))
#define dbBusGetiNet(Bus, x) ((Bus)->Nets[x])
#define dbBusSetiNet(Bus, x, _Net) ((Bus)->Nets[x] = (_Net))
#define dbBusGetnumNets(Bus) ((Bus)->numNets)
#define dbBusSetusedNets(Bus, numNets) ((Bus)->usedNets = (numNets))
#define dbBusGetusedNets(Bus) ((Bus)->usedNets)
#define dbBusGetNets(Bus) ((Bus)->Nets)
#define dbBusAllocNets(Bus, num) ((Bus)->usedNets = (num), \
(Bus)->numNets = (num), (Bus)->Nets = mtNewA(dbNet, (num)))
#define dbBusReallocNets(Bus, num) ((Bus)->numNets = (num), (Bus)->Nets = mtResizeArray((Bus)->Nets, (num)*sizeof(dbNet)))
#define dbBusFreeNets(Bus) (mtDelete((Bus)->Nets), (Bus)->Nets = NULL, \
    (Bus)->numNets = 0, (Bus)->usedNets = 0)
extern void dbBusInsertNet(dbBus Bus, dbNet _Net);
extern void dbBusRemoveNet(dbBus Bus, dbNet _Net);
#define dbForeachBusNet(Bus, _Net) { \
    U32 _xNet; \
    for(_xNet = 0; _xNet < dbBusGetusedNets(Bus); \
        _xNet++) { \
        _Net = dbBusGetiNet(Bus, _xNet);
#define dbEndForeachBusNet }}
#define dbSafeForeachBusNet(Bus, _Net) { \
    U32 _xNet; \
    for(_xNet = 0; _xNet < dbBusGetusedNets(Bus); \
        dbBusGetiNet(Bus, _xNet) == _Net &&_xNet++) { \
        _Net = dbBusGetiNet(Bus, _xNet); \
        if(_Net != dbNetNull) {
#define dbEndSafeForeachBusNet }}}
#define dbBusGetNetlist(_Bus) ((_Bus)->Netlist)
#define dbBusSetNetlist(_Bus, value) ((_Bus)->Netlist = (value))
#define dbBusGetSym(Bus) ((Bus)->h.Sym)
#define dbBusSetSym(Bus, _sym) ((Bus)->h.Sym = (_sym))
#define dbBusGetnextNetlistBus(Bus) ((dbBus)((Bus)->h.nEntry))

/*----------------------------------------------------------------------------
  Hier methods.
----------------------------------------------------------------------------*/
#define dbHierNull ((dbHier)(NULL))
extern dbHier dbHierAlloc(void);
#define _dbHierNextFree(Hier) (*(dbHier *)(void *)(Hier))
extern void dbHierFree(dbHier Hier);
#define dbHierGetDestructorHook() (dbHierDestructorHook)
#define dbHierSetDestructorHook(func) (dbHierDestructorHook = (func))
extern void dbHierDestroy(dbHier Hier);
extern void dbHierInsertHier(dbHier Hier, dbHier _Hier);
extern void dbHierRemoveHier(dbHier Hier, dbHier _Hier);
extern void dbHierAppendHier(dbHier Hier, dbHier _Hier);
#define dbHierFindHier(Hier, name) (dbHier)utqEntryHtblSym(&(Hier)->Hiers, name)
#define dbHierGetnumHiers(Hier) ((Hier)->Hiers.count)
#define dbHierGetHiers(Hier) (&(Hier)->Hiers)
#define dbHierGetfirstHier(Hier) ((dbHier)(utfHtblEntry(dbHierGetHiers(Hier))))
#define dbHierGetlastHier(Hier) ((dbHier)(utlHtblEntry(dbHierGetHiers(Hier))))
#define dbForeachHierHier(Hier, _Hier) for(_Hier = dbHierGetfirstHier(Hier); \
_Hier != dbHierNull; _Hier = dbHierGetnextHierHier(_Hier))
#define dbEndForeachHierHier
#define dbSafeForeachHierHier(Hier, _Hier) {\
    dbHier _nextHier;\
    for(_Hier = dbHierGetfirstHier(Hier); \
        _Hier != dbHierNull; _Hier = _nextHier) {\
        _nextHier = dbHierGetnextHierHier(_Hier);
#define dbEndSafeForeachHierHier }}
#define dbHierGetfirstInst(Hier) ((Hier)->firstInst)
#define dbHierSetfirstInst(Hier, _Inst) ((Hier)->firstInst = (_Inst))
extern void dbHierInsertInst(dbHier Hier, dbInst _Inst);
extern void dbHierRemoveInst(dbHier Hier, dbInst _Inst);
#define dbForeachHierInst(Hier, _Inst) \
    for(_Inst = dbHierGetfirstInst(Hier); _Inst != dbInstNull; \
        _Inst = dbInstGetnextHierInst(_Inst))
#define dbEndForeachHierInst
#define dbSafeForeachHierInst(Hier, _Inst) {\
    dbInst _nextInst;\
    for(_Inst = dbHierGetfirstInst(Hier); _Inst != dbInstNull; \
        _Inst = _nextInst) {\
        _nextInst = dbInstGetnextHierInst(_Inst);
#define dbEndSafeForeachHierInst }}
#define dbHierGetlastInst(Hier) ((Hier)->lastInst)
#define dbHierSetlastInst(Hier, _Inst) ((Hier)->lastInst = (_Inst))
extern void dbHierAppendInst(dbHier Hier, dbInst _Inst);
#define dbHierGetHier(_Hier) ((_Hier)->Hier)
#define dbHierSetHier(_Hier, value) ((_Hier)->Hier = (value))
#define dbHierGetSym(Hier) ((Hier)->h.Sym)
#define dbHierSetSym(Hier, _sym) ((Hier)->h.Sym = (_sym))
#define dbHierGetnextHierHier(Hier) ((dbHier)((Hier)->h.nEntry))

/*----------------------------------------------------------------------------
  Global methods.
----------------------------------------------------------------------------*/
#define dbGlobalNull ((dbGlobal)(NULL))
extern dbGlobal _dbGlobalAlloc(void);
#define _dbGlobalNextFree(Global) (*(dbGlobal *)(void *)(Global))
#define dbGlobalAlloc() (_dbFirstFreeGlobal == dbGlobalNull? _dbGlobalAlloc() : (\
    _dbTempGlobal = _dbFirstFreeGlobal,\
    _dbFirstFreeGlobal = _dbGlobalNextFree(_dbFirstFreeGlobal),\
    memset((void *)_dbTempGlobal, 0, sizeof(struct _dbGlobal)),\
    _dbTempGlobal))
#define dbGlobalFree(Global) (_dbGlobalNextFree(Global) = _dbFirstFreeGlobal, _dbFirstFreeGlobal = (Global))
#define dbGlobalGetDestructorHook() (dbGlobalDestructorHook)
#define dbGlobalSetDestructorHook(func) (dbGlobalDestructorHook = (func))
extern void dbGlobalDestroy(dbGlobal Global);
#define dbGlobalGetfirstNet(Global) ((Global)->firstNet)
#define dbGlobalSetfirstNet(Global, _Net) ((Global)->firstNet = (_Net))
extern void dbGlobalInsertNet(dbGlobal Global, dbNet _Net);
extern void dbGlobalRemoveNet(dbGlobal Global, dbNet _Net);
#define dbForeachGlobalNet(Global, _Net) \
    for(_Net = dbGlobalGetfirstNet(Global); _Net != dbNetNull; \
        _Net = dbNetGetnextGlobalNet(_Net))
#define dbEndForeachGlobalNet
#define dbSafeForeachGlobalNet(Global, _Net) {\
    dbNet _nextNet;\
    for(_Net = dbGlobalGetfirstNet(Global); _Net != dbNetNull; \
        _Net = _nextNet) {\
        _nextNet = dbNetGetnextGlobalNet(_Net);
#define dbEndSafeForeachGlobalNet }}
#define dbGlobalGetlastNet(Global) ((Global)->lastNet)
#define dbGlobalSetlastNet(Global, _Net) ((Global)->lastNet = (_Net))
extern void dbGlobalAppendNet(dbGlobal Global, dbNet _Net);
#define dbGlobalGetDesign(_Global) ((_Global)->Design)
#define dbGlobalSetDesign(_Global, value) ((_Global)->Design = (value))
#define dbGlobalGetSym(Global) ((Global)->h.Sym)
#define dbGlobalSetSym(Global, _sym) ((Global)->h.Sym = (_sym))
#define dbGlobalGetnextDesignGlobal(Global) ((dbGlobal)((Global)->h.nEntry))

/*----------------------------------------------------------------------------
  Attr methods.
----------------------------------------------------------------------------*/
#define dbAttrNull ((dbAttr)(NULL))
extern dbAttr _dbAttrAlloc(void);
#define _dbAttrNextFree(Attr) (*(dbAttr *)(void *)(Attr))
#define dbAttrAlloc() (_dbFirstFreeAttr == dbAttrNull? _dbAttrAlloc() : (\
    _dbTempAttr = _dbFirstFreeAttr,\
    _dbFirstFreeAttr = _dbAttrNextFree(_dbFirstFreeAttr),\
    memset((void *)_dbTempAttr, 0, sizeof(struct _dbAttr)),\
    _dbTempAttr))
#define dbAttrFree(Attr) (_dbAttrNextFree(Attr) = _dbFirstFreeAttr, _dbFirstFreeAttr = (Attr))
#define dbAttrGetDestructorHook() (dbAttrDestructorHook)
#define dbAttrSetDestructorHook(func) (dbAttrDestructorHook = (func))
extern void dbAttrDestroy(dbAttr Attr);
#define dbAttrGetValue(Attr) ((Attr)->Value)
#define dbAttrSetValue(_Attr, value) ((_Attr)->Value = (value))
#define dbAttrGetName(Attr) ((Attr)->Name)
#define dbAttrSetName(_Attr, value) ((_Attr)->Name = (value))
#define dbAttrGetNextAttr(_Attr) ((_Attr)->NextAttr)
#define dbAttrSetNextAttr(_Attr, value) ((_Attr)->NextAttr = (value))

/*----------------------------------------------------------------------------
  Root methods.
----------------------------------------------------------------------------*/
#define dbRootNull ((dbRoot)(NULL))
extern dbRoot dbRootAlloc(void);
#define _dbRootNextFree(Root) (*(dbRoot *)(void *)(Root))
extern void dbRootFree(dbRoot Root);
#define dbRootGetDestructorHook() (dbRootDestructorHook)
#define dbRootSetDestructorHook(func) (dbRootDestructorHook = (func))
extern void dbRootDestroy(dbRoot Root);
extern void dbRootInsertDesign(dbRoot Root, dbDesign _Design);
extern void dbRootRemoveDesign(dbRoot Root, dbDesign _Design);
extern void dbRootAppendDesign(dbRoot Root, dbDesign _Design);
#define dbRootFindDesign(Root, name) (dbDesign)utqEntryHtblSym(&(Root)->Designs, name)
#define dbRootGetnumDesigns(Root) ((Root)->Designs.count)
#define dbRootGetDesigns(Root) (&(Root)->Designs)
#define dbRootGetfirstDesign(Root) ((dbDesign)(utfHtblEntry(dbRootGetDesigns(Root))))
#define dbRootGetlastDesign(Root) ((dbDesign)(utlHtblEntry(dbRootGetDesigns(Root))))
#define dbForeachRootDesign(Root, _Design) for(_Design = dbRootGetfirstDesign(Root); \
_Design != dbDesignNull; _Design = dbDesignGetnextRootDesign(_Design))
#define dbEndForeachRootDesign
#define dbSafeForeachRootDesign(Root, _Design) {\
    dbDesign _nextDesign;\
    for(_Design = dbRootGetfirstDesign(Root); \
        _Design != dbDesignNull; _Design = _nextDesign) {\
        _nextDesign = dbDesignGetnextRootDesign(_Design);
#define dbEndSafeForeachRootDesign }}
extern void dbRootInsertDevspec(dbRoot Root, dbDevspec _Devspec);
extern void dbRootRemoveDevspec(dbRoot Root, dbDevspec _Devspec);
extern void dbRootAppendDevspec(dbRoot Root, dbDevspec _Devspec);
#define dbRootFindDevspec(Root, name) (dbDevspec)utqEntryHtblSym(&(Root)->Devspecs, name)
#define dbRootGetnumDevspecs(Root) ((Root)->Devspecs.count)
#define dbRootGetDevspecs(Root) (&(Root)->Devspecs)
#define dbRootGetfirstDevspec(Root) ((dbDevspec)(utfHtblEntry(dbRootGetDevspecs(Root))))
#define dbRootGetlastDevspec(Root) ((dbDevspec)(utlHtblEntry(dbRootGetDevspecs(Root))))
#define dbForeachRootDevspec(Root, _Devspec) for(_Devspec = dbRootGetfirstDevspec(Root); \
_Devspec != dbDevspecNull; _Devspec = dbDevspecGetnextRootDevspec(_Devspec))
#define dbEndForeachRootDevspec
#define dbSafeForeachRootDevspec(Root, _Devspec) {\
    dbDevspec _nextDevspec;\
    for(_Devspec = dbRootGetfirstDevspec(Root); \
        _Devspec != dbDevspecNull; _Devspec = _nextDevspec) {\
        _nextDevspec = dbDevspecGetnextRootDevspec(_Devspec);
#define dbEndSafeForeachRootDevspec }}

/*----------------------------------------------------------------------------
  Devspec methods.
----------------------------------------------------------------------------*/
#define dbDevspecNull ((dbDevspec)(NULL))
extern dbDevspec dbDevspecAlloc(void);
#define _dbDevspecNextFree(Devspec) (*(dbDevspec *)(void *)(Devspec))
extern void dbDevspecFree(dbDevspec Devspec);
#define dbDevspecGetDestructorHook() (dbDevspecDestructorHook)
#define dbDevspecSetDestructorHook(func) (dbDevspecDestructorHook = (func))
extern void dbDevspecDestroy(dbDevspec Devspec);
#define dbDevspecGetType(Devspec) ((Devspec)->Type)
#define dbDevspecSetType(_Devspec, value) ((_Devspec)->Type = (value))
#define dbDevspecGetiString(Devspec, x) ((Devspec)->Strings[x])
#define dbDevspecSetiString(Devspec, x, String) ((Devspec)->Strings[x] = (String))
#define dbDevspecGetnumStrings(Devspec) ((Devspec)->numStrings)
#define dbDevspecAllocStrings(Devspec, num) ((Devspec)->numStrings = (num), (Devspec)->Strings = mtNewA(char, (num)))
#define dbDevspecReallocStrings(Devspec, num) ((Devspec)->numStrings = (num), (Devspec)->Strings = mtResizeArray((Devspec)->Strings, (num)*sizeof(char)))
#define dbDevspecFreeStrings(Devspec) (mtDelete((Devspec)->Strings), (Devspec)->Strings = NULL,\
    (Devspec)->numStrings = 0)
#define dbDevspecGetStrings(Devspec) ((Devspec)->Strings)
#define dbDevspecGetString(Devspec) ((Devspec)->Strings)
#define dbDevspecGetRoot(_Devspec) ((_Devspec)->Root)
#define dbDevspecSetRoot(_Devspec, value) ((_Devspec)->Root = (value))
#define dbDevspecGetSym(Devspec) ((Devspec)->h.Sym)
#define dbDevspecSetSym(Devspec, _sym) ((Devspec)->h.Sym = (_sym))
#define dbDevspecGetnextRootDevspec(Devspec) ((dbDevspec)((Devspec)->h.nEntry))

/*----------------------------------------------------------------------------
  Package level routines.
----------------------------------------------------------------------------*/
extern void dbDDRStart(void);
extern void dbDDRStop(void);

/*----------------------------------------------------------------------------
  Structure definitions.
----------------------------------------------------------------------------*/
struct _dbDesign {
    struct _utEntry h;
    dbGlobal ZeroGlobal;
    dbGlobal OneGlobal;
    struct _utHtbl Netlists;
    dbNetlist RootNetlist;
    struct _utHtbl Globals;
    dbAttr Attr;
    dbRoot Root;
};

struct _dbNetlist {
    struct _utEntry h;
    utExtension _firstExtension;
    utSym Device;
    dbNetlistType Type;
    struct _utHtbl Nets;
    struct _utHtbl Mports;
    struct _utHtbl Insts;
    struct _utHtbl Mbuss;
    struct _utHtbl Buss;
    dbHier Hier;
    dbInst firstExternalInst;
    dbInst lastExternalInst;
    dbAttr Attr;
    dbDesign Design;
    bool Visited:2;
};

struct _dbNet {
    struct _utEntry h;
    dbPort firstPort;
    dbPort lastPort;
    dbAttr Attr;
    dbNetlist Netlist;
    dbBus Bus;
    U32 BusIndex;
    dbGlobal Global;
    dbNet nextGlobalNet;
    dbNet prevGlobalNet;
    bool Visited:2;
};

struct _dbInst {
    struct _utEntry h;
    dbPort firstPort;
    dbPort lastPort;
    dbAttr Attr;
    dbNetlist Netlist;
    dbHier Hier;
    dbInst nextHierInst;
    dbInst prevHierInst;
    dbNetlist InternalNetlist;
    dbInst nextNetlistExternalInst;
    dbInst prevNetlistExternalInst;
    dbMbus ExternalMbus;
    bool Array:2;
};

struct _dbMport {
    struct _utEntry h;
    dbMportType Type;
    dbPort FlagPort;
    dbAttr Attr;
    dbNetlist Netlist;
    dbMbus Mbus;
    U32 MbusIndex;
    bool Visited:2;
};

struct _dbPort {
    dbNet Net;
    dbPort nextNetPort;
    dbPort prevNetPort;
    dbInst Inst;
    dbPort nextInstPort;
    dbPort prevInstPort;
    dbMport Mport;
};

struct _dbMbus {
    struct _utEntry h;
    dbMportType Type;
    U32 Right;
    U32 Left;
    dbMport *Mports;
    U32 numMports, usedMports;
    dbInst FlagInst;
    dbNetlist Netlist;
};

struct _dbBus {
    struct _utEntry h;
    U32 Left;
    U32 Right;
    dbNet *Nets;
    U32 numNets, usedNets;
    dbNetlist Netlist;
};

struct _dbHier {
    struct _utEntry h;
    struct _utHtbl Hiers;
    dbInst firstInst;
    dbInst lastInst;
    dbHier Hier;
};

struct _dbGlobal {
    struct _utEntry h;
    dbNet firstNet;
    dbNet lastNet;
    dbDesign Design;
};

struct _dbAttr {
    utSym Value;
    utSym Name;
    dbAttr NextAttr;
};

struct _dbRoot {
    struct _utHtbl Designs;
    struct _utHtbl Devspecs;
};

struct _dbDevspec {
    struct _utEntry h;
    dbSpiceTargetType Type;
    char *Strings;
    U32 numStrings;
    dbRoot Root;
};

extern void (*dbDesignDestructorHook)(dbDesign);
extern dbDesign _dbFirstFreeDesign, _dbTempDesign;
extern void (*dbNetlistDestructorHook)(dbNetlist);
extern dbNetlist _dbFirstFreeNetlist, _dbTempNetlist;
extern void (*dbNetDestructorHook)(dbNet);
extern dbNet _dbFirstFreeNet, _dbTempNet;
extern void (*dbInstDestructorHook)(dbInst);
extern dbInst _dbFirstFreeInst, _dbTempInst;
extern void (*dbMportDestructorHook)(dbMport);
extern dbMport _dbFirstFreeMport, _dbTempMport;
extern void (*dbPortDestructorHook)(dbPort);
extern dbPort _dbFirstFreePort, _dbTempPort;
extern void (*dbMbusDestructorHook)(dbMbus);
extern dbMbus _dbFirstFreeMbus, _dbTempMbus;
extern void (*dbBusDestructorHook)(dbBus);
extern dbBus _dbFirstFreeBus, _dbTempBus;
extern void (*dbHierDestructorHook)(dbHier);
extern dbHier _dbFirstFreeHier, _dbTempHier;
extern void (*dbGlobalDestructorHook)(dbGlobal);
extern dbGlobal _dbFirstFreeGlobal, _dbTempGlobal;
extern void (*dbAttrDestructorHook)(dbAttr);
extern dbAttr _dbFirstFreeAttr, _dbTempAttr;
extern void (*dbRootDestructorHook)(dbRoot);
extern dbRoot _dbFirstFreeRoot, _dbTempRoot;
extern void (*dbDevspecDestructorHook)(dbDevspec);
extern dbDevspec _dbFirstFreeDevspec, _dbTempDevspec;

#endif
