#!/bin/sh

testname=`basename "$0"`
test_description="Proper relative to DirPrefix ifcreate paths"
. $SHARNESS_TEST_SRCDIR/sharness.sh
export REDO_TOP_DIR="`pwd`" REDO_NO_PROGRESS=1

mkdir -p a/b/c a/c
echo whatever >a/b/c/dep
cat >a/b/default.do <<EOF
echo called \$1
redo-ifcreate ../c/dep
redo-ifchange c/dep
EOF
redo-ifchange a/b/c/file
stat1=`stat a/b/c/file`
sleep 1 # stat does not output fractions of seconds
redo-ifchange a/b/c/file
stat2=`stat a/b/c/file`

test_expect_success "file stays same" '[ "$stat1" = "$stat2" ]'

touch a/c/dep
redo-ifchange a/b/c/file
stat3=`stat a/b/c/file`

test_expect_success "ifcreate target works" '[ "$stat1" != "$stat3" ]'

test_done
