/* ----------------------------------------------------------------------
 * slen -- prints out sequence length
 * Copyright (C) 2000 January Weiner III
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,
 * USA.
 ---------------------------------------------------------------------- */

#include <stdio.h>
#include <ctype.h>
#include <stdlib.h>
#include <time.h>
#include <string.h>
#include <math.h>

#include "genpak.h"
#include "gp_getopt.h"

#define VERSION "1.2"
#define PROGNAME "gp_slen"

/*
 *
 */

int main(int argc, char *argv[])
{
	extern int optind ;

	FILE *in, *out ;
	sekw *inseq ;
	double mean = 0.0, square = 0.0 ;
	long dlug = 0;
	int c, nseq = 0, onlymean = FALSE;
	int errflg = 0 ;

	allwarnings = NULL ;

	progname = argv[0] ;

	while ((c = gp_getopt(argc, argv, "mvHhqd")) != EOF)
		switch(c) {
		case 'm':
			onlymean = TRUE ;
			break ;
		case 'H':
			html = TRUE ;
			break ;
		case 'q':
			quiet = TRUE ;
			break ;
		case 'v':
			fprintf(stderr,"%s version %s\n",progname,VERSION) ;
			exit(0) ;
			break ;
		case 'd':
			debug = TRUE ;
			gp_warn("Running in debug mode") ;
			break ;
		case 'h':
			Help() ;
			break ;
		default:
			errflg++ ;
			break;
		}


	if(errflg) gp_error("Type '%s -h' for help",progname) ;

/* open the file pointer to read the sequences 
 * from: standard input or a file provided? */
	if(optind >= argc) in = stdin ;
	else in = gp_file_open(argv[optind],"r") ;


/* opening the file pointer to write the output: 
 * standard output or file provided? */
	optind++ ;

	if(optind >= argc) out = stdout ;
	else out = gp_file_open(argv[optind],"wb") ;

	while((inseq = gp_seq_read_fragment(in,0,0,0)) != NULL) {
		dlug = strlen(inseq->sequ) ;
		if(onlymean == FALSE) fprintf(out,"%i\n",dlug) ;
		nseq++ ;
		mean += dlug ;
		square += dlug*dlug ;
		free(inseq) ;
	}

	if(onlymean) {
		if(nseq<2) gp_error("Not enough data to computate mean and SE") ;
		square = pow(((square - (mean*mean)/nseq)/(nseq-1)),0.5) ;
		mean /= (double) nseq ;
		fprintf(out,"mean = %.2f %%, SE= %.2f E\n",mean,square) ;
	}

	if(html) gp_warn_print_all(out) ;
	
	fclose(out) ;
	fclose(in) ;
	return(EXIT_SUCCESS);
}

/* Standard mesage */

void Help()
{
printf("\n");
printf("%s version %s - print out sequence length(s) :^)",PROGNAME,VERSION);
printf("\n");
printf("  Usage:\n");
printf("     %s [options] [ input file ] [ output file ]\n",progname);
printf("\n");
printf("  Options:\n");
printf("     -m       : print mean length and SE\n");
printf("     -v       : print version information & exit\n");
printf("     -H       : run in HTML mode\n");
printf("     -d       : print lots of debugging info\n");
printf("     -h       : print this help screen & exit\n");
printf("     -q       : quiet, suppress error messages\n\n");
exit(EXIT_SUCCESS);
}


			
