//Copyright (C) 2000 - 2003 Thomas Schank 
// 
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either version 2
//of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. 



#include "endianmess.h"

namespace gpspoint2 {
using namespace std;
using namespace gpspoint2;


float Endianmess::htolf(float f)
{
   #if WORDS_BIGENDIAN
      float r;
      ((g_byte*)&r)[0] = ((g_byte*)&f)[3];
      ((g_byte*)&r)[1] = ((g_byte*)&f)[2];
      ((g_byte*)&r)[2] = ((g_byte*)&f)[1];
      ((g_byte*)&r)[3] = ((g_byte*)&f)[0];
      return r;
   #else
      return f;
   #endif 
}
float Endianmess::ltohf(float f){ return htolf(f);}
float Endianmess::h2lf(float f){ return htolf(f);}
float Endianmess::l2hf(float f){ return htolf(f);}


g_int Endianmess::htol16(g_int gi)
{
   #if WORDS_BIGENDIAN
      g_int r;
      ((g_byte*)&r)[0] = ((g_byte*)&gi)[1];
      ((g_byte*)&r)[1] = ((g_byte*)&gi)[0];
      return r;
   #else
      return gi;
   #endif 
}
g_int Endianmess::ltoh16(g_int gi) { return htol16(gi); }
g_int Endianmess::l2h16(g_int gi) { return htol16(gi); }
g_int Endianmess::h2l16(g_int gi) { return htol16(gi); }


g_long Endianmess::htol32( g_long gl)
{
   #if WORDS_BIGENDIAN
      g_long r;
      ((g_byte*)&r)[0] = ((g_byte*)&gl)[3];
      ((g_byte*)&r)[1] = ((g_byte*)&gl)[2];
      ((g_byte*)&r)[2] = ((g_byte*)&gl)[1];
      ((g_byte*)&r)[3] = ((g_byte*)&gl)[0];
      return r;
   #else
      return gl;
   #endif
}
g_long Endianmess::ltoh32( g_long gl) { return   htol32(gl); }
g_long Endianmess::l2h32( g_long gl) { return   htol32(gl); }
g_long Endianmess::h2l32( g_long gl) { return   htol32(gl); }


}

#if 0

// ************************************** byteswap 
g_long byteswap32(g_long gl)
{
   g_long r;

   ((g_byte*)&r)[0] =  ((g_byte*)&gl)[3];
   ((g_byte*)&r)[1] =  ((g_byte*)&gl)[2];
   ((g_byte*)&r)[2] =  ((g_byte*)&gl)[1];
   ((g_byte*)&r)[3] =  ((g_byte*)&gl)[0];

   return r;
}

g_int byteswap16(g_int gw)
{
   g_int r;

   ((g_byte*)&r)[0] =  ((g_byte*)&gw)[1];
   ((g_byte*)&r)[1] =  ((g_byte*)&gw)[0];

   return r;
}


// ****** 16 bit host to little endian **************************
g_int htol16( g_int gi)
{
   g_char c[2] = { 0x11, 0x22} ;

   g_int i = *(g_int*) c;


   switch(i)
   {
      case 0x2211:
//         cout << "16 bit little endian\n";
         break;
      case 0x1122:
//        cout << "16 bit BIG endian ; swaping bytes \n" ;
         gi=byteswap16(gi);
          break;
      default:
//         cout << "16 bit weird endian \n" ;
         break;
   }
   return gi;
}

// **** 32 bit host to little endian ***************************

g_long htol32( g_long gl)
{
   g_char c[4] = { 0x11, 0x22, 0x33, 0x44} ;

   g_long l = *(g_long*) c;

   switch(l)
   {
      case 0x44332211:
//         cout << "32 bit little endian\n";
         break;
      case 0x11223344:
//         cout << "32 bit BIG endian ; swaping bytes \n" ;
         gl=byteswap32(gl);
          break;
      default:
//         cout << "32 bit weird endian \n" ;
         break;
   }
   return gl;
}

#endif 

