//Copyright (C) 2000 - 2003 Thomas Schank 
// 
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either version 2
//of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. 

#include "gpdlinetool.h"
#include <sstream>
#include <iomanip>
#include <math.h>

namespace gpspoint2 {
using namespace std;
using namespace gpspoint2;

void GPDLineTool::operator<< (string s)
{
   sline = s;
};

void GPDLineTool::setLine(string s)
{
   sline=s;
};

void GPDLineTool::readLine(istream &is)
{
      const int LINEBUFFERSIZE=1000;
      char linebuffer[LINEBUFFERSIZE];
      is.getline(linebuffer,LINEBUFFERSIZE);
      sline = string(linebuffer);
      sline += "\n";
};


/// returns the whole line 
string GPDLineTool::line(void)
{
   return sline;
}

string GPDLineTool::getLine(void)
{
   return line();
};

   /// This method looks for key and returns its value.  
   /// It also replaces \"  by "  inside the input value.
   /// Note that the function always returns the value  as 
   /// a string. bla bla ....
string GPDLineTool::readValue(string k) 
{

   string s("");
   
   string search(k+'='+'"');
   size_t pa=string::npos,
          pe=string::npos;

   pa=sline.find(search);
   if(pa!=string::npos) 
   {
      pa=pa+search.length();
      if(pa!=string::npos)
      {
         // find the ending " 
         for(pe=pa;sline[pe]!='"'&& pe<sline.length();pe++)
         {
            if(sline[pe]=='\\') pe++;
         }
   
         if(sline[pe]!='"') pe=string::npos;
   
         if(pe!=string::npos)
         {
            s=sline.substr(pa,pe-pa);
            //stubstitude "/a" with "a"
            for(size_t i=0; i<s.length();i++)
            {
               if(s[i]=='\\')
               {
   //               cout << "erase i: " << s[i] << endl;
                  string a = s.substr(0,i);// 
                  string b = s.substr(i+1,s.length());
                  s = a+b;
                  //i++;
               }
            }
         }
      }

   }
//   cerr << "Value : " << s << endl;
   return s;
}



// *************************************************
//    string to double
// *************************************************

double GPDLineTool::s2d(string s)
{

   double d=1.0e25;
   if(s=="") return d;

   istringstream iss(s); // put string in istrstream
   iss >> d;

   return d;
}

// *************************************************
//    string to float
// *************************************************

float GPDLineTool::s2f(string s)
{

   float f=1.0e25;
   if(s=="") return f;

   istringstream iss(s); // put string in istrstream
   iss >> f;

   return f;
}


// ********************************************
// double to string
// ********************************************


string GPDLineTool::d2s(double f,int d)
{
   f = f * pow(double(10),d);
   f+=.5-1e-20;
   f=float(floor(f));
   f = f/pow(double(10),d);

   ostringstream oss (ostringstream::out);
   oss << setprecision(9);
   oss << f;

// FIXME: strange bug here: oss.str cause the JVM to blow!
   string s = oss.str();

#if 0
  oss << "This is a test\n";
  cout << oss.str();



   char cstr[100];
   for (int i=0; i<100;i++) cstr[i]=0;
//   ostrstream os(cstr,100,ios::out);
   ostringstream os(cstr,100,ios::out);

   f = f*pow(10,d);
   f+=.5-1e-20;
   f=float(floor(f));
   f = f/pow(10,d);

   os << setprecision(9);

   os << f;

   string s = string(cstr);
#endif 

   return s;
}

string GPDLineTool::d2s(double d)
{
#if 0
   char cstr[100];
   for (int i=0; i<100;i++) cstr[i]=0;
   ostrstream os(cstr,100,ios::out);
   ostringstream os(cstr,100,ios::out);
#endif 


#if 0
   os << setw(10);

   os << d;

   string s = string(cstr);

#endif 
   ostringstream oss (ostringstream::out);
   if( sqrt(d*d)  >= 100)
      oss << setprecision(9);
   else if( sqrt(d*d)  >= 10)
      oss << setprecision(8);
   else oss << setprecision(7);

   d = double(int(d*1e5+.49999999999999))*1e-5 ;
   oss << setw(10);
   oss << d;

   string s = oss.str();

#if 0
  os << setprecision(10);

   os <<  double(int(d*1e5+.49999999999999))*1e-5 ;

   string s = string(cstr);

   size_t ppos;
   ppos = s.find(".");

//   cout << ppos - s.length();

   for(int i = s.length() - ppos; i<=5; i++)
      s+="0";
#endif 
   return s;
}

// ********************************************
// long to string
// ********************************************
string GPDLineTool::l2s(long l)
{
#if 0
   char cstr[100];
   for (int i=0; i<100;i++) cstr[i]=0;
   ostrstream os(cstr,100,ios::out);

   os <<  l;

   string s = string(cstr);

#endif 
   ostringstream oss (ostringstream::out);
   oss << setprecision(9);
   oss << l;
   string s = oss.str();
   return s;
}


string GPDLineTool::toGPD(long l)
{
   return l2s(l);
}

// *******************************************
// float to string
// *******************************************
string GPDLineTool::f2s(float f)
{
   return d2s(double(f));
}

// *******************************************
// float to string with rounding 
// *******************************************
string GPDLineTool::f2s(float f,int d)
{
#if 0
  char cstr[100];
   for (int i=0; i<100;i++) cstr[i]=0;
   ostrstream os(cstr,100,ios::out);
#endif 

   f = f*pow(float(10),d);
   f+=.5-1e-20;
   f=float(floor(f));
   f = f/pow(float(10),d);

   ostringstream oss (ostringstream::out);
   oss << f;
   string s = oss.str();
   return s;
}



// *******************************************
string GPDLineTool::toGPD(string s)
{
   string r;
   for(unsigned int i=0; i<s.length(); i++) {
      if(s[i]=='\"') r+="\\";
      r+=s[i];  }
   return r;
}


// ********************************************
string GPDLineTool::toGPD(int in)
{
#if 0
   char cstr[100];
   for (int i=0; i<100;i++) cstr[i]=0;
   ostrstream os(cstr,100,ios::out);
   os  <<  in;
  string s = string(cstr);
#endif 
   ostringstream oss (ostringstream::out);
   oss << in;
   string s = oss.str();
   return s;
}


// ********************************************
string GPDLineTool::toString(int in)
{
#if 0
   char cstr[100];
   for (int i=0; i<100;i++) cstr[i]=0;
   ostrstream os(cstr,100,ios::out);

   os  <<  in;

  string s = string(cstr);
  return s;

#endif 

   ostringstream oss (ostringstream::out);
   oss << in;
   string s = oss.str();
   return s;
}


// *************************************************
//    string to int 
// *************************************************

int GPDLineTool::s2i(string s)
{

   int i = -1; 
   if(s=="") return i;

   istringstream iss(s); // put string in istrstream
   iss >> i;

   return i;
}


// *************************************************
//    string to long
// *************************************************

long GPDLineTool::s2l(string s)
{

   long i = -1; 
   if(s=="") return i;


#if 0
   istrstream iss(s.c_str(),s.length()); // put string in istrstream
   iss >> i;
#endif 
   istringstream iss(s); // put string in istrstream
   iss >> i;


   return i;
}
}
