//Copyright (C) 2000 - 2003 Thomas Schank 
// 
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either version 2
//of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. 

#include "wpt_type.h"
#include "oldsymbols.h"



// ******************************************************************


namespace gpspoint2 {
using namespace std;
using namespace gpspoint2;

OldSymbols::OldSymbols(void)
{

   oldSymbolData _symbols[ANZ_OLDSYMBOLS] =
   {
   {"dot",  0}, /* dot symbol */
   {"house",  1}, /* house symbol */
   {"gas",  2}, /* gas symbol */
   {"car",  3}, /* car symbol */
   {"fish",  4}, /* fish symbol */
   {"boat",  5}, /* boat symbol */
   {"anchor",  6}, /* anchor symbol */
   {"wreck",  7}, /* wreck symbol */
   {"exit",  8}, /* exit symbol */
   {"skull",  9}, /* skull symbol */
   {"flag", 10}, /* flag symbol */
   {"camp", 11}, /* camp symbol */
   {"circle_x", 12}, /* circle with x symbol */
   {"deer", 13}, /* deer symbol */
   {"1st_aid", 14}, /* first aid symbol */
   {"back_track", 15} /* back track symbol */
   };

   for(int i=0;i<ANZ_OLDSYMBOLS;i++)
   symbols[i] = _symbols[i];

}

string OldSymbols::number2symbol(g_byte n) const 
{
	for(int i=0;i<ANZ_OLDSYMBOLS;i++)
		if (symbols[i].n ==  n) return symbols[i].symbol;
	return symbols[0].symbol;

}

g_byte OldSymbols::symbol2number(string s) const 
{
	for(int i=0;i<ANZ_OLDSYMBOLS;i++)
		if(string(symbols[i].symbol) == s) return symbols[i].n;
	return symbols[0].n;
}

}
