//Copyright (C) 2000 - 2003 Thomas Schank 
// 
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either version 2
//of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. 

#include "rte_hdr_type.h"

namespace gpspoint2 {
using namespace std;
using namespace gpspoint2;

string Rte_Hdr_Type::os(void)
{
   string s;
   s = "type=\"route\" " ;
   if(name!="") s=s+ "routename=\""+ toGPD(name) + "\"   ";
	if(number!=-1) s=s+ "routenumber=\"" + toGPD(number) +"\"  ";
   s += "\n";
   return s;
}

void Rte_Hdr_Type::os(ostream os)
{
   os << this->os();
}

Rte_Hdr_Type::Rte_Hdr_Type(const string &n, int i) : name(n), number(i) {
}

Rte_Hdr_Type::Rte_Hdr_Type(void)
{
   clear();
}

void Rte_Hdr_Type::clear(void)
{
   name="";
};

void Rte_Hdr_Type::set(Packet p)
{
   cerr << " wpt_type not supportet ; you should not have gotten here " << endl;
}

Packet Rte_Hdr_Type::makePacket(void)
{
   cerr << " wpt_type not supportet ; you should not have gotten here " << endl;
   Packet p;
   return p;
}


void Rte_Hdr_Type::set(string s)
{
   clear();
   setLine(s);
   name = readValue("routename");
	if(readValue("routenumber")!="")
		number = s2i(readValue("routenumber"));
	else number = 0;
}

void Rte_Hdr_Type::operator<<(string s)
{
   clear();
   set(s);
}

}
