//Copyright (C) 2000 - 2003 Thomas Schank 
// 
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either version 2
//of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. 

#include "tracklist.h"

namespace gpspoint2 {
using namespace std;
using namespace gpspoint2;

string Tracklist::os(void)
{
   string s="";
   for(unsigned int i=0;i<tracks.size();i++) 
   {
      s += tracks[i].header();
      for(int j=0; j<tracks[i].size(); j++)
         s+= trackpoint(i,j); 
      s += "type=\"trackend\"\n";
   }
   return s;
}


Tracklist::Tracklist(void) { current_track = -1; }


void Tracklist::is(string is)
{
   size_t a=0,b=0;
   string s;
   do
   {
      b=is.find("\n",a+1);
      if(b==string::npos)
         s=is.substr(a,is.size()-a);
      else s=is.substr(a,b-a), a=b;

      setLine(s);

      if(readValue("type")==string("track")) {
         current_track++;
         Track t;
         tracks.push_back(t); 
         tracks[current_track] << line();} 

      if(readValue("type")==string("trackpoint")) {
         if(current_track==-1){ // case there is no track jet
            current_track++;
            Track t;
            tracks.push_back(t); }
         tracks[current_track] << line(); }

   }while(b!=string::npos);
}


void Tracklist::operator<<(string istr) { is(istr); }

int Tracklist::size() { return int(tracks.size()); }
int Tracklist::sizeTracks() { return int(tracks.size()); }

int Tracklist::size(int i) { return tracks[i].size(); }
int Tracklist::sizeTrackpoints(int i) { return tracks[i].size(); }

string Tracklist::header(int i)
{
   if(i<=int(tracks.size()))
      return tracks[i].header();
   else return string("\n");
}

string Tracklist::trackpoint(int i, int j)
{
   if(i<=int(tracks.size()))
      if(j<=tracks[i].size())
         return tracks[i][j];
   return string("\n");
}

}
