/* Copy Only `Filter'

 * Copyright (C) 1998 J.A. Bezemer
 *
 * Licensed under the terms of the GNU General Public License.
 * ABSOLUTELY NO WARRANTY.
 * See the file `COPYING' in this directory.
 */

#include "signpr_copy.h"
#include "signpr_general.h"
#include "errorwindow.h"


void
copyonly_param_defaults (parampointer_t parampointer)
{
}

#ifndef SWIG
void
copyonly_param_screen (parampointer_t parampointer)
{
  error_window ("This `filter' does not have adjustable parameters. It \
just copies the signal unchanged.");
}
#endif

void
init_copyonly_filter (int filterno, parampointer_t parampointer)
{
  parampointer->buffer = init_buffer (0, 0);

  parampointer->filterno = filterno;
}

void
delete_copyonly_filter (parampointer_t parampointer)
{
  delete_buffer (&parampointer->buffer);
}


sample_t
#ifndef SWIG
copyonly_filter (parampointer_t parampointer)
#else
copyonly_filter (parampointer_t parampointer, int *filter_type)
#endif
{
#ifndef SWIG
  advance_current_pos (&parampointer->buffer, parampointer->filterno);
#else
  advance_current_pos (&parampointer->buffer, parampointer->filterno, filter_type);   
#endif

  return get_from_buffer (&parampointer->buffer, 0);
}
