/**
 * dotImporter.h
 *
 * a class to import an XML description into a nodes class.
 */

#ifndef __DOTIMPORTER_H__
#define __DOTIMPORTER_H__
#include "nodes.h"
#include <stdio.h>

class dotImporter {

 public:

  dotImporter(char *what_file, nodes *what_nodes);   // constructor
  ~dotImporter();                                    // destructor

  int import();  // effects the import; returns 1 on success, 0 on failure


 private:
  char *filename;
  nodes *my_nodes;

  // reads a line from infile and puts it in line.  returns 0 if successful,
  // 1 if the end of the file has been reached.
  char *read_line(FILE *infile); 
  // gets the first word or the contents of a set of quotes
  // sets end to be the null at the end of the 'name'
  char *get_name(char *start, char *&end);
  // creates two connected nodes (if necessary -- simply links them if they
  // already exist)
  void create_nodes(char *fromName, char *toName);
};


#endif




