/**
 * psExporter.h
 *
 * a class to export a nodes class into a postscript file
 */

#ifndef __PSEXPORTER_H__
#define __PSEXPORTER_H__
#include "nodes.h"
#include <stdio.h>

class psExporter {

 public:

  psExporter(char *what_file, nodes *what_nodes);   // constructor
  ~psExporter();                                    // destructor

  void do_export();  // effects the export


 private:
  char *filename;
  nodes *my_nodes;

  void write_headers(FILE *outfile);
  void find_bounds();
  void write_nodes(FILE *outfile);
  void write_node(node *this_node, FILE *outfile);
  void write_edges(FILE *outfile);
  void write_edge(node *from_node, node *to_node, FILE *outfile);
   
  int smallest_x, smallest_y, biggest_x, biggest_y;
  int margin;
  double scale_factor;

  // utility
  int translatexcoord(double x);
  int translateycoord(double y);
};


#endif
