#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>

#include "callbacks.h"
#include "interface.h"
#include "support.h"
#include "actions.h"
#include "classes/objectInterface.h"

extern GtkWidget *openfile_dialog;
extern GtkWidget *saveasfile_dialog;
extern GtkWidget *importfile_dialog;
extern GtkWidget *exportvisiofile_dialog;
extern GtkWidget *exportpsfile_dialog;
extern GtkWidget *exportgiffile_dialog;
extern objectInterface *my_objectInterface;
extern int go_stop_button_state;
extern GtkWidget *notice_popup_window;

int node_selected = 0;   /* 0 is no, 1 is yes */

void on_new1_activate(GtkMenuItem *menuitem, gpointer user_data) {
   do_new();
}


void on_open1_activate(GtkMenuItem *menuitem, gpointer user_data) {
   do_open();
}


void on_save1_activate(GtkMenuItem *menuitem, gpointer user_data) {
   do_save();
}


void on_save_as1_activate(GtkMenuItem *menuitem, gpointer user_data) {
   do_save_as();
}


void on_import1_activate(GtkMenuItem *menuitem, gpointer user_data) {
   do_import();
}


void on_export_as_visio1_activate(GtkMenuItem *menuitem, gpointer user_data) {
   do_export_visio();
}


void on_export_as_postscript1_activate(GtkMenuItem *menuitem, gpointer user_data) {
   do_export_ps();
}


void on_export_as_gif1_activate(GtkMenuItem *menuitem, gpointer user_data) {
   do_export_gif();
}


void on_quit1_activate(GtkMenuItem *menuitem, gpointer user_data) {
   do_quit();
}


void on_new_button_clicked(GtkButton *button, gpointer user_data) {
   do_new();
}


void on_open_button_clicked(GtkButton *button, gpointer user_data) {
   do_open();
}


void on_save_button_clicked(GtkButton *button, gpointer user_data) {
   do_save();
}


void on_saveas_button_clicked(GtkButton *button, gpointer user_data) {
   do_save_as();
}


void on_import_button_clicked(GtkButton *button, gpointer user_data) {
   do_import();
}


void on_savevisio_button_clicked(GtkButton *button, gpointer user_data) {
   do_export_visio();
}


void on_saveps_button_clicked(GtkButton *button, gpointer user_data) {
   do_export_ps();
}


void on_savegif_button_clicked(GtkButton *button, gpointer user_data) {
   do_export_gif();
}


void on_quit_button_clicked(GtkButton *button, gpointer user_data) {
   do_quit();
}


void on_go_stop_button_clicked(GtkButton *button, gpointer user_data) {
   do_go_stop(button);
}



void on_openfile_ok_button_clicked(GtkButton *button, gpointer user_data) {
   my_objectInterface->
      open((char *) 
           gtk_file_selection_get_filename((GtkFileSelection *) openfile_dialog));
   gtk_widget_destroy((GtkWidget *) openfile_dialog);
}


void on_openfile_cancel_button_clicked(GtkButton *button, gpointer  user_data) {
   gtk_widget_destroy((GtkWidget *) openfile_dialog);
}


void on_saveasfile_ok_button_clicked(GtkButton *button, gpointer user_data) {
   my_objectInterface->
      save_as((char *) 
              gtk_file_selection_get_filename((GtkFileSelection *) 
                                              saveasfile_dialog));
   gtk_widget_destroy((GtkWidget *) saveasfile_dialog);
}


void on_saveasfile_cancel_button_clicked(GtkButton *button, gpointer user_data) {
   gtk_widget_destroy((GtkWidget *) saveasfile_dialog);
}


void on_importfile_ok_button_clicked(GtkButton *button, gpointer user_data) {
   my_objectInterface->
      import((char *) 
             gtk_file_selection_get_filename((GtkFileSelection *)
                                             importfile_dialog));
   gtk_widget_destroy((GtkWidget *) importfile_dialog);
}


void on_importfile_cancel_button_clicked(GtkButton *button, gpointer user_data) {
   gtk_widget_destroy((GtkWidget *) importfile_dialog);
}


void on_exportvisiofile_ok_button_clicked(GtkButton *button, gpointer user_data) {
   my_objectInterface->
      export_to_visio((char *) 
                      gtk_file_selection_get_filename((GtkFileSelection *)
                                                      exportvisiofile_dialog));
   gtk_widget_destroy((GtkWidget *) exportvisiofile_dialog);
}


void on_exportvisiofile_cancel_button_clicked(GtkButton *button, gpointer user_data) {
   gtk_widget_destroy((GtkWidget *) exportvisiofile_dialog);
}


void on_exportpsfile_ok_button_clicked(GtkButton *button, gpointer user_data) {
   my_objectInterface->
      export_as_ps((char *) 
                   gtk_file_selection_get_filename((GtkFileSelection *)
                                                   exportpsfile_dialog));
   gtk_widget_destroy((GtkWidget *) exportpsfile_dialog);
}


void on_exportpsfile_cancel_button_clicked(GtkButton *button, gpointer user_data) {
   gtk_widget_destroy((GtkWidget *) exportpsfile_dialog);
}


void on_exportgiffile_ok_button_clicked(GtkButton *button, gpointer user_data) {
   my_objectInterface->
      export_as_gif((char *) 
                    gtk_file_selection_get_filename((GtkFileSelection *)
                                                    exportgiffile_dialog));
   gtk_widget_destroy((GtkWidget *) exportgiffile_dialog);
}


void on_exportgiffile_cancel_button_clicked(GtkButton *button, gpointer user_data) {
   gtk_widget_destroy((GtkWidget *) exportgiffile_dialog);
}


void on_window1_destroy(GtkObject *object, gpointer user_data) {
   do_quit();
}

gboolean on_viewport1_button_press_event (GtkWidget *widget,
					  GdkEventButton *event,
					  gpointer user_data) {
   if (node_selected == 0)
      my_objectInterface->select_node_at(event->x, event->y);
   else
      my_objectInterface->move_selected_node_to(event->x, event->y);
   return FALSE;
}


gboolean on_viewport1_button_release_event(GtkWidget *widget,
					   GdkEventButton *event,
					   gpointer user_data) {
   g_print("vp released at (%f, %f)\n", event->x, event->y);
   return FALSE;
}


gboolean on_viewport1_motion_notify_event(GtkWidget *widget,
					  GdkEventMotion *event,
					  gpointer user_data) {
   g_print("vp moved at (%f, %f)\n", event->x, event->y);
   return FALSE;
}

void on_node_height_spinbutton_changed(GtkEditable *editable, 
                                       gpointer user_data) {
   update_model_constants();
}

void on_node_width_spinbutton_changed(GtkEditable *editable, 
                                      gpointer user_data) {
   update_model_constants();
}

void on_node_mass_spinbutton_changed(GtkEditable *editable,
                                     gpointer user_data) {
   update_model_constants();
}

void on_node_charge_spinbutton_changed(GtkEditable *editable,
                                       gpointer user_data) {
   update_model_constants();
}

void on_spring_length_spinbutton_changed(GtkEditable *editable,
                                         gpointer user_data) {
   update_model_constants();
}

void on_spring_constant_spinbutton_changed(GtkEditable *editable,
                                           gpointer user_data) {
   update_model_constants();
}

void on_max_sa_movement_spinbutton_changed(GtkEditable *editable,
                                           gpointer user_data) {
   update_model_constants();
}

void on_hide_layers_spinbutton_changed(GtkEditable *editable,
                                       gpointer user_data) {
   do_hide_layers_change();
}

void on_draw_nodes_togglebutton_toggled(GtkToggleButton *togglebutton,
                                        gpointer user_data) {
   update_model_constants();
}

void on_draw_springs_togglebutton_toggled(GtkToggleButton *togglebutton,
                                          gpointer user_data) {
   update_model_constants();
}


gboolean on_drawingarea1_expose_event(GtkWidget *widget, GdkEventExpose *event,
				      gpointer user_data) {
   // we only want to redraw if we're not in already in a drawing cycle
   if (go_stop_button_state == 0) {
      my_objectInterface->draw_model();
      return TRUE;
   }
   return FALSE;
}


gboolean on_drawingarea1_button_press_event(GtkWidget      *widget,
                                            GdkEventButton *event,
                                            gpointer        user_data) {
   return FALSE;
}


void on_drawingarea1_drag_begin(GtkWidget *widget, 
                                GdkDragContext *drag_context, 
                                gpointer user_data) {

}


void on_drawingarea1_drag_end(GtkWidget *widget, GdkDragContext *drag_context,
                              gpointer user_data) {

}



void on_button1_clicked(GtkButton *button, gpointer user_data) {
   gtk_widget_destroy((GtkWidget *) notice_popup_window);
}
