#include "psExporter.h"


psExporter::psExporter(char *what_file, nodes *what_nodes) {
   filename = strdup(what_file);
   my_nodes = what_nodes;
   margin = 30;
   scale_factor = 1.7;
}


psExporter::~psExporter() {
   free(filename);
}


void psExporter::do_export() {
   FILE *outfile = fopen(filename, "w");
   find_bounds();
   write_headers(outfile);
   write_edges(outfile);
   write_nodes(outfile);
   fclose(outfile);
}


void psExporter::write_headers(FILE *outfile) {
   char *line = new char[200];
   sprintf(line, "\%!PS-Adobe-1.0\n%%%%BoundingBox: 0 0 %d %d\n%%%%DocumentFonts: Helvetica\n%%%%Pages: 1\n",
           translatexcoord((double) biggest_x) + 2 * margin,
           translateycoord((double) biggest_y) + 2 * margin);
   fwrite(line, strlen(line), 1, outfile);
   delete line;
}


void psExporter::find_bounds() {
   smallest_x = smallest_y =  100000;
   biggest_x  = biggest_y  = -100000;
   node *temp_node;
   for (int temp = 0; temp < my_nodes->number_of_nodes(); temp++) {
      temp_node = my_nodes->get_node(temp);
      if (temp_node->x_pos < smallest_x) smallest_x = (int) temp_node->x_pos;
      if (temp_node->y_pos < smallest_y) smallest_y = (int) temp_node->y_pos;
      if (temp_node->x_pos > biggest_x)  biggest_x  = (int) temp_node->x_pos;
      if (temp_node->y_pos > biggest_y)  biggest_y  = (int) temp_node->y_pos;
   }
}


void psExporter::write_nodes(FILE *outfile) {
   node *temp_node;
   for (int temp = 0; temp < my_nodes->number_of_nodes(); temp++) {
      temp_node = my_nodes->get_node(temp);
      write_node(temp_node, outfile);
   }
}


void psExporter::write_node(node *this_node, FILE *outfile) {
   char *WIDTH = "";
   char *HEIGHT = "";
   char *line = new char[200];
   sprintf(line, "/Helvetica findfont 10 scalefont setfont\n");
   fwrite (line, strlen(line), 1, outfile);
   sprintf(line, "(%s) stringwidth ", this_node->get_name());
   fwrite (line, strlen(line), 1, outfile);
   sprintf(line, "/textywidth exch def /textxwidth exch def ");
   fwrite (line, strlen(line), 1, outfile);
   sprintf(line, "newpath\n  %d textxwidth 2 div sub 2 sub ",            
           translatexcoord(this_node->x_pos));
   fwrite (line, strlen(line), 1, outfile);
   sprintf(line, "%d 14 2 div add moveto ",
           translateycoord(this_node->y_pos));
   fwrite (line, strlen(line), 1, outfile);
   sprintf(line, "textxwidth 4 add 0 rlineto 0 14 -1 mul rlineto ");
   fwrite (line, strlen(line), 1, outfile);
   sprintf(line, "textxwidth 4 add -1 mul 0 rlineto\n");
   fwrite (line, strlen(line), 1, outfile);
   sprintf(line, "closepath\n");
   fwrite (line, strlen(line), 1, outfile);
   sprintf(line, "gsave 1 setgray fill grestore stroke \n");
   fwrite (line, strlen(line), 1, outfile);
   sprintf(line, "/Helvetica findfont 10 scalefont setfont\n");
   fwrite (line, strlen(line), 1, outfile);
   sprintf(line, "%d textxwidth 2 div sub %d 4 sub moveto\n",
           translatexcoord(this_node->x_pos),
           translateycoord(this_node->y_pos));
   fwrite (line, strlen(line), 1, outfile);
   sprintf(line, "(%s) show\n", this_node->get_name());
   fwrite (line, strlen(line), 1, outfile);
   delete line;
}


void psExporter::write_edges(FILE *outfile) {
   node *temp_node;
   node *temp_node2;
   for (int temp = 0; temp < my_nodes->number_of_nodes(); temp++) {
      temp_node = my_nodes->get_node(temp);
      for (int temp2 = 0; temp2 < temp_node->number_of_connections; temp2++) {
         temp_node2 = temp_node->connecting_nodes[temp2];
         write_edge(temp_node, temp_node2, outfile);
      }
   }
}


void psExporter::write_edge(node *from_node, node *to_node, FILE *outfile) {
   char *line = new char[200];
   sprintf(line, "newpath\n  %d %d moveto %d %d lineto closepath stroke\n",
           translatexcoord(from_node->x_pos),
           translateycoord(from_node->y_pos),
           translatexcoord(to_node->x_pos),
           translateycoord(to_node->y_pos));
   fwrite(line, strlen(line), 1, outfile);
   delete line;
}



// Utility methods

int psExporter::translatexcoord(double x) {
   return (int) ((x - smallest_x) * scale_factor) + margin * 2;
}


int psExporter::translateycoord(double y) {
   return (int) ((y - smallest_y) * scale_factor) + margin;
}
