/**
 * visioExporter.h
 *
 * a class to export a nodes class into a visio file
 */

#ifndef __VISIOEXPORTER_H__
#define __VISIOEXPORTER_H__
#include "nodes.h"
#include <stdio.h>

class visioExporter {

 public:

  visioExporter(char *what_file, nodes *what_nodes);   // constructor
  ~visioExporter();                                    // destructor

  void do_export();  // effects the export


 private:
  char *filename;
  nodes *my_nodes;

  void write_headers(FILE *outfile);
  void write_nodes(FILE *outfile);
  void write_node(node *this_node, FILE *outfile);
  void write_edges(FILE *outfile);
  void write_edge(node *from_node, node *to_node, FILE *outfile);
   
  int smallest_x, smallest_y;

  // utility
  char *itoa(int value);
  char *digit(int value, char *string_val);
  char *kill_quotes(char *line);

};


#endif
