#!/usr/bin/perl
use strict;
use warnings FATAL => 'all';
use English qw(-no_match_vars);
use Test::More tests => 5;
use Data::Dumper;

my $path;
BEGIN {
   # Figure out the path to the directory above this file's dirname.
   my $pwd = `pwd`;
   chomp $pwd;
   $path = "$pwd/$0";
   $path =~ s{/[^/]+/[^/]+$}{/};
   unshift @INC, $path;
};
my $class = "innotop";
require $class;
my $innodb_parser = new InnoDBParser;

sub read_file {
   my ($filename) = @_;
   open my $fh, "<", $filename or die $OS_ERROR;
   local $INPUT_RECORD_SEPARATOR = undef;
   my $contents = <$fh>;
   close $fh;
   return $contents;
}

my %versions = (
   $path . 't/innodb-status-001' => "5.5or-earlier",
   $path . 't/innodb-status-002' => "5.5or-earlier",
   $path . 't/innodb-status-006' => "5.5or-earlier",
   $path . 't/innodb-status-007' => "5.5or-earlier",
   $path . 't/innodb-status-008' => "5.6.12"
);

my %tests = (
   $path . 't/innodb-status-001' => {
      IB_bp_add_pool_alloc              => '0',
      IB_bp_awe_mem_alloc               => 0,
      IB_bp_buf_free                    => '8172',
      IB_bp_buf_pool_hit_rate           => '1000 / 1000',
      IB_bp_buf_pool_hits               => 1000,
      IB_bp_buf_pool_reads              => 1000,
      IB_bp_buf_pool_size               => '8191',
      IB_bp_complete                    => 1,
      IB_bp_dict_mem_alloc              => '22888',
      IB_bp_page_creates_sec            => '0.00',
      IB_bp_page_reads_sec              => '0.00',
      IB_bp_page_writes_sec             => '0.00',
      IB_bp_pages_created               => '1',
      IB_bp_pages_modified              => '0',
      IB_bp_pages_read                  => '17',
      IB_bp_pages_total                 => '18',
      IB_bp_pages_written               => '12',
      IB_bp_reads_pending               => '0',
      IB_bp_total_mem_alloc             => '136740864',
      IB_bp_writes_pending              => '0',
      IB_bp_writes_pending_flush_list   => 0,
      IB_bp_writes_pending_lru          => 0,
      IB_bp_writes_pending_single_page  => 0,
      IB_dl_complete                    => undef,
      IB_dl_rolled_back                 => undef,
      IB_dl_timestring                  => undef,
      IB_dl_txns                        => undef,
      IB_fk_attempted_op                => undef,
      IB_fk_child_db                    => undef,
      IB_fk_child_index                 => undef,
      IB_fk_child_table                 => undef,
      IB_fk_col_name                    => undef,
      IB_fk_complete                    => undef,
      IB_fk_fk_name                     => undef,
      IB_fk_parent_col                  => undef,
      IB_fk_parent_db                   => undef,
      IB_fk_parent_index                => undef,
      IB_fk_parent_table                => undef,
      IB_fk_reason                      => undef,
      IB_fk_records                     => undef,
      IB_fk_timestring                  => undef,
      IB_fk_trigger                     => undef,
      IB_fk_txn                         => undef,
      IB_fk_type                        => undef,
      IB_got_all                        => 1,
      IB_ib_bufs_in_node_heap           => 1,
      IB_ib_complete                    => 1,
      IB_ib_free_list_len               => '0',
      IB_ib_hash_searches_s             => '0.00',
      IB_ib_hash_table_size             => 553193,
      IB_ib_inserts                     => '0',
      IB_ib_merged_recs                 => '0',
      IB_ib_merges                      => '0',
      IB_ib_non_hash_searches_s         => '0.00',
      IB_ib_seg_size                    => '2',
      IB_ib_size                        => '1',
      IB_ib_used_cells                  => undef,
      IB_io_avg_bytes_s                 => '0',
      IB_io_complete                    => 1,
      IB_io_flush_type                  => 'fsync',
      IB_io_fsyncs_s                    => '0.00',
      IB_io_os_file_reads               => '28',
      IB_io_os_file_writes              => '19',
      IB_io_os_fsyncs                   => '14',
      IB_io_pending_aio_writes          => '0',
      IB_io_pending_buffer_pool_flushes => '0',
      IB_io_pending_ibuf_aio_reads      => '0',
      IB_io_pending_log_flushes         => '0',
      IB_io_pending_log_ios             => '0',
      IB_io_pending_normal_aio_reads    => '0',
      IB_io_pending_preads              => 0,
      IB_io_pending_pwrites             => 0,
      IB_io_pending_sync_ios            => '0',
      IB_io_reads_s                     => '0.00',
      IB_io_threads                     => {
         '0' => {
            event_set => 0,
            purpose   => 'insert buffer thread',
            state     => 'waiting for i/o request',
            thread    => '0'
         },
         '1' => {
            event_set => 0,
            purpose   => 'log thread',
            state     => 'waiting for i/o request',
            thread    => '1'
         },
         '2' => {
            event_set => 0,
            purpose   => 'read thread',
            state     => 'waiting for i/o request',
            thread    => '2'
         },
         '3' => {
            event_set => 0,
            purpose   => 'read thread',
            state     => 'waiting for i/o request',
            thread    => '3'
         },
         '4' => {
            event_set => 0,
            purpose   => 'read thread',
            state     => 'waiting for i/o request',
            thread    => '4'
         },
         '5' => {
            event_set => 0,
            purpose   => 'read thread',
            state     => 'waiting for i/o request',
            thread    => '5'
         },
         '6' => {
            event_set => 0,
            purpose   => 'write thread',
            state     => 'waiting for i/o request',
            thread    => '6'
         },
         '7' => {
            event_set => 0,
            purpose   => 'write thread',
            state     => 'waiting for i/o request',
            thread    => '7'
         },
         '8' => {
            event_set => 0,
            purpose   => 'write thread',
            state     => 'waiting for i/o request',
            thread    => '8'
         },
         '9' => {
            event_set => 0,
            purpose   => 'write thread',
            state     => 'waiting for i/o request',
            thread    => '9'
         }
      },
      IB_io_writes_s            => '0.00',
      IB_last_secs              => '34',
      IB_lg_complete            => 1,
      IB_lg_last_chkp           => '64909',
      IB_lg_log_flushed_to      => '64909',
      IB_lg_log_ios_done        => '15',
      IB_lg_log_ios_s           => '0.00',
      IB_lg_log_seq_no          => '64909',
      IB_lg_pending_chkp_writes => '0',
      IB_lg_pending_log_writes  => '0',
      IB_ro_complete            => 1,
      IB_ro_del_sec             => '0.00',
      IB_ro_ins_sec             => '0.00',
      IB_ro_main_thread_id      => '2808687472',
      IB_ro_main_thread_proc_no => '7809',
      IB_ro_main_thread_state   => 'waiting for server activity',
      IB_ro_n_reserved_extents  => 0,
      IB_ro_num_rows_del        => '0',
      IB_ro_num_rows_ins        => '2',
      IB_ro_num_rows_read       => '6',
      IB_ro_num_rows_upd        => '0',
      IB_ro_queries_in_queue    => '0',
      IB_ro_queries_inside      => '0',
      IB_ro_read_sec            => '0.00',
      IB_ro_read_views_open     => '1',
      IB_ro_upd_sec             => '0.00',
      IB_sm_complete            => 1,
      IB_sm_mutex_os_waits      => '0',
      IB_sm_mutex_spin_rounds   => '0',
      IB_sm_mutex_spin_waits    => '0',
      IB_sm_reservation_count   => '4',
      IB_sm_rw_excl_os_waits    => '0',
      IB_sm_rw_excl_spins       => '0',
      IB_sm_rw_shared_os_waits  => '4',
      IB_sm_rw_shared_spins     => '4',
      IB_sm_signal_count        => '4',
      IB_sm_wait_array_size     => 0,
      IB_sm_waits               => [],
      IB_timestring             => '2010-09-04 10:24:51',
      IB_tx_complete            => 1,
      IB_tx_history_list_len    => '11',
      IB_tx_is_truncated        => 0,
      IB_tx_num_lock_structs    => undef,
      IB_tx_purge_done_for      => 905,
      IB_tx_purge_undo_for      => 0,
      IB_tx_transactions        => [
         {  active_secs      => 35,
            has_read_view    => 0,
            heap_size        => '320',
            hostname         => 'localhost',
            ip               => '127.0.0.1',
            lock_structs     => '2',
            lock_wait_status => '',
            lock_wait_time   => 0,
            locks            => [
               {  db               => 'test',
                  index            => '',
                  insert_intention => 0,
                  lock_mode        => 'IX',
                  lock_type        => 'TABLE',
                  n_bits           => 0,
                  page_no          => 0,
                  space_id         => 0,
                  special          => '',
                  table            => 't',
                  txn_id           => '907',
                  waiting          => 0
               },
               {  db               => 'test',
                  index            => 'GEN_CLUST_INDEX',
                  insert_intention => 0,
                  lock_mode        => 'X',
                  lock_type        => 'RECORD',
                  n_bits           => 72,
                  page_no          => 50,
                  space_id         => 0,
                  special          => '',
                  table            => 't',
                  txn_id           => '907',
                  waiting          => 0
               },
            ],
            mysql_thread_id    => '1',
            os_thread_id       => 3067652976,
            proc_no            => 7809,
            query_id           => '29',
            query_status       => '',
            query_text         => 'show innodb status',
            row_locks          => '3',
            tables_in_use      => 0,
            tables_locked      => 0,
            thread_decl_inside => 0,
            thread_status      => '',
            txn_doesnt_see_ge  => '',
            txn_id             => 907,
            txn_sees_lt        => '',
            txn_status         => 'ACTIVE',
            undo_log_entries   => 0,
            user               => 'root'
         },
         {  active_secs      => 0,
            has_read_view    => 0,
            heap_size        => '0',
            hostname         => '10.32.0.60',
            ip               => '10.32.0.60',
            lock_structs     => '0',
            lock_wait_status => '',
            lock_wait_time   => 0,
            mysql_thread_id    => '2541119',
            os_thread_id       => 1211378000,
            proc_no            => 11271,
            query_id           => '76087240',
            query_status       => '',
            query_text         => '',
            row_locks          => '0',
            tables_in_use      => 0,
            tables_locked      => 0,
            thread_decl_inside => 0,
            thread_status      => '',
            txn_doesnt_see_ge  => '',
            txn_id             => '3EA5449',
            txn_sees_lt        => '',
            txn_status         => 'not started',
            undo_log_entries   => 0,
            user               => 'vb_admin'
         },
      ],
      IB_tx_trx_id_counter => 908
   },
   $path . 't/innodb-status-002' => {
      IB_bp_add_pool_alloc              => '0',
      IB_bp_awe_mem_alloc               => 0,
      IB_bp_buf_free                    => '378834',
      IB_bp_buf_pool_hit_rate           => '981 / 1000',
      IB_bp_buf_pool_hits               => '981',
      IB_bp_buf_pool_reads              => '1000',
      IB_bp_buf_pool_size               => '383999',
      IB_bp_complete                    => 1,
      IB_bp_dict_mem_alloc              => '552250',
      IB_bp_page_creates_sec            => '0.00',
      IB_bp_page_reads_sec              => '0.09',
      IB_bp_page_writes_sec             => '0.00',
      IB_bp_pages_created               => '2',
      IB_bp_pages_modified              => '9',
      IB_bp_pages_read                  => '5162',
      IB_bp_pages_total                 => '5164',
      IB_bp_pages_written               => '857',
      IB_bp_reads_pending               => '0',
      IB_bp_total_mem_alloc             => '6463488000',
      IB_bp_writes_pending              => '0',
      IB_bp_writes_pending_flush_list   => 0,
      IB_bp_writes_pending_lru          => 0,
      IB_bp_writes_pending_single_page  => 0,
      IB_dl_complete                    => undef,
      IB_dl_rolled_back                 => undef,
      IB_dl_timestring                  => undef,
      IB_dl_txns                        => undef,
      IB_fk_attempted_op                => undef,
      IB_fk_child_db                    => undef,
      IB_fk_child_index                 => undef,
      IB_fk_child_table                 => undef,
      IB_fk_col_name                    => undef,
      IB_fk_complete                    => undef,
      IB_fk_fk_name                     => undef,
      IB_fk_parent_col                  => undef,
      IB_fk_parent_db                   => undef,
      IB_fk_parent_index                => undef,
      IB_fk_parent_table                => undef,
      IB_fk_reason                      => undef,
      IB_fk_records                     => undef,
      IB_fk_timestring                  => undef,
      IB_fk_trigger                     => undef,
      IB_fk_txn                         => undef,
      IB_fk_type                        => undef,
      IB_got_all                        => 1,
      IB_ib_bufs_in_node_heap           => 1,
      IB_ib_complete                    => 1,
      IB_ib_free_list_len               => '19223',
      IB_ib_hash_searches_s             => '0.00',
      IB_ib_hash_table_size             => 12451141,
      IB_ib_inserts                     => undef,
      IB_ib_merged_recs                 => 0,
      IB_ib_merges                      => 0,
      IB_ib_non_hash_searches_s         => '0.73',
      IB_ib_seg_size                    => '19225',
      IB_ib_size                        => '1',
      IB_ib_used_cells                  => undef,
      IB_io_avg_bytes_s                 => '16384',
      IB_io_complete                    => 1,
      IB_io_flush_type                  => 'fsync',
      IB_io_fsyncs_s                    => '0.18',
      IB_io_os_file_reads               => '5212',
      IB_io_os_file_writes              => '1411',
      IB_io_os_fsyncs                   => '407',
      IB_io_pending_aio_writes          => undef,
      IB_io_pending_buffer_pool_flushes => '0',
      IB_io_pending_ibuf_aio_reads      => '0',
      IB_io_pending_log_flushes         => '0',
      IB_io_pending_log_ios             => '0',
      IB_io_pending_normal_aio_reads    => undef,
      IB_io_pending_preads              => 0,
      IB_io_pending_pwrites             => 0,
      IB_io_pending_sync_ios            => '0',
      IB_io_reads_s                     => '0.09',
      IB_io_threads                     => {
         '0' => {
            event_set => 0,
            purpose   => 'insert buffer thread',
            state     => 'waiting for completed aio requests',
            thread    => '0'
         },
         '1' => {
            event_set => 0,
            purpose   => 'log thread',
            state     => 'waiting for completed aio requests',
            thread    => '1'
         },
         '2' => {
            event_set => 0,
            purpose   => 'read thread',
            state     => 'waiting for completed aio requests',
            thread    => '2'
         },
         '3' => {
            event_set => 0,
            purpose   => 'read thread',
            state     => 'waiting for completed aio requests',
            thread    => '3'
         },
         '4' => {
            event_set => 0,
            purpose   => 'read thread',
            state     => 'waiting for completed aio requests',
            thread    => '4'
         },
         '5' => {
            event_set => 0,
            purpose   => 'read thread',
            state     => 'waiting for completed aio requests',
            thread    => '5'
         },
         '6' => {
            event_set => 0,
            purpose   => 'write thread',
            state     => 'waiting for completed aio requests',
            thread    => '6'
         },
         '7' => {
            event_set => 0,
            purpose   => 'write thread',
            state     => 'waiting for completed aio requests',
            thread    => '7'
         },
         '8' => {
            event_set => 0,
            purpose   => 'write thread',
            state     => 'waiting for completed aio requests',
            thread    => '8'
         },
         '9' => {
            event_set => 0,
            purpose   => 'write thread',
            state     => 'waiting for completed aio requests',
            thread    => '9'
         }
      },
      IB_io_writes_s            => '0.36',
      IB_last_secs              => '11',
      IB_lg_complete            => 1,
      IB_lg_last_chkp           => '1577147154244',
      IB_lg_log_flushed_to      => '1577147154821',
      IB_lg_log_ios_done        => '508',
      IB_lg_log_ios_s           => '0.36',
      IB_lg_log_seq_no          => '1577147154821',
      IB_lg_pending_chkp_writes => '0',
      IB_lg_pending_log_writes  => '0',
      IB_ro_complete            => 1,
      IB_ro_del_sec             => '0.00',
      IB_ro_ins_sec             => '0.09',
      IB_ro_main_thread_id      => '139766018828032',
      IB_ro_main_thread_proc_no => '19817',
      IB_ro_main_thread_state   => 'sleeping',
      IB_ro_n_reserved_extents  => 0,
      IB_ro_num_rows_del        => '0',
      IB_ro_num_rows_ins        => '133',
      IB_ro_num_rows_read       => '0',
      IB_ro_num_rows_upd        => '0',
      IB_ro_queries_in_queue    => '0',
      IB_ro_queries_inside      => '0',
      IB_ro_read_sec            => '0.00',
      IB_ro_read_views_open     => '1',
      IB_ro_upd_sec             => '0.00',
      IB_sm_complete            => 1,
      IB_sm_mutex_os_waits      => '19',
      IB_sm_mutex_spin_rounds   => '623',
      IB_sm_mutex_spin_waits    => '86',
      IB_sm_reservation_count   => '80',
      IB_sm_rw_excl_os_waits    => '10',
      IB_sm_rw_excl_spins       => '6',
      IB_sm_rw_shared_os_waits  => '51',
      IB_sm_rw_shared_spins     => '68',
      IB_sm_signal_count        => '85',
      IB_sm_wait_array_size     => 0,
      IB_sm_waits               => [],
      IB_timestring             => '2011-11-06 22:49:47',
      IB_tx_complete            => 1,
      IB_tx_history_list_len    => '1067',
      IB_tx_is_truncated        => 0,
      IB_tx_num_lock_structs    => undef,
      IB_tx_purge_done_for      => '2804F16D',
      IB_tx_purge_undo_for      => '0',
      IB_tx_transactions        => [
         {  active_secs        => 0,
            has_read_view      => 0,
            heap_size          => 0,
            hostname           => 'localhost',
            ip                 => '',
            lock_structs       => 0,
            lock_wait_status   => '',
            lock_wait_time     => 0,
            mysql_thread_id    => '479',
            os_thread_id       => undef,
            proc_no            => 0,
            query_id           => '1793',
            query_status       => '',
            query_text         => 'SHOW engine INNODB STATUS',
            row_locks          => 0,
            tables_in_use      => 0,
            tables_locked      => 0,
            thread_decl_inside => 0,
            thread_status      => '',
            txn_doesnt_see_ge  => '',
            txn_id             => 0,
            txn_sees_lt        => '',
            txn_status         => 'not started',
            undo_log_entries   => 0,
            user               => 'root'
         },
         {  active_secs      => 0,
            has_read_view    => 0,
            heap_size        => 0,
            hostname         => '',
            ip               => '',
            lock_structs     => 0,
            lock_wait_status => '',
            lock_wait_time   => 0,
            mysql_thread_id  => '1',
            os_thread_id     => undef,
            proc_no          => 0,
            query_id         => '1790',
            query_status => 'Slave has read all relay log; waiting for the slave I/O thread to update it',
            query_text         => '',
            row_locks          => 0,
            tables_in_use      => 0,
            tables_locked      => 0,
            thread_decl_inside => 0,
            thread_status      => '',
            txn_doesnt_see_ge  => '',
            txn_id             => '2804F388',
            txn_sees_lt        => '',
            txn_status         => 'not started',
            undo_log_entries   => 0,
            user               => 'system user'
         }
      ],
      IB_tx_trx_id_counter => '2804F389'
   },
   $path . 't/innodb-status-006' => {
      IB_bp_add_pool_alloc             => '0',
      IB_bp_awe_mem_alloc              => 0,
      IB_bp_buf_free                   => '4605',
      IB_bp_buf_pool_hit_rate          => '--',
      IB_bp_buf_pool_hits              => 0,
      IB_bp_buf_pool_reads             => 0,
      IB_bp_buf_pool_size              => '8192',
      IB_bp_complete                   => 1,
      IB_bp_dict_mem_alloc             => '2255860',
      IB_bp_page_creates_sec           => '0.00',
      IB_bp_page_reads_sec             => '0.00',
      IB_bp_page_writes_sec            => '0.00',
      IB_bp_pages_created              => '7994',
      IB_bp_pages_modified             => '0',
      IB_bp_pages_read                 => '2571',
      IB_bp_pages_total                => '3529',
      IB_bp_pages_written              => '47901',
      IB_bp_reads_pending              => '0',
      IB_bp_total_mem_alloc            => '137363456',
      IB_bp_writes_pending             => '0',
      IB_bp_writes_pending_flush_list  => 0,
      IB_bp_writes_pending_lru         => 0,
      IB_bp_writes_pending_single_page => 0,
      IB_dl_complete                   => undef,
      IB_dl_rolled_back                => undef,
      IB_dl_timestring                 => undef,
      IB_dl_txns                       => undef,
      IB_fk_attempted_op               => 'add',
      IB_fk_child_db                   => 'connect',
      IB_fk_child_index                => 'FK_CHANGE_LOG_USER',
      IB_fk_child_table                => 'table_change_log',
      IB_fk_col_name                   => 'USER_ID',
      IB_fk_complete                   => 1,
      IB_fk_fk_name                    => 'FK_CHANGE_LOG_USER',
      IB_fk_parent_col                 => 'USER_ID',
      IB_fk_parent_db                  => 'connect',
      IB_fk_parent_index               => 'PRIMARY',
      IB_fk_parent_table               => 'user_master',
      IB_fk_reason =>
         'Foreign key constraint fails for table `connect`.`table_change_log`:',
      IB_fk_records    => '',
      IB_fk_timestring => '2010-12-20 15:12:17',
      IB_fk_trigger    => {
         byte_offset => 0,
         fields      => [
            {  asc   => '        ',
               hex   => '8000000000000000',
               id    => '0',
               len   => '8',
               trunc => 0
            }
         ],
         heap_no    => 0,
         info_bits  => 0,
         num_fields => '2',
         style      => 'tuple',
         type       => 'DATA TUPLE'
      },
      IB_fk_txn => {
         active_secs      => 0,
         has_read_view    => 0,
         heap_size        => '376',
         hostname         => 'localhost',
         ip               => '127.0.0.1',
         lock_structs     => '3',
         lock_wait_status => '',
         lock_wait_time   => 0,
         mysql_thread_id  => '517',
         os_thread_id     => '4513800192',
         proc_no          => 0,
         query_id         => '177937',
         query_status     => 'update',
         query_text =>
            'INSERT INTO TABLE_CHANGE_LOG (TABLE_CHANGED, ACTION, ROW_IDENTIFIER, USER_ID, ACTION_DATETIME) VALUES (\'CAMPAIGN_MASTER\',\'ADD\',0,0,\'2010-12-20 15:12:17\')',
         row_locks          => '1',
         tables_in_use      => '1',
         tables_locked      => '1',
         thread_decl_inside => 0,
         thread_status      => 'inserting',
         txn_doesnt_see_ge  => '',
         txn_id             => '3837B',
         txn_sees_lt        => '',
         txn_status         => 'ACTIVE',
         undo_log_entries   => '1',
         user               => 'connusr'
      },
      IB_fk_type                        => 'Transaction',
      IB_got_all                        => 1,
      IB_ib_bufs_in_node_heap           => '58',
      IB_ib_complete                    => 1,
      IB_ib_free_list_len               => '33',
      IB_ib_hash_searches_s             => '0.00',
      IB_ib_hash_table_size             => '276707',
      IB_ib_inserts                     => undef,
      IB_ib_merged_recs                 => 0,
      IB_ib_merges                      => 0,
      IB_ib_non_hash_searches_s         => '0.00',
      IB_ib_seg_size                    => '35',
      IB_ib_size                        => '1',
      IB_ib_used_cells                  => undef,
      IB_io_avg_bytes_s                 => '0',
      IB_io_complete                    => 1,
      IB_io_flush_type                  => 'fsync',
      IB_io_fsyncs_s                    => '0.00',
      IB_io_os_file_reads               => '3115',
      IB_io_os_file_writes              => '41716',
      IB_io_os_fsyncs                   => '32225',
      IB_io_pending_aio_writes          => undef,
      IB_io_pending_buffer_pool_flushes => '0',
      IB_io_pending_ibuf_aio_reads      => '0',
      IB_io_pending_log_flushes         => '0',
      IB_io_pending_log_ios             => '0',
      IB_io_pending_normal_aio_reads    => undef,
      IB_io_pending_preads              => 0,
      IB_io_pending_pwrites             => 0,
      IB_io_pending_sync_ios            => '0',
      IB_io_reads_s                     => '0.00',
      IB_io_threads                     => {
         '0' => {
            event_set => 0,
            purpose   => 'insert buffer thread',
            state     => 'waiting for i/o request',
            thread    => '0'
         },
         '1' => {
            event_set => 0,
            purpose   => 'log thread',
            state     => 'waiting for i/o request',
            thread    => '1'
         },
         '2' => {
            event_set => 0,
            purpose   => 'read thread',
            state     => 'waiting for i/o request',
            thread    => '2'
         },
         '3' => {
            event_set => 0,
            purpose   => 'read thread',
            state     => 'waiting for i/o request',
            thread    => '3'
         },
         '4' => {
            event_set => 0,
            purpose   => 'read thread',
            state     => 'waiting for i/o request',
            thread    => '4'
         },
         '5' => {
            event_set => 0,
            purpose   => 'read thread',
            state     => 'waiting for i/o request',
            thread    => '5'
         },
         '6' => {
            event_set => 0,
            purpose   => 'write thread',
            state     => 'waiting for i/o request',
            thread    => '6'
         },
         '7' => {
            event_set => 0,
            purpose   => 'write thread',
            state     => 'waiting for i/o request',
            thread    => '7'
         },
         '8' => {
            event_set => 0,
            purpose   => 'write thread',
            state     => 'waiting for i/o request',
            thread    => '8'
         },
         '9' => {
            event_set => 0,
            purpose   => 'write thread',
            state     => 'waiting for i/o request',
            thread    => '9'
         }
      },
      IB_io_writes_s            => '0.00',
      IB_last_secs              => '6',
      IB_lg_complete            => 1,
      IB_lg_last_chkp           => '1018231439',
      IB_lg_log_flushed_to      => '1018231439',
      IB_lg_log_ios_done        => '26019',
      IB_lg_log_ios_s           => '0.00',
      IB_lg_log_seq_no          => '1018231439',
      IB_lg_pending_chkp_writes => '0',
      IB_lg_pending_log_writes  => '0',
      IB_ro_complete            => 1,
      IB_ro_del_sec             => '0.00',
      IB_ro_ins_sec             => '0.00',
      IB_ro_main_thread_id      => '4496171008',
      IB_ro_main_thread_proc_no => 0,
      IB_ro_main_thread_state   => 'waiting for server activity',
      IB_ro_n_reserved_extents  => 0,
      IB_ro_num_rows_del        => '244011',
      IB_ro_num_rows_ins        => '371946',
      IB_ro_num_rows_read       => '320607956',
      IB_ro_num_rows_upd        => '19634',
      IB_ro_queries_in_queue    => '0',
      IB_ro_queries_inside      => '0',
      IB_ro_read_sec            => '0.00',
      IB_ro_read_views_open     => '1',
      IB_ro_upd_sec             => '0.00',
      IB_sm_complete            => 1,
      IB_sm_mutex_os_waits      => '4010',
      IB_sm_mutex_spin_rounds   => '8236962',
      IB_sm_mutex_spin_waits    => '8538726',
      IB_sm_reservation_count   => '6307',
      IB_sm_rw_excl_os_waits    => '1268',
      IB_sm_rw_excl_spins       => '3522',
      IB_sm_rw_shared_os_waits  => '683',
      IB_sm_rw_shared_spins     => '16635',
      IB_sm_signal_count        => '47086',
      IB_sm_wait_array_size     => 0,
      IB_sm_waits               => [],
      IB_timestring             => '2010-12-20 16:55:47',
      IB_tx_complete            => 1,
      IB_tx_history_list_len    => '130',
      IB_tx_is_truncated        => 0,
      IB_tx_num_lock_structs    => undef,
      IB_tx_purge_done_for      => '38F6C',
      IB_tx_purge_undo_for      => '0',
      IB_tx_transactions        => [
         {  active_secs        => 0,
            has_read_view      => 0,
            heap_size          => 0,
            hostname           => 'localhost',
            ip                 => '',
            lock_structs       => 0,
            lock_wait_status   => '',
            lock_wait_time     => 0,
            mysql_thread_id    => '589',
            os_thread_id       => '4513251328',
            proc_no            => 0,
            query_id           => '215586',
            query_status       => '',
            query_text         => 'SHOW ENGINE INNODB STATUS',
            row_locks          => 0,
            tables_in_use      => 0,
            tables_locked      => 0,
            thread_decl_inside => 0,
            thread_status      => '',
            txn_doesnt_see_ge  => '',
            txn_id             => '0',
            txn_sees_lt        => '',
            txn_status         => 'not started',
            undo_log_entries   => 0,
            user               => 'root'
         },
         {  active_secs        => 0,
            has_read_view      => 0,
            heap_size          => 0,
            hostname           => 'localhost',
            ip                 => '',
            lock_structs       => 0,
            lock_wait_status   => '',
            lock_wait_time     => 0,
            mysql_thread_id    => '577',
            os_thread_id       => '4513525760',
            proc_no            => 0,
            query_id           => '215585',
            query_status       => '',
            query_text         => '',
            row_locks          => 0,
            tables_in_use      => 0,
            tables_locked      => 0,
            thread_decl_inside => 0,
            thread_status      => '',
            txn_doesnt_see_ge  => '',
            txn_id             => '0',
            txn_sees_lt        => '',
            txn_status         => 'not started',
            undo_log_entries   => 0,
            user               => 'root'
         }
      ],
      IB_tx_trx_id_counter => '38F90'
   },
   $path . 't/innodb-status-007' => {
    IB_bp_add_pool_alloc             => '0',
    IB_bp_awe_mem_alloc              => 0,
    IB_bp_buf_free                   => '1',
    IB_bp_buf_pool_hit_rate          => '1000 / 1000',
    IB_bp_buf_pool_hits              => '1000',
    IB_bp_buf_pool_reads             => '1000',
    IB_bp_buf_pool_size              => '786431',
    IB_bp_complete                   => 1,
    IB_bp_dict_mem_alloc             => '2591379',
    IB_bp_page_creates_sec           => '0.44',
    IB_bp_page_reads_sec             => '63.22',
    IB_bp_page_writes_sec            => '5.33',
    IB_bp_pages_created              => '18141794',
    IB_bp_pages_modified             => '63647',
    IB_bp_pages_read                 => '95985174',
    IB_bp_pages_total                => '725943',
    IB_bp_pages_written              => '62048751',
    IB_bp_reads_pending              => '0',
    IB_bp_total_mem_alloc            => '13237223424',
    IB_bp_writes_pending             => '0',
    IB_bp_writes_pending_flush_list  => 0,
    IB_bp_writes_pending_lru         => 0,
    IB_bp_writes_pending_single_page => 0,
    IB_dl_complete                   => 1,
    IB_dl_rolled_back                => '1',
    IB_dl_timestring                 => '2012-09-06 06:03:32',
    IB_dl_txns                       => {
        '1' => {
            locks => [
                {
                    db               => 'foo',
                    index            => 'PRIMARY',
                    insert_intention => 0,
                    lock_mode        => 'X',
                    lock_type        => 'RECORD',
                    n_bits           => '216',
                    page_no          => '10329',
                    space_id         => '3367223',
                    special          => 'rec but not gap',
                    table            => 'foo',
                    txn_id           => 'AFB88BCF',
                    waiting          => 1
                }
            ],
            tx => {
                active_secs        => '9',
                has_read_view      => 0,
                heap_size          => '293304',
                hostname           => '10.8.0.86',
                ip                 => '10.8.0.86',
                lock_structs       => '2914',
                lock_wait_status   => 'LOCK WAIT',
                lock_wait_time     => 0,
                mysql_thread_id    => '384855',
                os_thread_id       => undef,
                proc_no            => 0,
                query_id           => '79940498',
                query_status       => 'Sending data',
                query_text         => 'replace into foo values(1)',
                row_locks          => '231524',
                tables_in_use      => '3',
                tables_locked      => '3',
                thread_decl_inside => 0,
                thread_status      => 'inserting',
                txn_doesnt_see_ge  => '',
                txn_id             => 'AFB88BCF',
                txn_sees_lt        => '',
                txn_status         => 'ACTIVE',
                undo_log_entries   => '270',
                user               => 'robot'
            }
        },
        '2' => {
            locks => [
                {
                    db               => 'foo',
                    index            => 'PRIMARY',
                    insert_intention => 0,
                    lock_mode        => 'S',
                    lock_type        => 'RECORD',
                    n_bits           => '216',
                    page_no          => '10329',
                    space_id         => '3367223',
                    special          => '',
                    table            => 'foo',
                    txn_id           => 'AFB889B6',
                    waiting          => 0
                },
                {
                    db               => 'foo',
                    index            => 'PRIMARY',
                    insert_intention => 0,
                    lock_mode        => 'S',
                    lock_type        => 'RECORD',
                    n_bits           => '184',
                    page_no          => '7113',
                    space_id         => '3367223',
                    special          => '',
                    table            => 'foo',
                    txn_id           => 'AFB889B6',
                    waiting          => 1
                }
            ],
            tx => {
                active_secs        => '12',
                has_read_view      => 0,
                heap_size          => '1391032',
                hostname           => '10.8.0.86',
                ip                 => '10.8.0.86',
                lock_structs       => '12376',
                lock_wait_status   => '',
                lock_wait_time     => 0,
                mysql_thread_id    => '383438',
                os_thread_id       => undef,
                proc_no            => 0,
                query_id           => '79939954',
                query_status       => 'Sending data',
                query_text         => 'replace into foo values(2);',
                row_locks          => '1264011',
                tables_in_use      => '15',
                tables_locked      => '15',
                thread_decl_inside => 0,
                thread_status      => 'fetching rows',
                txn_doesnt_see_ge  => '',
                txn_id             => 'AFB889B6',
                txn_sees_lt        => '',
                txn_status         => 'ACTIVE',
                undo_log_entries   => 0,
                user               => 'robot'
            }
        }
    },
    IB_fk_attempted_op                => undef,
    IB_fk_child_db                    => undef,
    IB_fk_child_index                 => undef,
    IB_fk_child_table                 => undef,
    IB_fk_col_name                    => undef,
    IB_fk_complete                    => undef,
    IB_fk_fk_name                     => undef,
    IB_fk_parent_col                  => undef,
    IB_fk_parent_db                   => undef,
    IB_fk_parent_index                => undef,
    IB_fk_parent_table                => undef,
    IB_fk_reason                      => undef,
    IB_fk_records                     => undef,
    IB_fk_timestring                  => undef,
    IB_fk_trigger                     => undef,
    IB_fk_txn                         => undef,
    IB_fk_type                        => undef,
    IB_got_all                        => 1,
    IB_ib_bufs_in_node_heap           => '60317',
    IB_ib_complete                    => 1,
    IB_ib_free_list_len               => '8651',
    IB_ib_hash_searches_s             => '220514.28',
    IB_ib_hash_table_size             => '25499809',
    IB_ib_inserts                     => undef,
    IB_ib_merged_recs                 => 0,
    IB_ib_merges                      => 0,
    IB_ib_non_hash_searches_s         => '8752.58',
    IB_ib_seg_size                    => '8974',
    IB_ib_size                        => '322',
    IB_ib_used_cells                  => undef,
    IB_io_avg_bytes_s                 => '16384',
    IB_io_complete                    => 1,
    IB_io_flush_type                  => 'fsync',
    IB_io_fsyncs_s                    => '145.43',
    IB_io_os_file_reads               => '95996891',
    IB_io_os_file_writes              => '88803331',
    IB_io_os_fsyncs                   => '27771507',
    IB_io_pending_aio_writes          => undef,
    IB_io_pending_buffer_pool_flushes => '0',
    IB_io_pending_ibuf_aio_reads      => '0',
    IB_io_pending_log_flushes         => '0',
    IB_io_pending_log_ios             => '0',
    IB_io_pending_normal_aio_reads    => undef,
    IB_io_pending_preads              => 0,
    IB_io_pending_pwrites             => 0,
    IB_io_pending_sync_ios            => '0',
    IB_io_reads_s                     => '63.22',
    IB_io_threads                     => {
        '0' => {
            event_set => 0,
            purpose   => 'insert buffer thread',
            state     => 'waiting for completed aio requests',
            thread    => '0'
        },
        '1' => {
            event_set => 0,
            purpose   => 'log thread',
            state     => 'waiting for completed aio requests',
            thread    => '1'
        },
        '2' => {
            event_set => 0,
            purpose   => 'read thread',
            state     => 'waiting for completed aio requests',
            thread    => '2'
        },
        '3' => {
            event_set => 0,
            purpose   => 'read thread',
            state     => 'waiting for completed aio requests',
            thread    => '3'
        },
        '4' => {
            event_set => 0,
            purpose   => 'read thread',
            state     => 'waiting for completed aio requests',
            thread    => '4'
        },
        '5' => {
            event_set => 0,
            purpose   => 'read thread',
            state     => 'waiting for completed aio requests',
            thread    => '5'
        },
        '6' => {
            event_set => 0,
            purpose   => 'write thread',
            state     => 'waiting for completed aio requests',
            thread    => '6'
        },
        '7' => {
            event_set => 0,
            purpose   => 'write thread',
            state     => 'waiting for completed aio requests',
            thread    => '7'
        },
        '8' => {
            event_set => 0,
            purpose   => 'write thread',
            state     => 'waiting for completed aio requests',
            thread    => '8'
        },
        '9' => {
            event_set => 0,
            purpose   => 'write thread',
            state     => 'waiting for completed aio requests',
            thread    => '9'
        }
    },
    IB_io_writes_s            => '149.65',
    IB_last_secs              => '9',
    IB_lg_complete            => 1,
    IB_lg_last_chkp           => '39212863356560',
    IB_lg_log_flushed_to      => '39213820967021',
    IB_lg_log_ios_done        => '24586488',
    IB_lg_log_ios_s           => '143.32',
    IB_lg_log_seq_no          => '39213820967021',
    IB_lg_pending_chkp_writes => '0',
    IB_lg_pending_log_writes  => '0',
    IB_ro_complete            => 1,
    IB_ro_del_sec             => '1.33',
    IB_ro_ins_sec             => '67.33',
    IB_ro_main_thread_id      => '140473240184576',
    IB_ro_main_thread_proc_no => '13869',
    IB_ro_main_thread_state   => 'flushing log',
    IB_ro_n_reserved_extents  => 0,
    IB_ro_num_rows_del        => '412538883',
    IB_ro_num_rows_ins        => '2725314464',
    IB_ro_num_rows_read       => '112046481021',
    IB_ro_num_rows_upd        => '918941044',
    IB_ro_queries_in_queue    => '0',
    IB_ro_queries_inside      => '0',
    IB_ro_read_sec            => '233188.31',
    IB_ro_read_views_open     => '2',
    IB_ro_upd_sec             => '17.55',
    IB_sm_complete            => 1,
    IB_sm_mutex_os_waits      => '14115318',
    IB_sm_mutex_spin_rounds   => '1869427362',
    IB_sm_mutex_spin_waits    => '994672655',
    IB_sm_reservation_count   => '56103364',
    IB_sm_rw_excl_os_waits    => '24743296',
    IB_sm_rw_excl_spins       => '81742409',
    IB_sm_rw_shared_os_waits  => '14831919',
    IB_sm_rw_shared_spins     => '93199886',
    IB_sm_signal_count        => '517940481',
    IB_sm_wait_array_size     => 0,
    IB_sm_waits               => [],
    IB_timestring             => '2012-09-06 17:23:04',
    IB_tx_complete            => 1,
    IB_tx_history_list_len    => '2496',
    IB_tx_is_truncated        => 0,
    IB_tx_num_lock_structs    => undef,
    IB_tx_purge_done_for      => 'B00554DC',
    IB_tx_purge_undo_for      => '0',
    IB_tx_transactions        => [
        {
            active_secs        => 0,
            has_read_view      => 0,
            heap_size          => 0,
            hostname           => '10.8.0.14',
            ip                 => '10.8.0.14',
            lock_structs       => 0,
            lock_wait_status   => '',
            lock_wait_time     => 0,
            mysql_thread_id    => '406416',
            os_thread_id       => undef,
            proc_no            => 0,
            query_id           => '84817453',
            query_status       => '',
            query_text         => 'show engine innodb status',
            row_locks          => 0,
            tables_in_use      => 0,
            tables_locked      => 0,
            thread_decl_inside => 0,
            thread_status      => '',
            txn_doesnt_see_ge  => '',
            txn_id             => '0',
            txn_sees_lt        => '',
            txn_status         => 'not started',
            undo_log_entries   => 0,
            user               => 'baron'
        },
        {
            active_secs        => 0,
            has_read_view      => 0,
            heap_size          => 0,
            hostname           => '10.8.0.86',
            ip                 => '10.8.0.86',
            lock_structs       => 0,
            lock_wait_status   => '',
            lock_wait_time     => 0,
            mysql_thread_id    => '406404',
            os_thread_id       => undef,
            proc_no            => 0,
            query_id           => '84817397',
            query_status       => '',
            query_text         => '',
            row_locks          => 0,
            tables_in_use      => 0,
            tables_locked      => 0,
            thread_decl_inside => 0,
            thread_status      => '',
            txn_doesnt_see_ge  => '',
            txn_id             => 'B0055553',
            txn_sees_lt        => '',
            txn_status         => 'not started',
            undo_log_entries   => 0,
            user               => 'robot'
        },
        {
            active_secs        => 0,
            has_read_view      => 0,
            heap_size          => 0,
            hostname           => '10.8.0.86',
            ip                 => '10.8.0.86',
            lock_structs       => 0,
            lock_wait_status   => '',
            lock_wait_time     => 0,
            mysql_thread_id    => '406265',
            os_thread_id       => undef,
            proc_no            => 0,
            query_id           => '84803117',
            query_status       => '',
            query_text         => '',
            row_locks          => 0,
            tables_in_use      => 0,
            tables_locked      => 0,
            thread_decl_inside => 0,
            thread_status      => '',
            txn_doesnt_see_ge  => '',
            txn_id             => 'B00519AB',
            txn_sees_lt        => '',
            txn_status         => 'not started',
            undo_log_entries   => 0,
            user               => 'robot'
        },
        {
            active_secs        => 0,
            has_read_view      => 0,
            heap_size          => 0,
            hostname           => '10.8.0.86',
            ip                 => '10.8.0.86',
            lock_structs       => 0,
            lock_wait_status   => '',
            lock_wait_time     => 0,
            mysql_thread_id    => '405693',
            os_thread_id       => undef,
            proc_no            => 0,
            query_id           => '84808823',
            query_status       => '',
            query_text         => '',
            row_locks          => 0,
            tables_in_use      => 0,
            tables_locked      => 0,
            thread_decl_inside => 0,
            thread_status      => '',
            txn_doesnt_see_ge  => '',
            txn_id             => 'B0053111',
            txn_sees_lt        => '',
            txn_status         => 'not started',
            undo_log_entries   => 0,
            user               => 'robot'
        },
        {
            active_secs        => 0,
            has_read_view      => 0,
            heap_size          => 0,
            hostname           => '10.8.0.86',
            ip                 => '10.8.0.86',
            lock_structs       => 0,
            lock_wait_status   => '',
            lock_wait_time     => 0,
            mysql_thread_id    => '405583',
            os_thread_id       => undef,
            proc_no            => 0,
            query_id           => '84806045',
            query_status       => '',
            query_text         => '',
            row_locks          => 0,
            tables_in_use      => 0,
            tables_locked      => 0,
            thread_decl_inside => 0,
            thread_status      => '',
            txn_doesnt_see_ge  => '',
            txn_id             => 'B005253C',
            txn_sees_lt        => '',
            txn_status         => 'not started',
            undo_log_entries   => 0,
            user               => 'robot'
        },
        {
            active_secs        => 0,
            has_read_view      => 0,
            heap_size          => 0,
            hostname           => '10.8.0.86',
            ip                 => '10.8.0.86',
            lock_structs       => 0,
            lock_wait_status   => '',
            lock_wait_time     => 0,
            mysql_thread_id    => '405503',
            os_thread_id       => undef,
            proc_no            => 0,
            query_id           => '84817393',
            query_status       => '',
            query_text         => '',
            row_locks          => 0,
            tables_in_use      => 0,
            tables_locked      => 0,
            thread_decl_inside => 0,
            thread_status      => '',
            txn_doesnt_see_ge  => '',
            txn_id             => 'B005554F',
            txn_sees_lt        => '',
            txn_status         => 'not started',
            undo_log_entries   => 0,
            user               => 'robot'
        },
        {
            active_secs        => 0,
            has_read_view      => 0,
            heap_size          => 0,
            hostname           => '10.8.0.86',
            ip                 => '10.8.0.86',
            lock_structs       => 0,
            lock_wait_status   => '',
            lock_wait_time     => 0,
            mysql_thread_id    => '405482',
            os_thread_id       => undef,
            proc_no            => 0,
            query_id           => '84802793',
            query_status       => '',
            query_text         => '',
            row_locks          => 0,
            tables_in_use      => 0,
            tables_locked      => 0,
            thread_decl_inside => 0,
            thread_status      => '',
            txn_doesnt_see_ge  => '',
            txn_id             => 'B0051863',
            txn_sees_lt        => '',
            txn_status         => 'not started',
            undo_log_entries   => 0,
            user               => 'robot'
        },
        {
            active_secs        => 0,
            has_read_view      => 0,
            heap_size          => 0,
            hostname           => '10.8.0.86',
            ip                 => '10.8.0.86',
            lock_structs       => 0,
            lock_wait_status   => '',
            lock_wait_time     => 0,
            mysql_thread_id    => '405448',
            os_thread_id       => undef,
            proc_no            => 0,
            query_id           => '84816488',
            query_status       => '',
            query_text         => '',
            row_locks          => 0,
            tables_in_use      => 0,
            tables_locked      => 0,
            thread_decl_inside => 0,
            thread_status      => '',
            txn_doesnt_see_ge  => '',
            txn_id             => 'B0055199',
            txn_sees_lt        => '',
            txn_status         => 'not started',
            undo_log_entries   => 0,
            user               => 'deadlock'
        },
        {
            active_secs        => 0,
            has_read_view      => 0,
            heap_size          => 0,
            hostname           => '10.8.0.86',
            ip                 => '10.8.0.86',
            lock_structs       => 0,
            lock_wait_status   => '',
            lock_wait_time     => 0,
            mysql_thread_id    => '405447',
            os_thread_id       => undef,
            proc_no            => 0,
            query_id           => '84816485',
            query_status       => '',
            query_text         => '',
            row_locks          => 0,
            tables_in_use      => 0,
            tables_locked      => 0,
            thread_decl_inside => 0,
            thread_status      => '',
            txn_doesnt_see_ge  => '',
            txn_id             => '0',
            txn_sees_lt        => '',
            txn_status         => 'not started',
            undo_log_entries   => 0,
            user               => 'deadlock'
        },
        {
            active_secs        => 0,
            has_read_view      => 0,
            heap_size          => 0,
            hostname           => '10.8.0.86',
            ip                 => '10.8.0.86',
            lock_structs       => 0,
            lock_wait_status   => '',
            lock_wait_time     => 0,
            mysql_thread_id    => '405444',
            os_thread_id       => undef,
            proc_no            => 0,
            query_id           => '84814555',
            query_status       => '',
            query_text         => '',
            row_locks          => 0,
            tables_in_use      => 0,
            tables_locked      => 0,
            thread_decl_inside => 0,
            thread_status      => '',
            txn_doesnt_see_ge  => '',
            txn_id             => '0',
            txn_sees_lt        => '',
            txn_status         => 'not started',
            undo_log_entries   => 0,
            user               => 'sniper'
        },
        {
            active_secs        => 0,
            has_read_view      => 0,
            heap_size          => 0,
            hostname           => '10.8.0.86',
            ip                 => '10.8.0.86',
            lock_structs       => 0,
            lock_wait_status   => '',
            lock_wait_time     => 0,
            mysql_thread_id    => '401251',
            os_thread_id       => undef,
            proc_no            => 0,
            query_id           => '84817451',
            query_status       => '',
            query_text         => '',
            row_locks          => 0,
            tables_in_use      => 0,
            tables_locked      => 0,
            thread_decl_inside => 0,
            thread_status      => '',
            txn_doesnt_see_ge  => '',
            txn_id             => 'B0055590',
            txn_sees_lt        => '',
            txn_status         => 'not started',
            undo_log_entries   => 0,
            user               => 'robot'
        },
        {
            active_secs        => 0,
            has_read_view      => 0,
            heap_size          => 0,
            hostname           => '10.8.0.86',
            ip                 => '10.8.0.86',
            lock_structs       => 0,
            lock_wait_status   => '',
            lock_wait_time     => 0,
            mysql_thread_id    => '401249',
            os_thread_id       => undef,
            proc_no            => 0,
            query_id           => '83485705',
            query_status       => '',
            query_text         => '',
            row_locks          => 0,
            tables_in_use      => 0,
            tables_locked      => 0,
            thread_decl_inside => 0,
            thread_status      => '',
            txn_doesnt_see_ge  => '',
            txn_id             => 'AFEFFF54',
            txn_sees_lt        => '',
            txn_status         => 'not started',
            undo_log_entries   => 0,
            user               => 'robot'
        },
        {
            active_secs        => 0,
            has_read_view      => 0,
            heap_size          => 0,
            hostname           => '10.8.0.86',
            ip                 => '10.8.0.86',
            lock_structs       => 0,
            lock_wait_status   => '',
            lock_wait_time     => 0,
            mysql_thread_id    => '378124',
            os_thread_id       => undef,
            proc_no            => 0,
            query_id           => '84817362',
            query_status       => '',
            query_text         => '',
            row_locks          => 0,
            tables_in_use      => 0,
            tables_locked      => 0,
            thread_decl_inside => 0,
            thread_status      => '',
            txn_doesnt_see_ge  => '',
            txn_id             => 'AFADEC5C',
            txn_sees_lt        => '',
            txn_status         => 'not started',
            undo_log_entries   => 0,
            user               => 'checksum'
        },
        {
            active_secs        => 0,
            has_read_view      => 0,
            heap_size          => 0,
            hostname           => '10.8.0.86',
            ip                 => '10.8.0.86',
            lock_structs       => 0,
            lock_wait_status   => '',
            lock_wait_time     => 0,
            mysql_thread_id    => '378123',
            os_thread_id       => undef,
            proc_no            => 0,
            query_id           => '84817442',
            query_status       => '',
            query_text         => '',
            row_locks          => 0,
            tables_in_use      => 0,
            tables_locked      => 0,
            thread_decl_inside => 0,
            thread_status      => '',
            txn_doesnt_see_ge  => '',
            txn_id             => 'AFADEC48',
            txn_sees_lt        => '',
            txn_status         => 'not started',
            undo_log_entries   => 0,
            user               => 'checksum'
        },
        {
            active_secs      => 0,
            has_read_view    => 0,
            heap_size        => 0,
            hostname         => '',
            ip               => '',
            lock_structs     => 0,
            lock_wait_status => '',
            lock_wait_time   => 0,
            mysql_thread_id  => '2',
            os_thread_id     => undef,
            proc_no          => 0,
            query_id         => '84675969',
            query_status => 'Slave has read all relay log; waiting for the slave I/O thread to update it',
            query_text         => '',
            row_locks          => 0,
            tables_in_use      => 0,
            tables_locked      => 0,
            thread_decl_inside => 0,
            thread_status      => '',
            txn_doesnt_see_ge  => '',
            txn_id             => 'B00310F1',
            txn_sees_lt        => '',
            txn_status         => 'not started',
            undo_log_entries   => 0,
            user               => 'system user'
        },
        {
            active_secs        => 0,
            has_read_view      => 1,
            heap_size          => 0,
            hostname           => '10.8.0.86',
            ip                 => '10.8.0.86',
            lock_structs       => 0,
            lock_wait_status   => '',
            lock_wait_time     => 0,
            mysql_thread_id    => '405451',
            os_thread_id       => undef,
            proc_no            => 0,
            query_id           => '84817400',
            query_status       => 'Copying to tmp table',
            query_text         => 'select foo from bar',
            row_locks          => 0,
            tables_in_use      => '2',
            tables_locked      => 0,
            thread_decl_inside => 0,
            thread_status      => 'fetching rows',
            txn_doesnt_see_ge  => 'B005555A',
            txn_id             => 'B0055559',
            txn_sees_lt        => 'B0049C63',
            txn_status         => 'ACTIVE',
            undo_log_entries   => 0,
            user               => 'robot'
        },
        {
            active_secs      => '354',
            has_read_view    => 0,
            heap_size        => '2800056',
            hostname         => '10.8.0.86',
            ip               => '10.8.0.86',
            lock_structs     => '24834',
            lock_wait_status => '',
            lock_wait_time   => 0,
            locks            => [
                {
                    db               => 'foo',
                    index            => '',
                    insert_intention => 0,
                    lock_mode        => 'IS',
                    lock_type        => 'TABLE',
                    n_bits           => 0,
                    page_no          => 0,
                    space_id         => 0,
                    special          => '',
                    table            => 'foo',
                    txn_id           => 'B0049C63',
                    waiting          => 0
                },
                {
                    db               => 'foo',
                    index            => 'PRIMARY',
                    insert_intention => 0,
                    lock_mode        => 'S',
                    lock_type        => 'RECORD',
                    n_bits           => '208',
                    page_no          => '41',
                    space_id         => '3005708',
                    special          => 'rec but not gap',
                    table            => 'foo',
                    txn_id           => 'B0049C63',
                    waiting          => 0
                },
                {
                    db               => 'foo',
                    index            => '',
                    insert_intention => 0,
                    lock_mode        => 'IX',
                    lock_type        => 'TABLE',
                    n_bits           => 0,
                    page_no          => 0,
                    space_id         => 0,
                    special          => '',
                    table            => 'foo',
                    txn_id           => 'B0049C63',
                    waiting          => 0
                },
                {
                    db               => 'foo',
                    index            => 'PRIMARY',
                    insert_intention => 0,
                    lock_mode        => 'S',
                    lock_type        => 'RECORD',
                    n_bits           => '208',
                    page_no          => '41',
                    space_id         => '3005708',
                    special          => '',
                    table            => 'foo',
                    txn_id           => 'B0049C63',
                    waiting          => 0
                },
                {
                    db               => 'foo',
                    index            => 'PRIMARY',
                    insert_intention => 0,
                    lock_mode        => 'S',
                    lock_type        => 'RECORD',
                    n_bits           => '208',
                    page_no          => '43',
                    space_id         => '3005708',
                    special          => '',
                    table            => 'foo',
                    txn_id           => 'B0049C63',
                    waiting          => 0
                },
                {
                    db               => 'foo',
                    index            => '',
                    insert_intention => 0,
                    lock_mode        => 'IS',
                    lock_type        => 'TABLE',
                    n_bits           => 0,
                    page_no          => 0,
                    space_id         => 0,
                    special          => '',
                    table            => 'foo',
                    txn_id           => 'B0049C63',
                    waiting          => 0
                },
                {
                    db               => 'foo',
                    index            => 'PRIMARY',
                    insert_intention => 0,
                    lock_mode        => 'S',
                    lock_type        => 'RECORD',
                    n_bits           => '152',
                    page_no          => '3',
                    space_id         => '164',
                    special          => '',
                    table            => 'foo',
                    txn_id           => 'B0049C63',
                    waiting          => 0
                },
                {
                    db               => 'foo',
                    index            => 'PRIMARY',
                    insert_intention => 0,
                    lock_mode        => 'X',
                    lock_type        => 'RECORD',
                    n_bits           => '136',
                    page_no          => '3',
                    space_id         => '4142440',
                    special          => 'rec but not gap',
                    table            => 'foo',
                    txn_id           => 'B0049C63',
                    waiting          => 0
                },
                {
                    db               => 'foo',
                    index            => 'PRIMARY',
                    insert_intention => 0,
                    lock_mode        => 'X',
                    lock_type        => 'RECORD',
                    n_bits           => '136',
                    page_no          => '3',
                    space_id         => '4142440',
                    special          => '',
                    table            => 'foo',
                    txn_id           => 'B0049C63',
                    waiting          => 0
                },
                {
                    db               => 'foo',
                    index            => 'PRIMARY',
                    insert_intention => 0,
                    lock_mode        => 'S',
                    lock_type        => 'RECORD',
                    n_bits           => '152',
                    page_no          => '3',
                    space_id         => '164',
                    special          => 'gap before rec',
                    table            => 'foo',
                    txn_id           => 'B0049C63',
                    waiting          => 0
                }
            ],
            mysql_thread_id    => '406073',
            os_thread_id       => undef,
            proc_no            => 0,
            query_id           => '84772439',
            query_status       => 'Copying to tmp table on disk',
            query_text         => 'insert into baz.bat',
            row_locks          => '4093569',
            tables_in_use      => '13',
            tables_locked      => '13',
            thread_decl_inside => 0,
            thread_status      => '',
            txn_doesnt_see_ge  => '',
            txn_id             => 'B0049C63',
            txn_sees_lt        => '',
            txn_status         => 'ACTIVE',
            undo_log_entries   => '63',
            user               => 'robot'
        }
    ],
    IB_tx_trx_id_counter => 'B0055592'
  },
  $path . "t/innodb-status-008" => {
    IB_bp_add_pool_alloc => '0',
    IB_bp_awe_mem_alloc => 0,
    IB_bp_buf_free => '8002',
    IB_bp_buf_pool_hit_rate => '895 / 1000',
    IB_bp_buf_pool_hits => '895',
    IB_bp_buf_pool_reads => '1000',
    IB_bp_buf_pool_size => '8191',
    IB_bp_complete => 1,
    IB_bp_dict_mem_alloc => '61633',
    IB_bp_page_creates_sec => '0.03',
    IB_bp_page_reads_sec => '0.36',
    IB_bp_page_writes_sec => '0.15',
    IB_bp_pages_created => '1',
    IB_bp_pages_modified => '0',
    IB_bp_pages_read => '188',
    IB_bp_pages_total => '189',
    IB_bp_pages_written => '6',
    IB_bp_reads_pending => '0',
    IB_bp_total_mem_alloc => '137363456',
    IB_bp_writes_pending => '0',
    IB_bp_writes_pending_flush_list => 0,
    IB_bp_writes_pending_lru => 0,
    IB_bp_writes_pending_single_page => 0,
    IB_dl_complete => undef,
    IB_dl_rolled_back => undef,
    IB_dl_timestring => undef,
    IB_dl_txns => undef,
    IB_fk_attempted_op => 'delete or update',
    IB_fk_child_db => 'test',
    IB_fk_child_index => 'parent_id',
    IB_fk_child_table => 'child',
    IB_fk_col_name => 'parent_id',
    IB_fk_complete => 1,
    IB_fk_fk_name => 'child_ibfk_1',
    IB_fk_parent_col => 'id',
    IB_fk_parent_db => 'test',
    IB_fk_parent_index => 'PRIMARY',
    IB_fk_parent_table => 'parent',
    IB_fk_reason => 'Foreign key constraint fails for table `test`.`child`:',
    IB_fk_records => '',
    IB_fk_timestring => '2013-06-19 13:47:33',
    IB_fk_trigger => {
      byte_offset => 0,
      fields => [
        {
          asc => '    ',
          hex => '80000001',
          id => '0',
          len => '4',
          trunc => 0
        }
      ],
      heap_no => 0,
      info_bits => 0,
      num_fields => '4',
      style => 'tuple',
      type => 'DATA TUPLE'
    },
    IB_fk_txn => {
      active_secs => 0,
      has_read_view => 0,
      heap_size => '1248',
      hostname => 'localhost',
      ip => '',
      lock_structs => '4',
      lock_wait_status => '',
      lock_wait_time => 0,
      mysql_thread_id => '1',
      os_thread_id => undef,
      proc_no => 0,
      query_id => '14',
      query_status => 'updating',
      query_text => 'delete from parent',
      row_locks => '2',
      tables_in_use => '1',
      tables_locked => '1',
      thread_decl_inside => 0,
      thread_status => 'updating or deleting',
      txn_doesnt_see_ge => '',
      txn_id => '2820',
      txn_sees_lt => '',
      txn_status => 'ACTIVE',
      undo_log_entries => '1',
      user => 'root'
    },
    IB_fk_type => 'Transaction',
    IB_got_all => 1,
    IB_ib_bufs_in_node_heap => '0',
    IB_ib_complete => 1,
    IB_ib_free_list_len => '0',
    IB_ib_hash_searches_s => '0.00',
    IB_ib_hash_table_size => '276671',
    IB_ib_inserts => undef,
    IB_ib_merged_recs => 0,
    IB_ib_merges => 0,
    IB_ib_non_hash_searches_s => '1.06',
    IB_ib_seg_size => '2',
    IB_ib_size => '1',
    IB_ib_used_cells => undef,
    IB_io_avg_bytes_s => '16384',
    IB_io_complete => 1,
    IB_io_flush_type => 'fsync',
    IB_io_fsyncs_s => '0.15',
    IB_io_os_file_reads => '330',
    IB_io_os_file_writes => '13',
    IB_io_os_fsyncs => '10',
    IB_io_pending_aio_writes => undef,
    IB_io_pending_buffer_pool_flushes => '0',
    IB_io_pending_ibuf_aio_reads => '0',
    IB_io_pending_log_flushes => '0',
    IB_io_pending_log_ios => '0',
    IB_io_pending_normal_aio_reads => undef,
    IB_io_pending_preads => 0,
    IB_io_pending_pwrites => 0,
    IB_io_pending_sync_ios => '0',
    IB_io_reads_s => '0.39',
    IB_io_threads => {
      '0' => {
        event_set => 0,
        purpose => 'insert buffer thread',
        state => 'waiting for completed aio requests',
        thread => '0'
      },
      '1' => {
        event_set => 0,
        purpose => 'log thread',
        state => 'waiting for completed aio requests',
        thread => '1'
      },
      '2' => {
        event_set => 0,
        purpose => 'read thread',
        state => 'waiting for completed aio requests',
        thread => '2'
      },
      '3' => {
        event_set => 0,
        purpose => 'read thread',
        state => 'waiting for completed aio requests',
        thread => '3'
      },
      '4' => {
        event_set => 0,
        purpose => 'read thread',
        state => 'waiting for completed aio requests',
        thread => '4'
      },
      '5' => {
        event_set => 0,
        purpose => 'read thread',
        state => 'waiting for completed aio requests',
        thread => '5'
      },
      '6' => {
        event_set => 0,
        purpose => 'write thread',
        state => 'waiting for completed aio requests',
        thread => '6'
      },
      '7' => {
        event_set => 0,
        purpose => 'write thread',
        state => 'waiting for completed aio requests',
        thread => '7'
      },
      '8' => {
        event_set => 0,
        purpose => 'write thread',
        state => 'waiting for completed aio requests',
        thread => '8'
      },
      '9' => {
        event_set => 0,
        purpose => 'write thread',
        state => 'waiting for completed aio requests',
        thread => '9'
      }
    },
    IB_io_writes_s => '0.24',
    IB_last_secs => '33',
    IB_lg_complete => 1,
    IB_lg_last_chkp => '1666626',
    IB_lg_log_flushed_to => '1666626',
    IB_lg_log_ios_done => '10',
    IB_lg_log_ios_s => '0.06',
    IB_lg_log_seq_no => '1666626',
    IB_lg_pending_chkp_writes => '0',
    IB_lg_pending_log_writes => '0',
    IB_ro_complete => 1,
    IB_ro_del_sec => '0.00',
    IB_ro_ins_sec => '0.00',
    IB_ro_main_thread_id => '140085928748800',
    IB_ro_main_thread_proc_no => '1289',
    IB_ro_main_thread_state => 'sleeping',
    IB_ro_n_reserved_extents => 0,
    IB_ro_num_rows_del => '0',
    IB_ro_num_rows_ins => '0',
    IB_ro_num_rows_read => '1',
    IB_ro_num_rows_upd => '0',
    IB_ro_queries_in_queue => '0',
    IB_ro_queries_inside => '0',
    IB_ro_read_sec => '0.03',
    IB_ro_read_views_open => 0,
    IB_ro_upd_sec => '0.00',
    IB_sm_complete => 1,
    IB_sm_mutex_os_waits => '3',
    IB_sm_mutex_spin_rounds => '120',
    IB_sm_mutex_spin_waits => '4',
    IB_sm_reservation_count => undef,
    IB_sm_rw_excl_os_waits => '0',
    IB_sm_rw_excl_spins => '0',
    IB_sm_rw_shared_os_waits => '2',
    IB_sm_rw_shared_spins => '3',
    IB_sm_signal_count => undef,
    IB_sm_wait_array_size => 0,
    IB_sm_waits => [],
    IB_timestring => '2013-06-19 13:47:37',
    IB_tx_complete => 1,
    IB_tx_history_list_len => '18',
    IB_tx_is_truncated => 0,
    IB_tx_num_lock_structs => undef,
    IB_tx_purge_done_for => undef,
    IB_tx_purge_undo_for => undef,
    IB_tx_transactions => [
      {
        active_secs => 0,
        has_read_view => 0,
        heap_size => 0,
        hostname => 'localhost',
        ip => '',
        lock_structs => 0,
        lock_wait_status => '',
        lock_wait_time => 0,
        mysql_thread_id => '1',
        os_thread_id => undef,
        proc_no => 0,
        query_id => '15',
        query_status => 'init',
        query_text => 'show engine innodb status',
        row_locks => 0,
        tables_in_use => 0,
        tables_locked => 0,
        thread_decl_inside => 0,
        thread_status => '',
        txn_doesnt_see_ge => '',
        txn_id => '2820',
        txn_sees_lt => '',
        txn_status => 'not started',
        undo_log_entries => 0,
        user => 'root'
      }
    ],
    IB_tx_trx_id_counter => '2822'
    }
);

foreach my $fn ( keys %tests ) {
   my $contents = read_file($fn);
   my %result   = $innodb_parser->get_status_hash($contents, undef, undef, undef, $versions{$fn});
   local $Data::Dumper::Indent = 2;
   #print Dumper \%result;
   my $expected = $tests{$fn};
   is_deeply(\%result, $expected, $fn);
}

