/*
 *	$Id: j2d.c,v 1.11 2005/10/06 22:30:13 hiram Exp $
 *
 *	Copyright (c) 1986-2005, Hiram Clawson - email: jday at hiram.ws
 *	All rights reserved.
 *
 *	Redistribution and use in source and binary forms, with or
 *	without modification, are permitted provided that the following
 *	conditions are met:
 *
 *		Redistributions of source code must retain the above
 *		copyright notice, this list of conditions and the
 *		following disclaimer.
 *
 *		Redistributions in binary form must reproduce the
 *		above copyright notice, this list of conditions and
 *		the following disclaimer in the documentation and/or
 *		other materials provided with the distribution.
 *
 *		Neither name of The Museum of Hiram nor the names of
 *		its contributors may be used to endorse or promote products
 *		derived from this software without specific prior
 *		written permission. 
 *
 *	THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 *	CONTRIBUTORS ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES,
 *	INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 *	MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *	IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *	INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 *	(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 *	OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 *	HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 *	STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 *	IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 *	THE POSSIBILITY OF SUCH DAMAGE. 
 */
/*
 *
 *	j2d - requires one argument, a julian date
 *		take that julian date and turn it into a date
 *	jday - output julian date
 *	- no arguments - julian date for right now
 *	- otherwise, jday [year] [month] [day] [hour] [minute]
 *	- with only [year] - uses today for month, day, hour, minute
 *	- with [year] [month] - uses today for day, hour, minute
 *	- etc...
 *	- must have [year] if using [month]
 *	- must have [month] if using [day]
 *	- must have [day] if using [hour]
 *	- must have [hour] if using [minute]
 *	- i.e. the arguments are purely positional
 *
 */

#include	<stdio.h>
#include  <sys/types.h>
#include <stdlib.h>
#include <string.h>
#include  <time.h>
#include <math.h>
#include "jday.h"

extern char version[];
extern char patchlevel[];
extern char date[];
extern char jday_copyright[];

static void
Version() {
fprintf(stderr, "j2d - version %s - %s\n", version, date );
fprintf(stderr, "\t%s\n", jday_copyright );
}

static void
shortUsage() {
fprintf(stderr, "usage: j2d [options] <julian date>\n" );
fprintf(stderr, "options:\n");
fprintf(stderr, "\t-v1 = display version 1.3 type of output yyyy/mm/dd\n");
}

static void
Usage() {
shortUsage();
Version();
}

int
main( argc, argv )
int argc;
char * argv[];
{
    int day;
    int mo;
    int hour;
    int minute;
    int year;
    double jd;
    time_t now_time;
    struct tm *local_now;
    struct ut_instant today;
    char * cp;
    int optV1 = 0;	/*	when == 1 => version 1 type of output */

    time ( & now_time);
    local_now = localtime  (& now_time);

    year = local_now->tm_year + 1900;
    mo = local_now->tm_mon + 1;
    day = local_now->tm_mday;
    hour = local_now->tm_hour;
    minute = local_now->tm_min;

    if ( argc > 1 ) {
	/*check for special arguments, steal them out of the command line*/
	int i, j;
	for (i = 0, j = 0; i < argc; ++i) {
	    if ( ! strcmp((const char *)argv[i], (const char *) "-v1") ) {
		optV1 = 1;
	    } else {
		if (j != i) argv[j] = argv[i];
		++j;
	    }
	}
	argc = j;
	switch ( argc ) {
		case 2:
	if ( (char *) NULL != (cp =
		strstr((const char *)argv[1], (const char *) "-h") ) ){
			Usage();
			exit(0);
			/*	NOTREACHED	*/
	}
	if ( (char *) NULL != (cp =
		strstr((const char *)argv[1], (const char *) "-v") ) ){
			Version();
			exit(0);
			/*	NOTREACHED	*/
	}
			jd = atof( argv[1] );
			break;
		default:
			Usage();
			exit( 0 );
			/*	NOTREACHED	*/
			break;
	}
    } else {
	    shortUsage();
	    exit( 0 );
	    /*	NOTREACHED	*/
    }

/*	clear the today structure	*/

    today.year = 0;
    today.month = 0;
    today.day = 0;
    today.i_hour = 0;
    today.i_minute = 0;
    today.second = 0.0;
    today.d_hour = 0;
    today.d_minute = 0;
    today.weekday = 7;
    today.day_of_year = 0;
    today.j_date = 2147483647;
    today.j_date = (today.j_date * 2.0) + 1.0;

    today.j_date = jd;
    (void) CalDate( & today );

    if (optV1)
	printf( "%d/%02d/%02d", today.year, today.month, today.day);
    else
	printf( "%d-%02d-%02d", today.year, today.month, today.day);

    printf( " %02d:%02d:%02d\n", today.i_hour, today.i_minute,
	    (int)(today.second + 0.5) );

    exit( 0 );
    /*	NOTREACHED	*/
}
