/*
 * Copyright @ 2018 - present 8x8, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.jitsi.videobridge.rest.exceptions;

import jakarta.servlet.http.*;
import jakarta.ws.rs.*;
import jakarta.ws.rs.core.*;

/**
 * The ctor for {@link BadRequestException} which takes in a String doesn't
 * actually include that String in the response.  A much longer syntax (seen
 * in the constructor below) is necessary.  This class exists in order to expose
 * that behavior in a more concise way
 */
public class BadRequestExceptionWithMessage extends BadRequestException
{
    public BadRequestExceptionWithMessage(String message)
    {
        super(Response.status(HttpServletResponse.SC_BAD_REQUEST, message).build());
    }
}
