/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.dependency.resolvers;

import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.artifact.filter.collection.AbstractArtifactsFilter;
import org.apache.maven.shared.artifact.filter.collection.ArtifactFilterException;

public class ExcludeReactorProjectsArtifactFilter
extends AbstractArtifactsFilter {
    private final Log log;
    private final Set<String> reactorArtifactKeys;

    public ExcludeReactorProjectsArtifactFilter(List<MavenProject> reactorProjects, Log log) {
        this.log = log;
        this.reactorArtifactKeys = new HashSet<String>(reactorProjects.size());
        for (MavenProject project : reactorProjects) {
            this.reactorArtifactKeys.add(ArtifactUtils.key((Artifact)project.getArtifact()));
        }
    }

    public Set<Artifact> filter(Set<Artifact> artifacts) throws ArtifactFilterException {
        LinkedHashSet<Artifact> results = new LinkedHashSet<Artifact>(artifacts.size());
        for (Artifact artifact : artifacts) {
            if (!this.isArtifactInReactor(artifact)) {
                results.add(artifact);
                continue;
            }
            if (!this.log.isDebugEnabled()) continue;
            this.log.debug((CharSequence)("Skipped artifact " + ArtifactUtils.key((Artifact)artifact) + " because it is present in the reactor"));
        }
        return results;
    }

    private boolean isArtifactInReactor(Artifact artifact) {
        for (String reactorArtifactKey : this.reactorArtifactKeys) {
            String artifactKey;
            if (!reactorArtifactKey.equals(artifactKey = ArtifactUtils.key((Artifact)artifact))) continue;
            return true;
        }
        return false;
    }
}

