/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.antrun;

import java.io.File;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.plugins.antrun.AntrunXmlPlexusConfigurationWriter;
import org.apache.maven.plugins.antrun.MavenAntRunProject;
import org.apache.maven.plugins.antrun.MavenLogger;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.DefaultLogger;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;
import org.apache.tools.ant.taskdefs.Typedef;
import org.apache.tools.ant.types.Path;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.StringUtils;

@Mojo(name="run", threadSafe=true, requiresDependencyResolution=ResolutionScope.TEST)
public class AntRunMojo
extends AbstractMojo {
    public static final String MAVEN_REFID_PREFIX = "maven.";
    public static final String DEFAULT_MAVEN_PROJECT_REFID = "maven.project";
    public static final String DEFAULT_MAVEN_PROJECT_REF_REFID = "maven.project.ref";
    public static final String DEFAULT_MAVEN_PROJECT_HELPER_REFID = "maven.project.helper";
    public static final String DEFAULT_ANT_TARGET_NAME = "main";
    public static final String UTF_8 = "UTF-8";
    public static final String ANTLIB = "org/apache/maven/ant/tasks/antlib.xml";
    public static final String TASK_URI = "antlib:org.apache.maven.ant.tasks";
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject mavenProject;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    private MavenSession session;
    @Component
    private MavenProjectHelper projectHelper;
    @Parameter(property="plugin.artifacts", required=true, readonly=true)
    private List<Artifact> pluginArtifacts;
    @Parameter(property="localRepository", readonly=true)
    protected ArtifactRepository localRepository;
    @Parameter(defaultValue="")
    private String propertyPrefix;
    @Deprecated
    @Parameter
    private String customTaskPrefix;
    @Parameter(defaultValue="maven.project.dependencies.versions")
    private String versionsPropertyName;
    @Deprecated
    @Parameter
    private PlexusConfiguration tasks;
    @Parameter
    private PlexusConfiguration target;
    @Deprecated
    @Parameter(property="sourceRoot")
    private File sourceRoot;
    @Deprecated
    @Parameter(property="testSourceRoot")
    private File testSourceRoot;
    @Parameter(property="maven.antrun.skip", defaultValue="false")
    private boolean skip;
    @Parameter(defaultValue="false")
    private boolean exportAntProperties;
    @Parameter(defaultValue="true")
    private boolean failOnError;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.checkDeprecatedParameterUsage(this.tasks, "tasks", "target");
        this.checkDeprecatedParameterUsage(this.sourceRoot, "sourceRoot", "the build-helper-maven-plugin");
        this.checkDeprecatedParameterUsage(this.testSourceRoot, "testSourceRoot", "the build-helper-maven-plugin");
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping Antrun execution");
            return;
        }
        if (this.target == null) {
            this.getLog().info((CharSequence)"No Ant target defined - SKIPPED");
            return;
        }
        if (this.propertyPrefix == null) {
            this.propertyPrefix = "";
        }
        String antTargetName = this.target.getAttribute("name", DEFAULT_ANT_TARGET_NAME);
        this.target.setAttribute("name", antTargetName);
        Project antProject = new Project();
        antProject.addBuildListener((BuildListener)this.getConfiguredBuildLogger());
        try {
            File antBuildFile = this.writeTargetToProjectFile(antTargetName);
            ProjectHelper.configureProject((Project)antProject, (File)antBuildFile);
            antProject.init();
            antProject.setBaseDir(this.mavenProject.getBasedir());
            this.addAntProjectReferences(this.mavenProject, antProject);
            this.initMavenTasks(antProject);
            this.copyProperties(this.mavenProject, antProject);
            this.getLog().info((CharSequence)"Executing tasks");
            antProject.executeTarget(antTargetName);
            this.getLog().info((CharSequence)"Executed tasks");
            this.copyProperties(antProject, this.mavenProject);
        }
        catch (BuildException e) {
            StringBuilder sb = new StringBuilder();
            sb.append("An Ant BuildException has occured: ").append(e.getMessage());
            String fragment = this.findFragment(e);
            if (fragment != null) {
                sb.append("\n").append(fragment);
            }
            if (!this.failOnError) {
                this.getLog().info((CharSequence)sb.toString(), (Throwable)e);
                return;
            }
            throw new MojoExecutionException(sb.toString(), (Exception)((Object)e));
        }
        catch (Throwable e) {
            throw new MojoExecutionException("Error executing Ant tasks: " + e.getMessage(), e);
        }
    }

    private void checkDeprecatedParameterUsage(Object parameter, String name, String replacement) throws MojoFailureException {
        if (parameter != null) {
            throw new MojoFailureException("You are using '" + name + "' which has been removed from the maven-antrun-plugin. Please use '" + replacement + "' and refer to the >>Major Version Upgrade to version 3.0.0<< on the plugin site.");
        }
    }

    private DefaultLogger getConfiguredBuildLogger() {
        MavenLogger antLogger = new MavenLogger(this.getLog());
        if (this.getLog().isDebugEnabled()) {
            antLogger.setMessageOutputLevel(4);
        } else if (this.getLog().isInfoEnabled()) {
            antLogger.setMessageOutputLevel(2);
        } else if (this.getLog().isWarnEnabled()) {
            antLogger.setMessageOutputLevel(1);
        } else if (this.getLog().isErrorEnabled()) {
            antLogger.setMessageOutputLevel(0);
        } else {
            antLogger.setMessageOutputLevel(3);
        }
        return antLogger;
    }

    private void addAntProjectReferences(MavenProject mavenProject, Project antProject) throws DependencyResolutionRequiredException {
        Path p = new Path(antProject);
        p.setPath(StringUtils.join(mavenProject.getCompileClasspathElements().iterator(), (String)File.pathSeparator));
        antProject.addReference("maven.dependency.classpath", (Object)p);
        antProject.addReference("maven.compile.classpath", (Object)p);
        p = new Path(antProject);
        p.setPath(StringUtils.join(mavenProject.getRuntimeClasspathElements().iterator(), (String)File.pathSeparator));
        antProject.addReference("maven.runtime.classpath", (Object)p);
        p = new Path(antProject);
        p.setPath(StringUtils.join(mavenProject.getTestClasspathElements().iterator(), (String)File.pathSeparator));
        antProject.addReference("maven.test.classpath", (Object)p);
        antProject.addReference("maven.plugin.classpath", (Object)this.getPathFromArtifacts(this.pluginArtifacts, antProject));
        antProject.addReference(DEFAULT_MAVEN_PROJECT_REFID, (Object)mavenProject);
        antProject.addReference(DEFAULT_MAVEN_PROJECT_REF_REFID, (Object)new MavenAntRunProject(mavenProject));
        antProject.addReference(DEFAULT_MAVEN_PROJECT_HELPER_REFID, (Object)this.projectHelper);
        antProject.addReference("maven.local.repository", (Object)this.localRepository);
    }

    private Path getPathFromArtifacts(Collection<Artifact> artifacts, Project antProject) throws DependencyResolutionRequiredException {
        if (artifacts == null) {
            return new Path(antProject);
        }
        ArrayList<String> list = new ArrayList<String>(artifacts.size());
        for (Artifact a : artifacts) {
            File file = a.getFile();
            if (file == null) {
                throw new DependencyResolutionRequiredException(a);
            }
            list.add(file.getPath());
        }
        Path p = new Path(antProject);
        p.setPath(StringUtils.join(list.iterator(), (String)File.pathSeparator));
        return p;
    }

    public void copyProperties(MavenProject mavenProject, Project antProject) {
        Properties mavenProps = mavenProject.getProperties();
        Properties userProps = this.session.getUserProperties();
        ArrayList<String> allPropertyKeys = new ArrayList<String>(mavenProps.stringPropertyNames());
        allPropertyKeys.addAll(userProps.stringPropertyNames());
        for (String string : allPropertyKeys) {
            String value = userProps.getProperty(string, mavenProps.getProperty(string));
            antProject.setProperty(string, value);
        }
        antProject.setProperty("ant.file", mavenProject.getFile().getAbsolutePath());
        this.getLog().debug((CharSequence)("Setting properties with prefix: " + this.propertyPrefix));
        antProject.setProperty(this.propertyPrefix + "project.groupId", mavenProject.getGroupId());
        antProject.setProperty(this.propertyPrefix + "project.artifactId", mavenProject.getArtifactId());
        antProject.setProperty(this.propertyPrefix + "project.name", mavenProject.getName());
        if (mavenProject.getDescription() != null) {
            antProject.setProperty(this.propertyPrefix + "project.description", mavenProject.getDescription());
        }
        antProject.setProperty(this.propertyPrefix + "project.version", mavenProject.getVersion());
        antProject.setProperty(this.propertyPrefix + "project.packaging", mavenProject.getPackaging());
        antProject.setProperty(this.propertyPrefix + "project.build.directory", mavenProject.getBuild().getDirectory());
        antProject.setProperty(this.propertyPrefix + "project.build.outputDirectory", mavenProject.getBuild().getOutputDirectory());
        antProject.setProperty(this.propertyPrefix + "project.build.testOutputDirectory", mavenProject.getBuild().getTestOutputDirectory());
        antProject.setProperty(this.propertyPrefix + "project.build.sourceDirectory", mavenProject.getBuild().getSourceDirectory());
        antProject.setProperty(this.propertyPrefix + "project.build.testSourceDirectory", mavenProject.getBuild().getTestSourceDirectory());
        antProject.setProperty(this.propertyPrefix + "localRepository", this.localRepository.toString());
        antProject.setProperty(this.propertyPrefix + "settings.localRepository", this.localRepository.getBasedir());
        Set depArtifacts = mavenProject.getArtifacts();
        for (Artifact artifact : depArtifacts) {
            String propName = artifact.getDependencyConflictId();
            antProject.setProperty(this.propertyPrefix + propName, artifact.getFile().getPath());
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (Artifact artifact : depArtifacts) {
            stringBuilder.append(artifact.getVersion()).append(File.pathSeparator);
        }
        antProject.setProperty(this.versionsPropertyName, stringBuilder.toString());
    }

    public void copyProperties(Project antProject, MavenProject mavenProject) {
        if (!this.exportAntProperties) {
            return;
        }
        this.getLog().debug((CharSequence)"Propagated Ant properties to Maven properties");
        Hashtable antProps = antProject.getProperties();
        Properties mavenProperties = mavenProject.getProperties();
        for (Map.Entry entry : antProps.entrySet()) {
            String key = (String)entry.getKey();
            if (mavenProperties.getProperty(key) != null) {
                this.getLog().debug((CharSequence)("Ant property '" + key + "=" + mavenProperties.getProperty(key) + "' clashs with an existing Maven property, SKIPPING this Ant property propagation."));
                continue;
            }
            mavenProperties.setProperty(key, entry.getValue().toString());
        }
    }

    public void initMavenTasks(Project antProject) {
        this.getLog().debug((CharSequence)"Initialize Maven Ant Tasks");
        Typedef typedef = new Typedef();
        typedef.setProject(antProject);
        typedef.setResource(ANTLIB);
        if (this.getTaskPrefix() != null) {
            typedef.setURI(TASK_URI);
        }
        typedef.execute();
    }

    private File writeTargetToProjectFile(String targetName) throws IOException {
        File buildFile = new File(this.mavenProject.getBuild().getDirectory(), "antrun/build-" + targetName + ".xml");
        buildFile.getParentFile().mkdirs();
        AntrunXmlPlexusConfigurationWriter xmlWriter = new AntrunXmlPlexusConfigurationWriter();
        String taskPrefix = this.getTaskPrefix();
        if (taskPrefix != null) {
            this.target.setAttribute("xmlns:" + taskPrefix, TASK_URI);
        }
        xmlWriter.write(this.target, buildFile, "", targetName);
        return buildFile;
    }

    private String getTaskPrefix() {
        String taskPrefix = this.customTaskPrefix;
        if (taskPrefix == null) {
            for (String name : this.target.getAttributeNames()) {
                if (!name.startsWith("xmlns:") || !"http://maven.apache.org/ANTRUN".equals(this.target.getAttribute(name))) continue;
                taskPrefix = name.substring("xmlns:".length());
                break;
            }
        }
        return taskPrefix;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String findFragment(BuildException buildException) {
        if (buildException == null) return null;
        if (buildException.getLocation() == null) return null;
        if (buildException.getLocation().getFileName() == null) {
            return null;
        }
        File antFile = new File(buildException.getLocation().getFileName());
        if (!antFile.exists()) {
            return null;
        }
        try (LineNumberReader reader = new LineNumberReader((Reader)ReaderFactory.newXmlReader((File)antFile));){
            String line = reader.readLine();
            while (line != null) {
                if (reader.getLineNumber() == buildException.getLocation().getLineNumber()) {
                    String string = "around Ant part ..." + line.trim() + "... @ " + buildException.getLocation().getLineNumber() + ":" + buildException.getLocation().getColumnNumber() + " in " + antFile.getAbsolutePath();
                    return string;
                }
                line = reader.readLine();
            }
            return null;
        }
        catch (Exception e) {
            this.getLog().debug((CharSequence)e.getMessage(), (Throwable)e);
        }
        return null;
    }
}

