/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.client.core.exception;

import com.google.common.base.Preconditions;
import org.sonatype.nexus.client.core.exception.NexusClientException;

public class NexusClientResponseException
extends NexusClientException {
    private final int responseCode;
    private final String reasonPhrase;
    private final String responseBody;

    public NexusClientResponseException(int responseCode, String reasonPhrase, String responseBody) {
        this(null, responseCode, reasonPhrase, responseBody);
    }

    public NexusClientResponseException(String message, int responseCode, String reasonPhrase, String responseBody) {
        super(message == null ? String.format("%s - %s", responseCode, reasonPhrase) : message);
        this.responseCode = responseCode;
        this.reasonPhrase = (String)Preconditions.checkNotNull((Object)reasonPhrase);
        this.responseBody = responseBody;
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    public String getReasonPhrase() {
        return this.reasonPhrase;
    }

    public String getResponseBody() {
        return this.responseBody;
    }
}

