/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.maven.staging.zapper;

import com.google.common.base.Strings;
import java.io.IOException;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.codehaus.plexus.component.annotations.Component;
import org.sonatype.nexus.maven.staging.zapper.Zapper;
import org.sonatype.nexus.maven.staging.zapper.ZapperRequest;
import org.sonatype.spice.zapper.IOSourceListable;
import org.sonatype.spice.zapper.Parameters;
import org.sonatype.spice.zapper.ParametersBuilder;
import org.sonatype.spice.zapper.client.hc4.Hc4Client;
import org.sonatype.spice.zapper.client.hc4.Hc4ClientBuilder;
import org.sonatype.spice.zapper.fs.DirectoryIOSource;

@Component(role=Zapper.class)
public class ZapperImpl
implements Zapper {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deployDirectory(ZapperRequest zapperRequest) throws IOException {
        try {
            HttpHost proxyServer = null;
            BasicCredentialsProvider credentialsProvider = null;
            if (!Strings.isNullOrEmpty((String)zapperRequest.getProxyProtocol())) {
                proxyServer = new HttpHost(zapperRequest.getProxyHost(), zapperRequest.getProxyPort(), zapperRequest.getProxyProtocol());
                if (!Strings.isNullOrEmpty((String)zapperRequest.getProxyUsername())) {
                    UsernamePasswordCredentials proxyCredentials = new UsernamePasswordCredentials(zapperRequest.getProxyUsername(), zapperRequest.getProxyPassword());
                    credentialsProvider = new BasicCredentialsProvider();
                    credentialsProvider.setCredentials(new AuthScope(proxyServer.getHostName(), proxyServer.getPort(), AuthScope.ANY_REALM, proxyServer.getSchemeName()), (Credentials)proxyCredentials);
                }
            }
            if (!Strings.isNullOrEmpty((String)zapperRequest.getRemoteUsername())) {
                UsernamePasswordCredentials remoteCredentials = new UsernamePasswordCredentials(zapperRequest.getRemoteUsername(), zapperRequest.getRemotePassword());
                if (credentialsProvider == null) {
                    credentialsProvider = new BasicCredentialsProvider();
                }
                credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)remoteCredentials);
            }
            Parameters parameters = ParametersBuilder.defaults().build();
            Hc4ClientBuilder clientBuilder = new Hc4ClientBuilder(parameters, zapperRequest.getRemoteUrl());
            if (credentialsProvider != null) {
                clientBuilder.withPreemptiveRealm((CredentialsProvider)credentialsProvider);
            }
            if (proxyServer != null) {
                clientBuilder.withProxy(proxyServer);
            }
            Hc4Client client = clientBuilder.build();
            DirectoryIOSource deployables = new DirectoryIOSource(zapperRequest.getStageRepository());
            try {
                client.upload((IOSourceListable)deployables);
            }
            finally {
                client.close();
            }
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException("Unable to deploy!", e);
        }
    }
}

