/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions;

import java.util.Locale;
import java.util.Map;
import javax.inject.Inject;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.reporting.MavenReportException;
import org.apache.maven.wagon.Wagon;
import org.codehaus.mojo.versions.AbstractVersionsReport;
import org.codehaus.mojo.versions.api.ArtifactVersions;
import org.codehaus.mojo.versions.api.VersionRetrievalException;
import org.codehaus.mojo.versions.reporting.ReportRendererFactory;
import org.codehaus.mojo.versions.reporting.model.ParentUpdatesModel;
import org.codehaus.mojo.versions.utils.DependencyBuilder;
import org.codehaus.plexus.i18n.I18N;
import org.eclipse.aether.RepositorySystem;

@Mojo(name="parent-updates-report", requiresDependencyResolution=ResolutionScope.RUNTIME, threadSafe=true)
public class ParentUpdatesReport
extends AbstractVersionsReport<ParentUpdatesModel> {
    @Inject
    protected ParentUpdatesReport(I18N i18n, ArtifactHandlerManager artifactHandlerManager, RepositorySystem repositorySystem, Map<String, Wagon> wagonMap, ReportRendererFactory rendererFactory) {
        super(i18n, artifactHandlerManager, repositorySystem, wagonMap, rendererFactory);
    }

    public boolean isExternalReport() {
        return false;
    }

    public boolean canGenerateReport() {
        if (this.getProject().getParent() == null) {
            this.getLog().warn((CharSequence)"Project does not have a parent.");
            return false;
        }
        if (this.reactorProjects.contains(this.getProject().getParent())) {
            this.getLog().warn((CharSequence)"Parent project is part of the reactor.");
            return false;
        }
        return true;
    }

    @Override
    protected void doGenerateReport(Locale locale, Sink sink) throws MavenReportException {
        try {
            ArtifactVersions artifactVersions = this.getHelper().lookupArtifactVersions(this.project.getParentArtifact(), false);
            this.rendererFactory.createReportRenderer(this.getOutputName(), sink, locale, new ParentUpdatesModel(DependencyBuilder.newBuilder().withGroupId(artifactVersions.getGroupId()).withArtifactId(artifactVersions.getArtifactId()).withVersion(artifactVersions.getArtifact().getVersion()).withScope(artifactVersions.getArtifact().getScope()).withType(artifactVersions.getArtifact().getType()).withClassifier(artifactVersions.getArtifact().getClassifier()).build(), artifactVersions), this.allowSnapshots).render();
        }
        catch (VersionRetrievalException e) {
            throw new MavenReportException(e.getMessage(), (Exception)((Object)e));
        }
    }

    public String getOutputName() {
        return "parent-updates-report";
    }
}

