/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.client.internal.rest.jersey.subsystem.repository;

import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.client.core.spi.subsystem.repository.RepositoryFactory;
import org.sonatype.nexus.client.core.subsystem.repository.GroupRepository;
import org.sonatype.nexus.client.core.subsystem.repository.Repository;
import org.sonatype.nexus.client.internal.rest.jersey.subsystem.repository.JerseyGroupRepository;
import org.sonatype.nexus.client.rest.jersey.JerseyNexusClient;
import org.sonatype.nexus.rest.model.RepositoryBaseResource;
import org.sonatype.nexus.rest.model.RepositoryGroupResource;

@Named
@Singleton
public class JerseyGroupRepositoryFactory
implements RepositoryFactory<GroupRepository> {
    @Override
    public int canAdapt(RepositoryBaseResource resource) {
        int score = 0;
        if (resource instanceof RepositoryGroupResource) {
            ++score;
        }
        if ("group".equals(resource.getRepoType())) {
            ++score;
        }
        return score;
    }

    @Override
    public JerseyGroupRepository adapt(JerseyNexusClient nexusClient, RepositoryBaseResource resource) {
        return new JerseyGroupRepository(nexusClient, (RepositoryGroupResource)resource);
    }

    @Override
    public boolean canCreate(Class<? extends Repository> type) {
        return GroupRepository.class.equals(type);
    }

    @Override
    public JerseyGroupRepository create(JerseyNexusClient nexusClient, String id) {
        return new JerseyGroupRepository(nexusClient, id);
    }
}

