/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.enforcer.rules;

import java.text.ChoiceFormat;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.enforcer.rule.api.EnforcerLevel;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rules.AbstractStandardEnforcerRule;
import org.apache.maven.model.Dependency;
import org.apache.maven.project.MavenProject;

@Named(value="requireExplicitDependencyScope")
public final class RequireExplicitDependencyScope
extends AbstractStandardEnforcerRule {
    private final MavenProject project;

    @Inject
    public RequireExplicitDependencyScope(MavenProject project) {
        this.project = Objects.requireNonNull(project);
    }

    public void execute() throws EnforcerRuleException {
        int numMissingDependencyScopes = 0;
        List dependencies = this.project.getOriginalModel().getDependencies();
        for (Dependency dependency : dependencies) {
            this.getLog().debug((CharSequence)("Found dependency " + dependency));
            if (dependency.getScope() != null) continue;
            this.getLog().warnOrError(() -> new StringBuilder().append("Dependency ").append(dependency.getManagementKey()).append(" @ ").append(RequireExplicitDependencyScope.formatLocation(this.project, dependency.getLocation((Object)""))).append(" does not have an explicit scope defined!"));
            ++numMissingDependencyScopes;
        }
        if (numMissingDependencyScopes > 0) {
            ChoiceFormat scopesFormat = new ChoiceFormat("1#scope|1<scopes");
            String logCategory = this.getLevel() == EnforcerLevel.ERROR ? "errors" : "warnings";
            throw new EnforcerRuleException("Found " + numMissingDependencyScopes + " missing dependency " + scopesFormat.format(numMissingDependencyScopes) + ". Look at the " + logCategory + " emitted above for the details.");
        }
    }
}

