/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.enforcer.rules;

import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rules.AbstractStandardEnforcerRule;
import org.apache.maven.model.Prerequisites;
import org.apache.maven.project.MavenProject;

@Named(value="requirePrerequisite")
public final class RequirePrerequisite
extends AbstractStandardEnforcerRule {
    private List<String> packagings;
    private String mavenVersion;
    private final MavenProject project;

    @Inject
    public RequirePrerequisite(MavenProject project) {
        this.project = Objects.requireNonNull(project);
    }

    public void setMavenVersion(String mavenVersion) {
        this.mavenVersion = mavenVersion;
    }

    public void setPackagings(List<String> packagings) {
        this.packagings = packagings;
    }

    public void execute() throws EnforcerRuleException {
        try {
            if ("pom".equals(this.project.getPackaging())) {
                this.getLog().debug((CharSequence)"Packaging is pom, skipping requirePrerequisite rule");
                return;
            }
            if (this.packagings != null && !this.packagings.contains(this.project.getPackaging())) {
                this.getLog().debug((CharSequence)("Packaging is " + this.project.getPackaging() + ", skipping requirePrerequisite rule"));
                return;
            }
            Prerequisites prerequisites = this.project.getPrerequisites();
            if (prerequisites == null) {
                throw new EnforcerRuleException("Requires prerequisite not set");
            }
            if (this.mavenVersion != null) {
                VersionRange specifiedVersion;
                VersionRange restrictedVersionRange;
                VersionRange requiredVersionRange = VersionRange.createFromVersionSpec((String)this.mavenVersion);
                if (!requiredVersionRange.hasRestrictions()) {
                    requiredVersionRange = VersionRange.createFromVersionSpec((String)("[" + this.mavenVersion + ",)"));
                }
                if ((restrictedVersionRange = requiredVersionRange.restrict(specifiedVersion = VersionRange.createFromVersionSpec((String)prerequisites.getMaven()))).getRecommendedVersion() == null) {
                    throw new EnforcerRuleException("The specified Maven prerequisite( " + specifiedVersion + " ) doesn't match the required version: " + this.mavenVersion);
                }
            }
        }
        catch (InvalidVersionSpecificationException e) {
            throw new EnforcerRuleException(e.getMessage(), (Exception)((Object)e));
        }
    }

    public String toString() {
        return String.format("RequirePrerequisite[packagings=%s, mavenVersion=%s]", this.packagings, this.mavenVersion);
    }
}

