/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.metrics;

import io.sentry.MeasurementUnit;
import io.sentry.metrics.GaugeMetric;
import io.sentry.metrics.MetricType;
import io.sentry.metrics.MetricsHelper;
import io.sentry.protocol.MetricSummary;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class LocalMetricsAggregator {
    @NotNull
    private final Map<String, Map<String, GaugeMetric>> buckets = new HashMap<String, Map<String, GaugeMetric>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(@NotNull String bucketKey, @NotNull MetricType type, @NotNull String key, double value, @Nullable MeasurementUnit unit, @Nullable Map<String, String> tags) {
        @NotNull String exportKey = MetricsHelper.getExportKey(type, key, unit);
        Map<String, Map<String, GaugeMetric>> map = this.buckets;
        synchronized (map) {
            GaugeMetric gauge;
            @Nullable Map<String, GaugeMetric> bucket = this.buckets.get(exportKey);
            if (bucket == null) {
                bucket = new HashMap<String, GaugeMetric>();
                this.buckets.put(exportKey, bucket);
            }
            if ((gauge = bucket.get(bucketKey)) == null) {
                gauge = new GaugeMetric(key, value, unit, tags);
                bucket.put(bucketKey, gauge);
            } else {
                gauge.add(value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Map<String, List<MetricSummary>> getSummaries() {
        @NotNull HashMap<String, List<MetricSummary>> summaries = new HashMap<String, List<MetricSummary>>();
        Map<String, Map<String, GaugeMetric>> map = this.buckets;
        synchronized (map) {
            for (Map.Entry<String, Map<String, GaugeMetric>> entry : this.buckets.entrySet()) {
                @NotNull String exportKey = Objects.requireNonNull(entry.getKey());
                @NotNull ArrayList<MetricSummary> metricSummaries = new ArrayList<MetricSummary>();
                for (GaugeMetric gauge : entry.getValue().values()) {
                    metricSummaries.add(new MetricSummary(gauge.getMin(), gauge.getMax(), gauge.getSum(), gauge.getCount(), gauge.getTags()));
                }
                summaries.put(exportKey, metricSummaries);
            }
        }
        return summaries;
    }
}

