/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.spice.zapper.internal;

import org.sonatype.spice.zapper.CodecSelector;
import org.sonatype.spice.zapper.Parameters;
import org.sonatype.spice.zapper.hash.HashAlgorithm;
import org.sonatype.spice.zapper.internal.Check;

public class ParametersImpl
implements Parameters {
    private final HashAlgorithm hashAlgorithm;
    private final CodecSelector codecSelector;
    private final int maximumTrackCount;
    private final long maximumSegmentLength;

    public ParametersImpl(HashAlgorithm hashAlgorithm, CodecSelector codecSelector, int maximumTrackCount, long maximumSegmentLength) {
        this.hashAlgorithm = Check.notNull(hashAlgorithm, HashAlgorithm.class);
        this.codecSelector = Check.notNull(codecSelector, CodecSelector.class);
        this.maximumTrackCount = Check.argument(maximumTrackCount > 0, maximumTrackCount, "maximumTrackCount must be positive!");
        this.maximumSegmentLength = Check.argument(maximumSegmentLength > 0L, maximumSegmentLength, "maximumSegmentLength must be positive!");
    }

    public HashAlgorithm getHashAlgorithm() {
        return this.hashAlgorithm;
    }

    public CodecSelector getCodecSelector() {
        return this.codecSelector;
    }

    public int getMaximumTrackCount() {
        return this.maximumTrackCount;
    }

    public long getMaximumSegmentLength() {
        return this.maximumSegmentLength;
    }
}

