/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna.platform.win32;

import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinBase;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.platform.win32.Winspool;
import com.sun.jna.platform.win32.WinspoolUtil;
import java.text.DateFormat;

public class Win32SpoolMonitor {
    public Win32SpoolMonitor() {
        String pPrinterName = "HP Color LaserJet CM4730 MFP PCL 6";
        WinNT.HANDLEByReference phPrinter = new WinNT.HANDLEByReference();
        Winspool.INSTANCE.OpenPrinter(pPrinterName, phPrinter, null);
        WinNT.HANDLE chgObject = Winspool.INSTANCE.FindFirstPrinterChangeNotification(phPrinter.getValue(), 65280, 0, null);
        if (chgObject != null) {
            WinDef.DWORDByReference pdwChange;
            boolean fcnreturn;
            do {
                Kernel32.INSTANCE.WaitForSingleObject(chgObject, -1);
            } while (!(fcnreturn = Winspool.INSTANCE.FindNextPrinterChangeNotification(chgObject, pdwChange = new WinDef.DWORDByReference(), null, null)));
            Winspool.JOB_INFO_1[] jobInfo1 = WinspoolUtil.getJobInfo1(phPrinter);
            for (int i = 0; i < jobInfo1.length; ++i) {
                this.printJobInfo(jobInfo1[i]);
            }
            Winspool.INSTANCE.FindClosePrinterChangeNotification(chgObject);
        } else {
            this.getLastError();
        }
    }

    public int getLastError() {
        int rc = Kernel32.INSTANCE.GetLastError();
        if (rc != 0) {
            System.out.println("error: " + rc);
        }
        return rc;
    }

    private void printJobInfo(Winspool.JOB_INFO_1 jobInfo1) {
        WinBase.FILETIME lpFileTime = new WinBase.FILETIME();
        Kernel32.INSTANCE.SystemTimeToFileTime(jobInfo1.Submitted, lpFileTime);
        String info = "JobId: " + jobInfo1.JobId + "\npDatatype: " + jobInfo1.pDatatype + "\nPagesPrinted: " + jobInfo1.PagesPrinted + "\npDocument: " + jobInfo1.pDocument + "\npMachineName: " + jobInfo1.pMachineName + "\nPosition: " + jobInfo1.Position + "\npPrinterName: " + jobInfo1.pPrinterName + "\nPriority: " + jobInfo1.Priority + "\npStatus: " + jobInfo1.pStatus + "\npUserName: " + jobInfo1.pUserName + "\nStatus: " + jobInfo1.Status + "\nTotalPages: " + jobInfo1.TotalPages + "\nSubmitted: " + DateFormat.getDateTimeInstance().format(lpFileTime.toDate());
        System.out.println(info);
    }

    public static void main(String[] args) {
        new Win32SpoolMonitor();
    }
}

