/*
 * Decompiled with CFR 0.152.
 */
package clover.com.google.gson;

import clover.com.google.gson.JsonArray;
import clover.com.google.gson.JsonArrayDeserializationVisitor;
import clover.com.google.gson.JsonDeserializationContext;
import clover.com.google.gson.JsonDeserializer;
import clover.com.google.gson.JsonElement;
import clover.com.google.gson.JsonObject;
import clover.com.google.gson.JsonObjectDeserializationVisitor;
import clover.com.google.gson.JsonParseException;
import clover.com.google.gson.JsonPrimitive;
import clover.com.google.gson.MappedObjectConstructor;
import clover.com.google.gson.ObjectConstructor;
import clover.com.google.gson.ObjectNavigator;
import clover.com.google.gson.ObjectNavigatorFactory;
import clover.com.google.gson.ParameterizedTypeHandlerMap;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class JsonDeserializationContextDefault
implements JsonDeserializationContext {
    private final ObjectNavigatorFactory navigatorFactory;
    private final ParameterizedTypeHandlerMap<JsonDeserializer<?>> deserializers;
    private final MappedObjectConstructor objectConstructor;

    JsonDeserializationContextDefault(ObjectNavigatorFactory navigatorFactory, ParameterizedTypeHandlerMap<JsonDeserializer<?>> deserializers, MappedObjectConstructor objectConstructor) {
        this.navigatorFactory = navigatorFactory;
        this.deserializers = deserializers;
        this.objectConstructor = objectConstructor;
    }

    ObjectConstructor getObjectConstructor() {
        return this.objectConstructor;
    }

    @Override
    public <T> T deserialize(JsonElement json, Object typeOfT) throws JsonParseException {
        if (json.isJsonArray()) {
            return this.fromJsonArray(typeOfT, json.getAsJsonArray(), this);
        }
        if (json.isJsonObject()) {
            return this.fromJsonObject(typeOfT, json.getAsJsonObject(), this);
        }
        if (json.isJsonPrimitive()) {
            return this.fromJsonPrimitive(typeOfT, json.getAsJsonPrimitive(), this);
        }
        if (json.isJsonNull()) {
            return null;
        }
        throw new JsonParseException(new StringBuffer().append("Failed parsing JSON source: ").append(json).append(" to Json").toString());
    }

    private <T> T fromJsonArray(Object arrayType, JsonArray jsonArray, JsonDeserializationContext context) throws JsonParseException {
        JsonArrayDeserializationVisitor visitor = new JsonArrayDeserializationVisitor(jsonArray, arrayType, this.navigatorFactory, (ObjectConstructor)this.objectConstructor, this.deserializers, context);
        ObjectNavigator on = this.navigatorFactory.create(null, arrayType);
        on.accept(visitor);
        return visitor.getTarget();
    }

    private <T> T fromJsonObject(Object typeOfT, JsonObject jsonObject, JsonDeserializationContext context) throws JsonParseException {
        JsonObjectDeserializationVisitor visitor = new JsonObjectDeserializationVisitor(jsonObject, typeOfT, this.navigatorFactory, this.objectConstructor, this.deserializers, context);
        ObjectNavigator on = this.navigatorFactory.create(null, typeOfT);
        on.accept(visitor);
        return visitor.getTarget();
    }

    private <T> T fromJsonPrimitive(Object typeOfT, JsonPrimitive json, JsonDeserializationContext context) throws JsonParseException {
        JsonObjectDeserializationVisitor visitor = new JsonObjectDeserializationVisitor(json, typeOfT, this.navigatorFactory, this.objectConstructor, this.deserializers, context);
        ObjectNavigator on = this.navigatorFactory.create(json.getAsObject(), typeOfT);
        on.accept(visitor);
        Object target = visitor.getTarget();
        return target;
    }
}

