/*
 * Decompiled with CFR 0.152.
 */
package clover.it.unimi.dsi.fastutil.ints;

import clover.it.unimi.dsi.fastutil.ints.AbstractIntIterator;
import clover.it.unimi.dsi.fastutil.ints.AbstractIntSet;
import clover.it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import clover.it.unimi.dsi.fastutil.ints.IntIterator;
import clover.it.unimi.dsi.fastutil.ints.IntSet;
import clover.it.unimi.dsi.fastutil.objects.AbstractObjectCollection;
import clover.it.unimi.dsi.fastutil.objects.AbstractObjectIterator;
import clover.it.unimi.dsi.fastutil.objects.ObjectCollection;
import clover.it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class AbstractInt2ObjectMap
implements Int2ObjectMap,
Serializable {
    protected Object defRetValue;

    protected AbstractInt2ObjectMap() {
    }

    public void setDefRetValue(Object rv) {
        this.defaultReturnValue(rv);
    }

    public Object getDefRetValue() {
        return this.defaultReturnValue();
    }

    public void defaultReturnValue(Object rv) {
        this.defRetValue = rv;
    }

    public Object defaultReturnValue() {
        return this.defRetValue;
    }

    public Object put(int key, Object value) {
        throw new UnsupportedOperationException();
    }

    public Object remove(int key) {
        throw new UnsupportedOperationException();
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    public Object get(Object ok) {
        int k = (Integer)ok;
        return this.containsKey(k) ? this.get(k) : null;
    }

    public Object put(Object ok, Object ov) {
        int k = (Integer)ok;
        Object v = this.put(k, ov);
        return this.containsKey(k) ? v : null;
    }

    public Object remove(Object ok) {
        int k = (Integer)ok;
        Object v = this.remove(k);
        return this.containsKey(k) ? v : null;
    }

    public boolean containsKey(Object ok) {
        return this.containsKey((Integer)ok);
    }

    public boolean containsValue(Object v) {
        return ((ObjectCollection)this.values()).contains(v);
    }

    public boolean containsKey(int k) {
        return ((IntSet)this.keySet()).contains(k);
    }

    public void putAll(Map m) {
        int n = m.size();
        Iterator i = m.entrySet().iterator();
        if (m instanceof Int2ObjectMap) {
            while (n-- != 0) {
                Int2ObjectMap.Entry e = (Int2ObjectMap.Entry)i.next();
                this.put(e.getIntKey(), e.getValue());
            }
        } else {
            while (n-- != 0) {
                Map.Entry e = i.next();
                this.put(e.getKey(), e.getValue());
            }
        }
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public Set keySet() {
        return new AbstractIntSet(){

            public boolean contains(int k) {
                return AbstractInt2ObjectMap.this.containsKey(k);
            }

            public int size() {
                return AbstractInt2ObjectMap.this.size();
            }

            public IntIterator intIterator() {
                return new AbstractIntIterator(){
                    final Iterator i;
                    {
                        this.i = AbstractInt2ObjectMap.this.entrySet().iterator();
                    }

                    public int nextInt() {
                        return ((Int2ObjectMap.Entry)this.i.next()).getIntKey();
                    }

                    public boolean hasNext() {
                        return this.i.hasNext();
                    }
                };
            }
        };
    }

    public Collection values() {
        return new AbstractObjectCollection(){

            public boolean contains(Object k) {
                return AbstractInt2ObjectMap.this.containsValue(k);
            }

            public int size() {
                return AbstractInt2ObjectMap.this.size();
            }

            public ObjectIterator objectIterator() {
                return new AbstractObjectIterator(){
                    final Iterator i;
                    {
                        this.i = AbstractInt2ObjectMap.this.entrySet().iterator();
                    }

                    public Object next() {
                        return ((Int2ObjectMap.Entry)this.i.next()).getValue();
                    }

                    public boolean hasNext() {
                        return this.i.hasNext();
                    }
                };
            }
        };
    }

    public int hashCode() {
        int h = 0;
        int n = this.size();
        Iterator i = this.entrySet().iterator();
        while (n-- != 0) {
            h += ((Object)i.next()).hashCode();
        }
        return h;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map m = (Map)o;
        if (m.size() != this.size()) {
            return false;
        }
        return this.entrySet().containsAll(m.entrySet());
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        Iterator i = this.entrySet().iterator();
        int n = this.size();
        boolean first = true;
        s.append("{");
        while (n-- != 0) {
            if (first) {
                first = false;
            } else {
                s.append(", ");
            }
            Int2ObjectMap.Entry e = (Int2ObjectMap.Entry)i.next();
            s.append(String.valueOf(e.getIntKey()));
            s.append("=>");
            if (this == e.getValue()) {
                s.append("(this map)");
                continue;
            }
            s.append(String.valueOf(e.getValue()));
        }
        s.append("}");
        return s.toString();
    }

    public static class BasicEntry
    implements Int2ObjectMap.Entry {
        protected int key;
        protected Object value;

        public BasicEntry(Object key, Object value) {
            this.key = (Integer)key;
            this.value = value;
        }

        public BasicEntry(int key, Object value) {
            this.key = key;
            this.value = value;
        }

        public Object getKey() {
            return new Integer(this.key);
        }

        public int getIntKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object value) {
            throw new UnsupportedOperationException();
        }

        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return this.key == (Integer)e.getKey() && (this.value == null ? e.getValue() == null : this.value.equals(e.getValue()));
        }

        public int hashCode() {
            return this.key ^ (this.value == null ? 0 : this.value.hashCode());
        }

        public String toString() {
            return this.key + "->" + this.value;
        }
    }
}

