/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.instr.tests;

import com.cenqua.clover.registry.Annotation;
import com.cenqua.clover.registry.AnnotationValue;
import com.cenqua.clover.registry.MethodSignature;
import com.cenqua.clover.registry.StringifiedAnnotationValue;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ExpectedExceptionMiner {
    private static final Pattern XDOCLET_NVP_PATTERN = Pattern.compile("\\s*(\\S+)\\s*=\\s*\"([^\"]*)\"");
    private static final Pattern WS_SPLIT_PATTERN = Pattern.compile("\\s+");
    private static final Pattern DOT_SPLIT_PATTERN = Pattern.compile("\\.");

    public static String[] extractExpectedExceptionsFor(MethodSignature sig, boolean checkAnnotations, boolean checkTags) {
        HashSet exceptionNames = new HashSet();
        if (checkAnnotations) {
            ExpectedExceptionMiner.expectedExceptionsFromAnnotations(sig, exceptionNames);
        }
        if (exceptionNames.size() == 0 && checkTags) {
            ExpectedExceptionMiner.expectedExceptionsFromJavadoc(sig, exceptionNames);
        }
        return exceptionNames.toArray(new String[exceptionNames.size()]);
    }

    private static void expectedExceptionsFromJavadoc(MethodSignature sig, Set exceptionNames) {
        Map<String, List<String>> tags = sig.getTags();
        if (tags != null && tags.size() > 0) {
            ExpectedExceptionMiner.extractExpectedExceptions("testng.test", "expectedExceptions", exceptionNames, tags);
            ExpectedExceptionMiner.extractExpectedExceptions("testng.expected-exceptions", "value", exceptionNames, tags);
        }
    }

    private static void extractExpectedExceptions(String tagName, String attributeName, Set exceptionNames, Map tags) {
        List testTagValues = (List)tags.get(tagName);
        if (testTagValues != null) {
            for (int i = 0; i < testTagValues.size(); ++i) {
                ExpectedExceptionMiner.processTagValue(attributeName, exceptionNames, (String)testTagValues.get(i));
            }
        }
    }

    private static void processTagValue(String attributeName, Set exceptionNames, String testTagValue) {
        Matcher testTagValueMatcher = XDOCLET_NVP_PATTERN.matcher(testTagValue);
        if (testTagValueMatcher.find()) {
            String attrName = testTagValueMatcher.group(1);
            String attrValue = testTagValueMatcher.group(2);
            if (attributeName.equals(attrName)) {
                ExpectedExceptionMiner.processExceptionNames(exceptionNames, attrValue);
            }
        }
    }

    private static void processExceptionNames(Set exceptionNames, String attrValue) {
        String[] classNames = WS_SPLIT_PATTERN.split(attrValue);
        for (int j = 0; j < classNames.length; ++j) {
            if (!ExpectedExceptionMiner.looksLikeFQClassName(classNames[j])) continue;
            exceptionNames.add(classNames[j]);
        }
    }

    private static boolean looksLikeFQClassName(String className) {
        if (className == null) {
            return false;
        }
        String[] parts = DOT_SPLIT_PATTERN.split(className);
        for (int i = 0; i < parts.length; ++i) {
            if (ExpectedExceptionMiner.isIdent(parts[i])) continue;
            return false;
        }
        return true;
    }

    private static void expectedExceptionsFromAnnotations(MethodSignature sig, Set exceptionNames) {
        Annotation specificationAnnotation;
        Annotation expectedExceptionsAnnotation;
        AnnotationValue expectedAttrValue = null;
        Annotation testAnnotation = ExpectedExceptionMiner.findTestAnnotation(sig);
        if (testAnnotation != null) {
            expectedAttrValue = ExpectedExceptionMiner.extractExpectedAttrValue(sig, testAnnotation);
        }
        if (expectedAttrValue == null && (expectedExceptionsAnnotation = ExpectedExceptionMiner.findTestNGExpectedExceptionsAnnotation(sig)) != null) {
            expectedAttrValue = ExpectedExceptionMiner.extractValueAttrValue(sig, expectedExceptionsAnnotation);
        }
        if (expectedAttrValue == null && (expectedExceptionsAnnotation = ExpectedExceptionMiner.findSpringExpectedExceptionsAnnotation(sig)) != null) {
            expectedAttrValue = ExpectedExceptionMiner.extractValueAttrValue(sig, expectedExceptionsAnnotation);
        }
        if (expectedAttrValue == null && (specificationAnnotation = ExpectedExceptionMiner.findSpecificationAnnotation(sig)) != null) {
            expectedAttrValue = ExpectedExceptionMiner.extractExpectedAttrValue(sig, specificationAnnotation);
        }
        if (expectedAttrValue != null) {
            ExpectedExceptionMiner.extractExpectedExceptions(exceptionNames, expectedAttrValue);
        }
    }

    private static Annotation findTestAnnotation(MethodSignature sig) {
        Annotation testAnnotation = sig.getModifiers().getAnnotation("org.junit.Test");
        testAnnotation = testAnnotation != null ? testAnnotation : sig.getModifiers().getAnnotation("org.testng.annotations.Test");
        testAnnotation = testAnnotation != null ? testAnnotation : sig.getModifiers().getAnnotation("Test");
        return testAnnotation;
    }

    private static Annotation findTestNGExpectedExceptionsAnnotation(MethodSignature sig) {
        return ExpectedExceptionMiner.findAnnotationValue(sig, "ExpectedExceptions", "org.testng.annotations.ExpectedExceptions");
    }

    private static Annotation findSpringExpectedExceptionsAnnotation(MethodSignature sig) {
        return ExpectedExceptionMiner.findAnnotationValue(sig, "ExpectedException", "org.springframework.test.annotation.ExpectedException");
    }

    private static Annotation findAnnotationValue(MethodSignature sig, String expectedAnnoName, String fqExpectedAnnoName) {
        Annotation expectedAnnotation = sig.getModifiers().getAnnotation(expectedAnnoName);
        return expectedAnnotation != null ? expectedAnnotation : sig.getModifiers().getAnnotation(fqExpectedAnnoName);
    }

    private static Annotation findSpecificationAnnotation(MethodSignature sig) {
        return ExpectedExceptionMiner.findAnnotationValue(sig, "com.googlecode.instinct.marker.annotate.Specification", "Specification");
    }

    private static AnnotationValue extractExpectedAttrValue(MethodSignature sig, Annotation testAnnotation) {
        AnnotationValue value = testAnnotation.getAttribute("expectedExceptions");
        value = value != null ? value : testAnnotation.getAttribute("expected");
        return value != null ? value : testAnnotation.getAttribute("expectedException");
    }

    private static AnnotationValue extractValueAttrValue(MethodSignature sig, Annotation expectedExceptionsAnnotation) {
        return expectedExceptionsAnnotation.getAttribute("value");
    }

    private static void extractExpectedExceptions(Set exceptionNames, AnnotationValue expectedAttrValue) {
        List exceptionsNameValues = expectedAttrValue.toList();
        for (int i = 0; i < exceptionsNameValues.size(); ++i) {
            StringifiedAnnotationValue classNameValue;
            String className;
            AnnotationValue exceptionName = (AnnotationValue)exceptionsNameValues.get(i);
            if (!(exceptionName instanceof StringifiedAnnotationValue) || (className = ExpectedExceptionMiner.stripClassNameFromDotClassExpression(classNameValue = (StringifiedAnnotationValue)exceptionName)) == null) continue;
            exceptionNames.add(className);
        }
    }

    private static String stripClassNameFromDotClassExpression(StringifiedAnnotationValue classNameValue) {
        String[] parts = DOT_SPLIT_PATTERN.split(classNameValue.getValue());
        for (int i = 0; i < parts.length; ++i) {
            if (ExpectedExceptionMiner.isIdent(parts[i])) continue;
            return null;
        }
        return classNameValue.getValue().endsWith(".class") ? classNameValue.getValue().substring(0, classNameValue.getValue().lastIndexOf(".class")) : classNameValue.getValue();
    }

    private static boolean isIdent(String ident) {
        if (ident == null || ident.length() == 0 || !Character.isJavaIdentifierStart(ident.charAt(0))) {
            return false;
        }
        for (int i = 1; i < ident.length(); ++i) {
            if (Character.isJavaIdentifierPart(ident.charAt(i))) continue;
            return false;
        }
        return true;
    }
}

