/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover.registry;

import com.atlassian.clover.spi.lang.LanguageConstruct;
import com.cenqua.clover.context.ContextSet;
import com.cenqua.clover.context.NamedContext;
import com.cenqua.clover.registry.BasicElementInfo;
import com.cenqua.clover.registry.CoverageDataProvider;
import com.cenqua.clover.registry.CoverageDataReceptor;
import com.cenqua.clover.registry.FileInfo;
import com.cenqua.clover.registry.FileInfoRegion;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ElementInfo<T extends BasicElementInfo>
implements CoverageDataReceptor,
FileInfoRegion {
    protected final T sharedInfo;
    protected ContextSet context;

    protected ElementInfo(ContextSet context, T sharedInfo) {
        this.context = context;
        this.sharedInfo = sharedInfo;
    }

    public ContextSet getContext() {
        return this.context;
    }

    public void setContext(ContextSet context) {
        this.context = context;
    }

    public boolean isFiltered(ContextSet filter) {
        return filter != null && filter.intersects(this.context);
    }

    public void addContext(NamedContext ctx) {
        this.context = this.context.set(ctx.getIndex());
    }

    public int getComplexity() {
        return ((BasicElementInfo)this.sharedInfo).getComplexity();
    }

    public void setComplexity(int complexity) {
        ((BasicElementInfo)this.sharedInfo).setComplexity(complexity);
    }

    public int getHitCount() {
        CoverageDataProvider data = this.getDataProvider();
        if (data == null) {
            return 0;
        }
        return data.getHitCount(this.getDataIndex());
    }

    public int getRelativeDataIndex() {
        return ((BasicElementInfo)this.sharedInfo).getRelativeDataIndex();
    }

    @Override
    public int getDataIndex() {
        return ((FileInfo)this.getContainingFile()).dataIndex + ((BasicElementInfo)this.sharedInfo).getRelativeDataIndex();
    }

    @Override
    public int getStartLine() {
        return ((BasicElementInfo)this.sharedInfo).getStartLine();
    }

    @Override
    public int getStartColumn() {
        return ((BasicElementInfo)this.sharedInfo).getStartColumn();
    }

    @Override
    public int getEndLine() {
        return ((BasicElementInfo)this.sharedInfo).getEndLine();
    }

    @Override
    public int getEndColumn() {
        return ((BasicElementInfo)this.sharedInfo).getEndColumn();
    }

    public LanguageConstruct getConstruct() {
        return ((BasicElementInfo)this.sharedInfo).getConstruct();
    }
}

