/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover.registry;

import com.cenqua.clover.registry.FileMetrics;
import com.cenqua.clover.registry.HasMetrics;

public class PackageMetrics
extends FileMetrics {
    private int numFiles;

    public PackageMetrics(HasMetrics owner) {
        super(owner);
    }

    public String getType() {
        return "package";
    }

    public int getNumFiles() {
        return this.numFiles;
    }

    public void setNumFiles(int numFiles) {
        this.numFiles = numFiles;
    }

    public int getNumChildren() {
        return this.getNumFiles();
    }

    public String getChildType() {
        return super.getType();
    }

    public float getAvgClassesPerFile() {
        return this.getFraction(this.getNumClasses(), this.numFiles);
    }

    public PackageMetrics add(PackageMetrics metrics) {
        super.add(metrics);
        this.numFiles += metrics.numFiles;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PackageMetrics that = (PackageMetrics)o;
        return this.numFiles == that.numFiles;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.numFiles;
        return result;
    }

    public String toString() {
        return "PackageMetrics{numFiles=" + this.numFiles + "} " + super.toString();
    }
}

