/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover.registry;

import com.atlassian.clover.api.registry.ClassInfo;
import com.cenqua.clover.context.ContextSet;
import com.cenqua.clover.registry.BaseFileInfo;
import com.cenqua.clover.registry.BaseProjectInfo;
import com.cenqua.clover.registry.BlockMetrics;
import com.cenqua.clover.registry.CoverageDataProvider;
import com.cenqua.clover.registry.CoverageDataReceptor;
import com.cenqua.clover.registry.FileInfo;
import com.cenqua.clover.registry.FileInfoVisitor;
import com.cenqua.clover.registry.HasMetricsFilter;
import com.cenqua.clover.registry.HasMetricsNode;
import com.cenqua.clover.registry.PackageFragment;
import com.cenqua.clover.registry.PackageInfo;
import com.cenqua.clover.registry.PackageMetrics;
import com.cenqua.clover.registry.ProjectMetrics;
import com.cenqua.clover.util.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectInfo
extends BaseProjectInfo
implements HasMetricsNode,
CoverageDataReceptor,
com.atlassian.clover.api.registry.ProjectInfo {
    private int dataIndex = 0;
    private int dataLength;
    private List orderedPkgs;
    private List orderedPkgRoots;
    private Map roots;
    private boolean fragmented;
    private Comparator orderby;
    private CoverageDataProvider data;
    private boolean hasTestResults;

    public ProjectInfo(String name, long version) {
        super(name, version);
    }

    public ProjectInfo(String name) {
        super(name);
    }

    public PackageFragment[] getPackageRoots() {
        this.ensureRootsBuilt();
        return this.roots.values().toArray(new PackageFragment[this.roots.size()]);
    }

    public ProjectInfo copy() {
        return this.copy(HasMetricsFilter.ACCEPT_ALL);
    }

    public ProjectInfo copy(HasMetricsFilter filter) {
        return this.copy(filter, this.getContextFilter());
    }

    public ProjectInfo copy(HasMetricsFilter filter, ContextSet contextFilter) {
        ProjectInfo proj = new ProjectInfo(this.name);
        proj.setContextFilter(contextFilter);
        proj.setDataProvider(this.getDataProvider());
        proj.setVersion(this.getVersion());
        for (PackageInfo pkgInfo : this.packages.values()) {
            PackageInfo info;
            if (!filter.accept(pkgInfo) || (info = pkgInfo.copy(proj, filter)).isEmpty()) continue;
            proj.addPackage(info);
        }
        proj.setDataLength(this.getDataLength());
        proj.setHasTestResults(this.hasTestResults());
        return proj;
    }

    private void buildPackageTrees() {
        TreeMap tmpRoots = new TreeMap();
        ArrayList tmpOrderedPkgRoots = new ArrayList();
        for (PackageInfo packageInfo : this.packages.values()) {
            this.addPackageToTree(packageInfo, tmpRoots, tmpOrderedPkgRoots);
        }
        if (this.orderby != null) {
            Collections.sort(tmpOrderedPkgRoots, this.orderby);
        }
        this.orderedPkgRoots = tmpOrderedPkgRoots;
        this.roots = tmpRoots;
    }

    private void buildOrderedPackageList() {
        ArrayList tmpOrderedPkgs = new ArrayList(this.packages.values());
        if (this.orderby != null) {
            Collections.sort(tmpOrderedPkgs, this.orderby);
        }
        this.orderedPkgs = tmpOrderedPkgs;
    }

    private void addPackageToTree(PackageInfo pkg, Map roots, List orderedPkgRoots) {
        StringTokenizer pkgfragments = new StringTokenizer(pkg.getName(), ".");
        String qname = "";
        String sep = "";
        PackageFragment currentFrag = null;
        while (pkgfragments.hasMoreTokens()) {
            String frag = pkgfragments.nextToken();
            qname = new StringBuffer().append(qname).append(sep).append(frag).toString();
            sep = ".";
            if (currentFrag == null) {
                PackageFragment root = (PackageFragment)roots.get(frag);
                if (root == null) {
                    root = new PackageFragment(null, this, frag, qname);
                    root.setComparator(this.orderby);
                    roots.put(frag, root);
                    orderedPkgRoots.add(root);
                }
                currentFrag = root;
                continue;
            }
            PackageFragment node = currentFrag.getChild(frag);
            if (node == null) {
                node = new PackageFragment(currentFrag, this, qname, frag);
                node.setComparator(this.orderby);
                currentFrag.addChild(node);
            }
            currentFrag = node;
        }
        if (currentFrag != null) {
            currentFrag.setConcretePackage(pkg);
        }
    }

    public void resolve(final Path sourcePath) {
        this.visitFiles(new FileInfoVisitor(){

            public void visitFileInfo(BaseFileInfo file) {
                ((FileInfo)file).resolve(sourcePath);
            }
        });
    }

    @Override
    public void setDataProvider(CoverageDataProvider data) {
        this.data = data;
        for (PackageInfo pkgInfo : this.packages.values()) {
            pkgInfo.setDataProvider(data);
        }
        this.rawMetrics = null;
        this.metrics = null;
    }

    @Override
    public CoverageDataProvider getDataProvider() {
        return this.data;
    }

    @Override
    public int getDataIndex() {
        return this.dataIndex;
    }

    @Override
    public int getDataLength() {
        return this.dataLength;
    }

    public void setDataLength(int length) {
        this.dataLength = length;
    }

    public void buildCaches() {
        this.buildOrderedPackageList();
        this.buildPackageTrees();
    }

    public boolean isFragmented() {
        return this.fragmented;
    }

    public void setFragmented(boolean fragmented) {
        this.fragmented = fragmented;
    }

    @Override
    public String getChildType() {
        return "package";
    }

    @Override
    public int getNumChildren() {
        if (this.fragmented) {
            this.ensureRootsBuilt();
            return this.roots.size();
        }
        if (this.orderedPkgs == null) {
            this.buildOrderedPackageList();
        }
        return this.orderedPkgs.size();
    }

    @Override
    public HasMetricsNode getChild(int i) {
        if (this.fragmented) {
            this.ensureRootsBuilt();
            return (HasMetricsNode)this.orderedPkgRoots.get(i);
        }
        if (this.orderedPkgs == null) {
            this.buildOrderedPackageList();
        }
        return (HasMetricsNode)this.orderedPkgs.get(i);
    }

    @Override
    public int getIndexOfChild(HasMetricsNode child) {
        if (this.fragmented) {
            this.ensureRootsBuilt();
            return this.orderedPkgs.indexOf(child.getName());
        }
        if (this.orderedPkgs == null) {
            this.buildOrderedPackageList();
        }
        return this.orderedPkgs.indexOf(child.getName());
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public void setComparator(Comparator cmp) {
        this.orderby = cmp;
        this.roots = null;
        this.orderedPkgs = null;
        this.orderedPkgRoots = null;
        for (PackageInfo packageInfo : this.packages.values()) {
            packageInfo.setComparator(cmp);
        }
    }

    @Override
    public void setVersion(final long version) {
        super.setVersion(version);
        this.visitFiles(new FileInfoVisitor(){

            public void visitFileInfo(BaseFileInfo file) {
                ((FileInfo)file).addVersion(version);
            }
        });
    }

    @Override
    public BlockMetrics getMetrics() {
        if (this.metrics == null) {
            this.metrics = this.calcMetrics(true);
        }
        return this.metrics;
    }

    @Override
    public BlockMetrics getRawMetrics() {
        if (this.rawMetrics == null) {
            this.rawMetrics = this.calcMetrics(false);
        }
        return this.rawMetrics;
    }

    public boolean hasTestResults() {
        return this.hasTestResults;
    }

    public void setHasTestResults(boolean hasTestResults) {
        this.hasTestResults = hasTestResults;
    }

    private ProjectMetrics calcMetrics(boolean filter) {
        ProjectMetrics projectMetrics = new ProjectMetrics(this);
        int numPackages = 0;
        for (PackageInfo packageInfo : this.packages.values()) {
            if (!filter) {
                projectMetrics.add((PackageMetrics)packageInfo.getRawMetrics());
            } else {
                projectMetrics.add((PackageMetrics)packageInfo.getMetrics());
            }
            ++numPackages;
        }
        projectMetrics.setNumPackages(numPackages);
        return projectMetrics;
    }

    private void ensureRootsBuilt() {
        if (this.roots == null) {
            this.buildPackageTrees();
        }
    }

    public PackageFragment findPackageFragment(String packageName) {
        String[] names = packageName.split("\\.");
        PackageFragment[] fragments = this.getPackageRoots();
        PackageFragment result = null;
        for (int i = 0; i < names.length; ++i) {
            PackageFragment currentFragment = null;
            String name = names[i];
            for (int j = 0; j < fragments.length; ++j) {
                if (!fragments[j].getName().equals(name)) continue;
                currentFragment = fragments[j];
                break;
            }
            result = currentFragment;
            if (currentFragment == null) break;
            fragments = currentFragment.getChildren();
        }
        return result;
    }

    @Override
    public void invalidateCaches() {
        super.invalidateCaches();
        this.orderedPkgs = null;
        this.orderedPkgRoots = null;
        this.roots = null;
    }

    @Override
    public List<com.atlassian.clover.api.registry.PackageInfo> getAllPackages() {
        return this.getPackages();
    }

    @Override
    public com.atlassian.clover.api.registry.PackageInfo getPackage(String name) {
        return (com.atlassian.clover.api.registry.PackageInfo)((Object)this.getNamedPackage(name));
    }

    @Override
    public ClassInfo getClass(String fqcn) {
        return (ClassInfo)((Object)this.findClass(fqcn));
    }

    @Override
    public com.atlassian.clover.api.registry.FileInfo getFile(String pkgPath) {
        return (FileInfo)this.findFile(pkgPath);
    }
}

